// $Id: Fsa2Dot.java,v 1.14 2003/09/22 21:31:56 hchen Exp $

import java.io.*;
import java.util.*;
import gnu.getopt.*;

/**
 * User application to visualize model FSA
 */
public class Fsa2Dot
{
  static final String optionString = "i:lo:" + Util.getOptionString(),
    optionUsage =
    "Usage: Fsa2Dot [options]\n" +
    "  -i <file>\tRead the input from <file>\n" +
    "  -l\t\tWrite labels\n" +
    "  -o <file>\tWrite the output to <file>\n" +
    Util.getOptionUsage();
  
  public static void main(String[] args) throws IOException
  {
    Fsa fsa;
    String fsaFileName = "-", dotFileName = "-";
    boolean printLabel = false;
    Getopt opt;
    int ch;
    BitSet keyField;

    opt = new Getopt("Fsa2Dot", args, optionString, Util.getLongOpts());
    while ((ch = opt.getopt()) != -1)
    {
      switch(ch)
      {
	case 'l':
	  printLabel = true;
	  break;
	  
	case 'i':
	  fsaFileName = opt.getOptarg();
	  break;
	  
	case 'o':
	  dotFileName = opt.getOptarg();
	  break;
	  
	default:
	  Util.processOption(ch, opt, optionUsage);
      }
    }
    if ((args.length - opt.getOptind()) != 0)
    {
      Util.stderr.println(optionUsage);
      System.exit(1);
    }
    keyField = new BitSet();
    keyField.set(0);
    fsa = new Fsa(new BitSet[] { keyField });
    fsa.read(fsaFileName);
    fsa.writeToDot(dotFileName, printLabel);
  }
}



