// $Id: Input.java,v 1.4 2003/08/02 06:48:50 hchen Exp $

import java.io.*;

abstract class Input
{
  public Input(String filename)
  {
    this.filename = filename;
    eof = false;
    tokenOk = true;
    conversionOk = true;
  }
  
  /**
   * If isOK() == true, return EOL or something else
   * If isOK() == false, the return value is undefined
   * Warning: should not use this method to check hard EOF.  Use isOk() instead.
   */
  abstract public int nextToken() throws IOException;

  /**
   * If isOK() == true, return a token value
   */
  abstract public int tokenValue();

  /**
   * If isOk() == true, return an ast_kind value
   */
  abstract public int byteValue();

  abstract public int intValue();

  abstract public String stringValue();

  abstract public int getLineNumber();

  abstract public void close() throws IOException;

  public String getFileName()
  {
    return filename;
  }

  /**
   * Return false if reach a hard EOF or cannot make a requested conversion
   */
  public boolean isOk()
  {
    return tokenOk && conversionOk;
  }

  /**
   * Return true if we reach a hard EOF
   */
  public boolean isEof()
  {
    return eof;
  }
  
  // Read until an EOL token.
  // Return the number of tokens read. 
  public int skipToEOL() throws IOException
  {
    int i, token;

    for (i = 0;	!isEof(); i++, nextToken())
    {
      token = tokenValue();
      if (isOk() && token == Constants.EOL)
	break;
    }
    
    return i;
  }

  protected boolean eof, // record a hard eof.  Once set, never cleared.
    tokenOk, // record a valid token
    conversionOk; // record a valid conversion

  protected String filename;
}
  
