// $Id: IntHashtable.java,v 1.2 2003/09/22 21:31:56 hchen Exp $

import java.util.*;

public class IntHashtable extends IntHashBase
{
  public IntHashtable(int initCapacity, float loadFactor)
  {
    super(initCapacity, loadFactor);
  }

  public IntHashtable(int initCapacity)
  {
    super(initCapacity);
  }
  
  public final boolean containsKey(int key)
  {
    return containsEntry(key);
  }

  // The user had better verify that the key is not in the hashtable already.
  public final boolean put(int key, Object value)
  {
    return putEntry(new Entry(key, value));
  }

  public final Object get(int key)
  {
    Entry entry;

    entry = (Entry)getEntry(key);
    if (entry == null)
      return null;
    else
      return entry.value;
  }
  
  public final boolean remove(int key)
  {
    return removeEntry(key);
  }

  public static class Entry extends IntHashBase.Entry
  {
    Entry(int key, Object value)
    {
      super(key);
      this.value = value;
    }

    public final Object getValue()
    {
      return value;
    }
    
    private Object value;
  }

  /*
  public void print()
  {
    int i;
    Entry entry;

    for (i = 0; i < buckets.length; i++)
    {
      Util.stdout.print(i + ": ");
      for (entry = (Entry)buckets[i]; entry != null; entry = (Entry)entry.next)
      {
	Util.stdout.print(entry.getKey() + " " + entry.getValue() + ", ");
      }
      Util.stdout.println();
    }
  }
  */
}
