// $Id: PriorityQueue.java,v 1.3 2003/09/22 21:31:57 hchen Exp $

import java.io.*;
import java.util.*;

/**
 * Minimum priority queue
 */
public class PriorityQueue
{
  /**
   * Pre-condition: for each element x in input, x.getIndex() < 0
   */
  public PriorityQueue(Vector input)
  {
    int i;
    
    array = new PQElement[input.size()];
    for (i = 0; i < array.length; i++)
    {
      array[i] = (PQElement)input.get(i);
      array[i].setIndex(i);
    }
    size = array.length;
    for (i = size / 2 - 1; i >= 0; i--)
      heapify(i);
  }

  /**
   * Notify that the element needs to be re-positioned in the heap
   * Pre-condition: element is in this queue
   */
  public void decrease(PQElement element)
  {
    int i, parent;
    PQElement temp;

    i = element.getIndex();
    if (i < 0 || i >= getSize())
      Util.die(Util.INTERNAL, "This element is not in the Priority Queue");
    for (parent = (i + 1) / 2 - 1;
	 i > 0 && array[parent].compareTo(array[i]) > 0;
	 i = parent, parent = (i + 1) / 2 - 1)
    {
      temp = array[i];
      array[i] = array[parent];
      array[parent] = temp;
      array[i].setIndex(i);
      array[parent].setIndex(parent);
    }
  }

  /**
   * Extract the minimum element from the queue.
   * Pre-condition: queue not empty
   */
  public PQElement extract()
  {
    PQElement max;
    
    if (size <= 0)
      Util.die(Util.INTERNAL, "heap underflow");
    max = array[0];
    array[0] = array[size - 1];
    array[0].setIndex(0);
    size--;
    heapify(0);
    // Mark that the extracted element is no longer in the queue
    max.setIndex(-1);
    return max;
  }

  /**
   * Pre-condition: element is not in the queue
   */
  public void add(PQElement element)
  {
    PQElement[] oldArray;
    int index;

    index = element.getIndex();
    if (index >= 0 && index < size)
      Util.die(Util.INTERNAL, "This element is already in Priority Queue");
    
    if (size >= array.length)
    {
      oldArray = array;
      array = new PQElement[oldArray.length * 2];
      System.arraycopy(oldArray, 0, array, 0, oldArray.length);
    }
    array[size] = element;
    element.setIndex(size);
    size++;
    decrease(element);
  }
  
  public int getSize()
  {
    return size;
  }

  public boolean contains(PQElement element)
  {
    int index;

    index = element.getIndex();
    if (index >= 0 && index < size)
    {
      if (array[index] != element)
      {
	Util.die(Util.INTERNAL, "Element is not properly initialized");
	// not reachable
	return false;
      }
      else
	return true;
    }
    else
    {
      return false;
    }
  }

  public void getAll(Vector list)
  {
    int i;
    
    list.setSize(size);
    for (i = 0; i < size; i++)
      list.set(i, array[i]);
  }
  
  void heapify(int index)
  {
    int left, right, smallest, i;
    PQElement temp;
    
    i = index;
    left = i * 2 +1;
    right = left + 1;
    if (left < size && array[left].compareTo(array[i]) < 0)
    {
      smallest = left;
    }
    else
    {
      smallest = i;
    }
    if (right < size && array[right].compareTo(array[smallest]) < 0)
    {
      smallest = right;
    }

    if (smallest != i)
    {
      temp = array[i];
      array[i] = array[smallest];
      array[smallest] = temp;
      array[i].setIndex(i);
      array[smallest].setIndex(smallest);
      heapify(smallest);
    }
  }
  
  PQElement[] array;
  private int size;
}
