// $Id: TextOutput.java,v 1.5 2003/10/21 04:39:32 hchen Exp $

import java.io.*;

class TextOutput extends Output
{
  public TextOutput(PrintWriter writer)
  {
    this.writer = writer;
  }

  public void writeToken(int token) throws IOException
  {
    if (token < 0 || token > Constants.MAX_TOKEN)
      throw new IOException("Token value out of range: " + token);
    writer.print(Constants.tokenLabels[token]);
    switch(token)
    {
      case Constants.EOL:
	// print platform-specific newline
	writer.println();
	break;

      default:
	writer.print(' ');
    }
  }

  public void writeByte(int value) throws IOException
  {
    String label = Constants.kindLabels[value];

    if (label == null)
      label = "(" + value + ")";
    writer.print(label);
    writer.print(' ');
  }

  public void writeInt(int value) throws IOException
  {
    writer.print(value);
    writer.print(' ');
  }

  public void writeString(String string) throws IOException
  {
    writeEscape(writer, string);
    writer.print(' ');
  }

  public void flush() throws IOException
  {
    writer.flush();
  }

  public void close() throws IOException
  {
    writer.close();
  }
  
  /**
   * Escape certain characters to make StreamTokenizer happy
   */
  static final void writeEscape(PrintWriter writer, String str)
  {
    int i, length;
    char ch;
    
    writer.print('"');
    length = str.length();
    if (length > 0)
    {
      for (i = 0; i < length; i++)
      {
	switch((ch = str.charAt(i)))
	{
	  case '\n':
	    writer.print("\\n");
	    break;
	  case '\r':
	    writer.print("\\r");
	    break;
	  case '"':
	    writer.print("\\\"");
	    break;
	  case '\\':
	    writer.print("\\\\");
	    break;
	  default:
	    writer.print(ch);
	}
      }
    }
    writer.print('"');
  }

  PrintWriter writer;
}
