// $Id: TransitionNode.java,v 1.2 2003/09/22 21:31:57 hchen Exp $

import java.util.*;

/**
 * Represents a node in a transition graph.  A node in the transition
 * graph is a transition in the P-Automaton extended with information
 * for backtracking.  An edge in the transition graph contains an AST
 * that causes the program to transit from its preceding node to its
 * suceeding node.  The source nodes in the transition graph are
 * those whose states are the initial states of the PDA and whose
 * program points are the entry points of the program.  The source
 * nodes are created in ModelChecker.createPAutomaton().  The sink
 * nodes are those whose states are the initial states of the
 * P-Automaton (or equivalently, the final states of the PDA)
 */
public class TransitionNode extends FsaTransition implements ShortestPathNode
{
  public TransitionNode()
  {
    super();
    ShortestPathNode(null, null);
  }

  public TransitionNode(int state0, Object input, int state1)
  {
    super(state0, input, state1);
    ShortestPathNode(null, null);
  }

  // fake multiple inheritance
  // begin interface ShortestPathNode
  protected final void ShortestPathNode(Vector inEdges, Vector outEdges)
  {
    NodeBase(inEdges, outEdges);
    PQElement();
    distance = -1;
    parent = null;
  }
  
  // begin interface NodeBase
  protected final void NodeBase(Vector inEdges, Vector outEdges)
  {
    if (inEdges != null)
      this.inEdges = inEdges;
    else
      this.inEdges = new Vector();

    if (outEdges != null)
      this.outEdges = outEdges;
    else
      this.outEdges = new Vector();
  }
  
  public final Vector getInEdges()
  {
    return inEdges;
  }

  public final Vector getOutEdges()
  {
    return outEdges;
  }

  protected Vector inEdges, outEdges;
  // end interface NodeBase

  // begin interface PQElement
  protected final void PQElement()
  {
    index = -1;
  }
  
  // begin interface Comparable
  public int compareTo(Object obj)
  {
    return compareTo((((ShortestPathNode)obj).getDistance()));
  }
  // end interface Comparable

  public void setIndex(int index)
  {
    this.index = index;
  }

  public int getIndex()
  {
    return index;
  }
  
  int index;
  // end interface PQElement

  public final int getDistance()
  {
    return distance;
  }

  public final void setDistance(int distance)
  {
    this.distance = distance;
  }

  public final EdgeBase getParent()
  {
    return parent;
  }

  public final void setParent(EdgeBase parent)
  {
    this.parent = parent;
  }

  /**
   * Returns
   * -1: if this.distance is less than distance2
   * 0: if this.distance equals distance2
   * 1: if this.distance is greater than distance2
   */
  public int compareTo(int distance2)
  {
    if (distance >= 0 && distance2 >= 0)
    {
      if (distance < distance2)
	return -1;
      else if (distance > distance2)
	return 1;
      else
	return 0;
    }
    else if (distance >= 0)
      return -1;
    else if (distance2 >= 0)
      return 1;
    else
      return 0;
  }

  int distance;
  EdgeBase parent;
  // end interface ShortestPathNode
}





