#!/usr/bin/perl -w
#-*-perl-*-
use strict;
use FileHandle;

{
  my (@mopsTokens, @additionalKinds, $fh, $str, $i, $count, $value, $label,
      @kindLabels, $first, @mopsTokenLabels, $astTypes, $mopsConstants,
      $constants, $cfgMagicString);

  @mopsTokens = qw(BYTE INT STRING EOL EOF FB FE D LP RP N NX NN E LF LC LU ADDRESS STATE AST TRANSITION INITIALSTATE FINALSTATE FSA LABEL);
  @mopsTokenLabels = qw(byte int string ; eof fb fe d { } n nx nn e lf lc lu * state ast transition initialstate finalstate fsa label);
  @additionalKinds = qw(data_declaration function_entry function_exit other
			metanot or any ellipsis var unmatched);
  $cfgMagicString = "MOPSCFG";

  die "Usage: $0 input output1.h output2.java\ne.g.: $0 ../rc/AST_types.h ../rc/mops_constants.h Constants.java\n"
    unless $#ARGV == 2;
  $astTypes = $ARGV[0];
  $mopsConstants = $ARGV[1];
  $constants = $ARGV[2];
  
  die "\$#mopsTokens != \$#mopsTokenLabels"
    if ($#mopsTokens != $#mopsTokenLabels);
  
  $fh = new FileHandle $astTypes or die "Cannot open $astTypes: $!";
  while (defined($str = <$fh>))
  {
    if ($str =~ /^\s*kind_([^\s]+)\s*=\s*(\d+)/)
    {
      $value = $2;
      $label = $1;
      die "value > 255" if ($value > 255);
      $kindLabels[$value] = $label;
    }
  }
  $fh->close();

  $count = 255;
  for ($i = $#additionalKinds; $i >= 0; $i--)
  {
    while (defined($kindLabels[$count]))
    {
      $count--;
      die "count <= 0" if ($count <= 0);
    }
    $kindLabels[$count] = $additionalKinds[$i];
  }

  $fh->open(">$mopsConstants") or die "Cannot open $mopsConstants: $!";
  print $fh "// Automatically generated by $0\n",
  "const int\n";
  for $i (0 .. $#mopsTokens)
  {
    print $fh ",\n" if ($i != 0);
    print $fh "  MOPS_$mopsTokens[$i] = $i";
  }
  print $fh ";\n\nconst int\n";
  $first = 1;
  for $i (0 .. $#kindLabels)
  {
    next unless defined($kindLabels[$i]);
    if ($kindLabels[$i] eq "function_entry" or
	$kindLabels[$i] eq "function_exit" or
	$kindLabels[$i] eq "data_declaration")
    {
      if ($first)
      {
	$first = 0;
      }
      else
      {
	print $fh ",\n";
      }
      print $fh "  kind_$kindLabels[$i] = $i";
    }
  }
  print $fh ";\n\nconst char *const CFG_MAGIC_STRING = \"$cfgMagicString\";\n";
  $fh->close();

  $fh->open(">$constants") or die "Cannot open $constants: $!";
  print $fh <<EOF
// Automatically generated by $0
import java.util.*;

public class Constants
{
  public static final int
EOF
;
  for $i (0 .. $#mopsTokens)
  {
    print $fh "    $mopsTokens[$i] = $i,\n";
  }
  print $fh "    MAX_TOKEN = $#mopsTokens;\n\n";
  print $fh <<EOF
  public static final String[] tokenLabels =
  {
EOF
;
  for $i (0 .. $#mopsTokens)
  {
    print $fh ",\n" if ($i > 0);
    print $fh "    \"$mopsTokenLabels[$i]\"";
  }
  
  print $fh "\n  };\n\n  public static final int\n";

  $first = 1;
  for $i (0 .. $#kindLabels)
  {
    if (defined($kindLabels[$i]))
    {
      if (!$first)
      {
	print $fh ",\n";
      }
      else
      {
	$first = 0;
      }
      print $fh "    kind_$kindLabels[$i] = $i";
    }
  }

  print $fh ";\n\n", <<EOF
  public static final String[] kindLabels =
  {
EOF
;
    
  for $i (0 .. $#kindLabels)
  {
    print $fh ",\n" if ($i > 0);
    if (defined($kindLabels[$i]))
    {
      print $fh "    \"$kindLabels[$i]\"";
    }
    else
    {
      print $fh "    null";
    }
  }

  print $fh <<EOF

  };

  public static Hashtable kindInt, tokenInt;

  public static String CFG_MAGIC_STRING = \"$cfgMagicString\";

  static
  {
    kindInt = new Hashtable();
    tokenInt = new Hashtable();

    for (int i = 0; i < kindLabels.length; i++)
    {
      if (kindLabels[i] != null)
      {
	kindInt.put(kindLabels[i], new Integer(i));
      }
    }

    for (int i = 0; i < tokenLabels.length; i++)
    {
      tokenInt.put(tokenLabels[i], new Integer(i));
    }
  }
}
EOF
;
  $fh->close();
}
