c==================================================================================
c==================================================================================
c	Write_pymol.f		
c
c	This file contains fortran program that writes pymol scripts
c	to display Delaunay, alpha-complex and pockets (10 top ones)
c
c	Copyright (C) 2013 Patrice Koehl
c
c	This library is free software; you can redistribute it and/or
c	modify it under the terms of the GNU Lesser General Public
c	License as published by the Free Software Foundation; either
c	version 2.1 of the License, or (at your option) any later version.
c
c	This library is distributed in the hope that it will be useful,
c	but WITHOUT ANY WARRANTY; without even the implied warranty of
c	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
c	Lesser General Public License for more details.
c
c	You should have received a copy of the GNU Lesser General Public
c	License along with this library; if not, write to the Free Software
c	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
c
c==================================================================================
c==================================================================================
c	write_pymol.f		Version 1 4/29/2006	Patrice Koehl
c
c	This program generates a pymol script to visualize lattices
c
	subroutine write_pymol(lout,vertex,vertex_new,new)
c
	integer	i,j
	integer	lout,new
c
	real*8	radius
	real*8	vertex(3),vertex_new(3,new)
c
	save
c
1	format('from pymol.cgo import *')
2	format('from pymol import cmd',/)
3	format('   VERTEX,',f8.3,',',f8.3,',',f8.3,',')
4	format(' ')
5	format('   END',/,'   ]',/,/)
6	format('lines = [',/,'   BEGIN, LINES,',/,
     1  '   COLOR, 0.0, 0.0, 0.0,',/,/)
7	format('cmd.load_cgo(lines,''lines'')')
8	format('center = [',/,'   COLOR, 0.0, 0.0, 1.0,',/,/)
9	format('   SPHERE, ',f8.3, ',',f8.3,',',f8.3,',',f8.3,',')
10	format('cmd.load_cgo(center,''center'')')
11	format('move = [',/,'   COLOR, 1.0, 0.0, 0.0,',/,/)
12	format('cmd.load_cgo(move,''move'')')
13	format('python')
14	format('python end')
c
	radius = 0.5d0
c
	write(lout,13)
	write(lout,1)
	write(lout,2)
c
c	Write center
c
	write(lout,*) ' '
	write(lout,8)
c
	write(lout,9) (vertex(j),j=1,3),radius
	write(lout,5)
c
c	write new positions
c
	write(lout,*) ' '
	write(lout,11)
c
	do 100 i = 1,new
		write(lout,9) (vertex_new(j,i),j=1,3),radius
100	continue
	write(lout,5)
	
c
	write(lout,*) ' '
	write(lout,6)
c
	do 200 i = 1,new
		write(lout,3) (vertex(k),k=1,3)
		write(lout,3) (vertex_new(k,i),k=1,3)
		write(lout,4)
200	continue
	write(lout,5)
c
	write(lout,7)
	write(lout,10)
	write(lout,12)
	write(lout,14)
c
	return
	end
