c===================================================================================
c===================================================================================
c
c	InitRicci.f		Version 1 7/20/2016		Patrice Koehl
c
c	This is the driver routine for lbfgsb; it is called from the
c	C++ code for RicciFlow
c
c===================================================================================
c===================================================================================
c
	subroutine initricci(nvertex, nedge, edge_dist, edge_pair, 
     1			params, nstep_max)
c
c===================================================================================
c===================================================================================
c	Input:
c		nvertex:	# of free vertice
c		nedge:		# of free edges
c		lmax:		maximum edge length
c		params		current parameters: radii + Inversive distance
c	Output:
c		params:		refined parameters
c===================================================================================
c===================================================================================
c
	integer		i
	integer		idx, jdx
	integer		nvertex, nedge
	integer		n, m, iprint, istep, nstep_max
	integer		nbd(*), iwork(*)
	integer		isave(44)
	integer		edge_pair(2,*)
c
	real*8		TOL
	real*8		wmax, lmax, f
	real*8		factr, pgtol
	real*8		dsave(29)
	real*8		deriv(*),rwork(*)
	real*8		params(*),lower(*),upper(*)
	real*8		edge_dist(*)
c
	character	task*60, csave*60
c
	logical		lsave(4)
c
	pointer	(ptr_nbd,nbd)
	pointer	(ptr_iwork,iwork)
	pointer	(ptr_deriv,deriv)
	pointer	(ptr_rwork,rwork)
	pointer	(ptr_lower,lower)
	pointer	(ptr_upper,upper)
c
	TOL = 1.e-8

	n = nvertex + nedge
	m = 5
c
	ptr_nbd = malloc(4*n)
	ptr_iwork = malloc(12*n)
	ptr_deriv = malloc(8*n)
	ptr_rwork = malloc(8*((2*m+5)*n + 11*m*m + 8 *m))
	ptr_lower = malloc(8*n)
	ptr_upper = malloc(8*n)
c
	iprint = -1
	factr = 1.d7
	pgtol = 1.d-5
c
	task = 'START'
c
	lmax = 0
	wmax = 0
	do 100 i = 1,nedge
		lmax = max(lmax, edge_dist(i))
		wmax = max(wmax, params(i+nvertex))
100	continue

	do 200 i = 1,nvertex
		lower(i) = 0.d0
		upper(i) = 2*lmax
		nbd(i) = 1
200	continue
c
	do 300 i = 1,nedge
		lower(i+nvertex) = 0.d0
		upper(i+nvertex) = 2*wmax
		nbd(i+nvertex) = 0
300	continue
c
	call functional(nvertex, nedge, params, edge_pair, edge_dist, 
     1		f, deriv)
c
	write(6,*) 'initial functional:', f
	if(f < TOL) return
c
	istep = 0
c
400	continue
c
		call setulb(n, m, params, lower, upper, nbd, f,
     1		deriv,factr,pgtol,rwork,iwork,task,iprint,csave,lsave,
     2		isave,dsave)
c
c		write(6,*) 'task = ', task
c
		istep = istep + 1
		if(istep.gt.nstep_max) goto 500
		if(task(1:2).eq.'FG') then
			call functional(nvertex, nedge, params, 
     1			edge_pair, edge_dist, f, deriv)
c			write(6,*) 'Current f:',f
			if(f<TOL) goto 500
			goto 400
		elseif(task(1:5).eq.'NEW_X') then
			goto 400
		endif
c
500	continue
c
	call functional(nvertex, nedge, params, edge_pair, 
     1		edge_dist, f, deriv)
c
	write(6,*) 'final functional:', f

	call free(ptr_nbd)
	call free(ptr_iwork)
	call free(ptr_deriv)
	call free(ptr_rwork)
	call free(ptr_lower)
	call free(ptr_upper)
c
	return
	end

	subroutine functional(nvertex, nedge, params, edge_pair, 
     1		edge_dist, f, deriv)
c
	integer	i,j
	integer idx, jdx
	integer	nvertex, nedge, npar
	integer edge_pair(2,*)
c
	real*8	f, val, val2
	real*8	ri, rj, Iij, l
	real*8	params(*)
	real*8	edge_dist(*)
	real*8	deriv(*)
c
	npar = nvertex + nedge
	do 100 i = 1,npar
		deriv(i) = 0.0d0
100	continue
c
	f = 0.0d0
c
	do 200 i = 1,nedge
c
		idx = edge_pair(1,i)
		jdx = edge_pair(2,i)
c
		ri = params(idx)
		rj = params(jdx)
		Iij = params(nvertex+i)
c
		l = ri*ri + rj*rj + 2*ri*rj*Iij
c
		val = l - edge_dist(i)
		f = f + val*val
c
		val2 = 2.d0*val*(2.d0*ri + 2.d0*rj*Iij)
		deriv(idx) = deriv(idx) + val2
		val2 = 2.d0*val*(2.d0*rj + 2.d0*ri*Iij)
		deriv(jdx) = deriv(jdx) + val2
		val2 = 4*val*ri*rj
		deriv(nvertex+i) = val2
c
200	continue
c
	return
	end
