/* ===============================================================================================
   Global variables for nanogui and Viewer
   =============================================================================================== */

GLFWwindow* Viewer::window = NULL;
nanogui::Screen* Viewer::gui = new nanogui::Screen();
nanogui::Label* Viewer::plotLabel = NULL;
nanogui::Label* Viewer::angleControlLabel = NULL;
nanogui::Label* Viewer::instructionText = NULL;

int Viewer::windowWidth = 1300;
int Viewer::windowHeight = 700;
int Viewer::framebufferWidth = -1;
int Viewer::framebufferHeight = -1;

nanogui::ComboBox* Viewer::paramComboBox = NULL;
nanogui::ComboBox* Viewer::plotComboBox = NULL;
nanogui::CheckBox* Viewer::exportNormalizedUVsCheckBox = NULL;
nanogui::CheckBox* Viewer::wireframeCheckBox = NULL;
nanogui::CheckBox* Viewer::applyNormCheckBox = NULL;
nanogui::CheckBox* Viewer::applyQuasiCheckBox = NULL;
nanogui::CheckBox* Viewer::applyRefMCFCheckBox = NULL;
nanogui::CheckBox* Viewer::showConeCheckBox = NULL;

ViewPane Viewer::surfacePane;
ViewPane Viewer::uvPane;
ViewPane Viewer::fullPane;

GLuint Viewer::transformUbo;
GLuint Viewer::lightUbo;
float Viewer::patternSize = 2.0;

std::vector<std::shared_ptr<Camera>> Viewer::cameras;

Shader Viewer::modelShader;
Shader Viewer::flatShader;
Shader Viewer::wireframeShader;
bool Viewer::showWireframe = false;
bool Viewer::applyNorm = false;
bool Viewer::applyQuasi = false;
bool Viewer::applyRefMCF = false;
bool Viewer::showCone = false;
bool Viewer::SUCCESS = true;

Vector Viewer::origUp;
Vector Viewer::mouse, Viewer::origMouse;
int Viewer::clickX = -1;
int Viewer::clickY = -1;
int Viewer::unclickX = -1;
int Viewer::unclickY = -1;
bool Viewer::mouseDown = false;

bool Viewer::pickingEnabled = false;
bool Viewer::shiftClick = false;
bool Viewer::ctrlClick = false;
bool Viewer::altClick = false;

PlotType Viewer::plotType = PlotType::shaded;
bool Viewer::colorsNeedUpdate = true;

/* ===============================================================================================
   Global variables for mesh definitions and parameterization
   =============================================================================================== */

std::string Viewer::objPath;
Mesh* Viewer::mesh;
Mesh Viewer::model;
ModelState* Viewer::state;
int Viewer::selectedMesh = 0;
bool Viewer::loadedModel = false;

Tutte Viewer::tutte;
Ricci Viewer::ricci;
Yamabe Viewer::yamabe;
YamabeIDT Viewer::yamabeIDT;
Beltrami Viewer::beltrami;
cMCF Viewer::mcf;
Willmore Viewer::willmore;
