
#ifndef PCA_H
#define PCA_H

/*******************************************************************************/
/* Principal Components Analysis by Soon Tee Teoh, modified from the following */
/*******************************************************************************/

/*********************************************************************/
/* Principal Components Analysis or the Karhunen-Loeve expansion is a
   classical method for dimensionality reduction or exploratory data
   analysis.  One reference among many is: F. Murtagh and A. Heck,
   Multivariate Data Analysis, Kluwer Academic, Dordrecht, 1987.

   Author:
   F. Murtagh
   Phone:        + 49 89 32006298 (work)
                 + 49 89 965307 (home)
   Earn/Bitnet:  fionn@dgaeso51,  fim@dgaipp1s,  murtagh@stsci
   Span:         esomc1::fionn
   Internet:     murtagh@scivax.stsci.edu
   
   F. Murtagh, Munich, 6 June 1989                                   */   
/*********************************************************************/

class PCA {

public:
	PCA();
	void RunPCA(char *fname, int n, int m, int r);
	void ReadProj(int p);
	void Transform(float *incoords, float *outcoords, int proj, int npcacols);
	int ncols;

	float **allmeans;
	float **allstddevs;
	float ***allsymmats;


private:
	void erhand(char err_msg[]);
	float *vector(int n);
	float **matrix(int n, int m);
	void free_matrix(float **mat,int n,int m);
	void tred2(float **a, int n, float *d, float *e);
	void tqli(float d[], float e[], int n, float **z);
	void free_vector(float *v,int n);
	void corcol(float **data, int n, int m, float **symmat);
	void covcol(float **data, int n, int m, float **symmat);
	void scpcol(float **data, int n, int m, float **symmat);

};

#endif


