/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.jvm;

import edu.ucdavis.jr.trans.sun.tools.javac.code.Attribute;
import edu.ucdavis.jr.trans.sun.tools.javac.code.BoundKind;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Scope;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Source;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Symbol;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Symtab;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Type;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Types;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Annotate;
import edu.ucdavis.jr.trans.sun.tools.javac.jvm.ClassFile;
import edu.ucdavis.jr.trans.sun.tools.javac.jvm.Code;
import edu.ucdavis.jr.trans.sun.tools.javac.jvm.Pool;
import edu.ucdavis.jr.trans.sun.tools.javac.jvm.Target;
import edu.ucdavis.jr.trans.sun.tools.javac.util.ByteBuffer;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Context;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Convert;
import edu.ucdavis.jr.trans.sun.tools.javac.util.FileEntry;
import edu.ucdavis.jr.trans.sun.tools.javac.util.List;
import edu.ucdavis.jr.trans.sun.tools.javac.util.ListBuffer;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Log;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Name;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Options;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Pair;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Paths;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassReader
extends ClassFile
implements Symbol.Completer {
    protected static final Context.Key<ClassReader> classReaderKey = new Context.Key();
    Annotate annotate;
    boolean verbose;
    boolean checkClassFile;
    boolean allowVariance;
    public boolean readAllOfClassFile = false;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAnnotations;
    boolean saveParameterNames;
    final Log log;
    Symtab syms;
    Types types;
    final Name.Table names;
    final Name completionFailureName;
    private final Paths paths;
    public SourceCompleter sourceCompleter = null;
    private Map<Name, Symbol.ClassSymbol> classes;
    private Map<Name, Symbol.PackageSymbol> packages;
    Scope typevars;
    String currentClassFileName = null;
    Symbol currentOwner = null;
    byte[] buf = new byte[65520];
    int bp;
    Object[] poolObj;
    int[] poolIdx;
    byte[] signature;
    int sigp;
    int siglimit;
    boolean sigEnterPhase = false;
    Map<String, Archive> archives = new HashMap<String, Archive>();
    private boolean filling = false;
    private Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, null);
    static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';
    static final boolean surrogatesSupported = ClassReader.surrogatesSupported();
    private static final String[] classOnly = new String[]{".class"};
    private static final String[] javaOnly = new String[]{".java"};
    private static final String[] classOrJava = new String[]{".class", ".java"};

    public static ClassReader instance(Context context) {
        ClassReader classReader = context.get(classReaderKey);
        if (classReader == null) {
            classReader = new ClassReader(context, true);
        }
        return classReader;
    }

    public void init(Symtab symtab) {
        this.init(symtab, true);
    }

    private void init(Symtab symtab, boolean bl) {
        if (this.classes != null) {
            return;
        }
        if (bl) {
            assert (this.packages == null || this.packages == symtab.packages);
            this.packages = symtab.packages;
            assert (this.classes == null || this.classes == symtab.classes);
            this.classes = symtab.classes;
        } else {
            this.packages = new HashMap<Name, Symbol.PackageSymbol>();
            this.classes = new HashMap<Name, Symbol.ClassSymbol>();
        }
        this.packages.put(symtab.rootPackage.fullname, symtab.rootPackage);
        symtab.rootPackage.completer = this;
        this.packages.put(symtab.emptyPackage.fullname, symtab.emptyPackage);
        symtab.emptyPackage.completer = this;
    }

    protected ClassReader(Context context, boolean bl) {
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        if (bl) {
            context.put(classReaderKey, this);
        }
        this.names = Name.Table.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.init(this.syms, bl);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.annotate = Annotate.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.checkClassFile = options.get("-checkclassfile") != null;
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowVarargs = source.allowVarargs();
        this.allowAnnotations = source.allowAnnotations();
        this.saveParameterNames = options.get("save-parameter-names") != null;
        this.paths = Paths.instance(context);
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString((String)options.get("failcomplete")) : null;
        this.typevars = new Scope(this.syms.noSymbol);
    }

    private void enterMember(Symbol.ClassSymbol classSymbol, Symbol symbol) {
        if ((symbol.flags_field & 0x80001000L) != 4096L) {
            classSymbol.members_field.enter(symbol);
        }
    }

    public BadClassFile badClassFile(String string, Object ... objectArray) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFileName, Log.getLocalizedString(string, objectArray));
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    int getInt(int n) {
        return ((this.buf[n] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + (this.buf[n + 3] & 0xFF);
    }

    long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int n = 1;
        block6: while (n < this.poolIdx.length) {
            this.poolIdx[n++] = this.bp;
            byte by = this.buf[this.bp++];
            switch (by) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++n;
                    continue block6;
                }
            }
            throw this.badClassFile("bad.const.pool.tag.at", Byte.toString(by), Integer.toString(this.bp - 1));
        }
    }

    Object readPool(int n) {
        Object object = this.poolObj[n];
        if (object != null) {
            return object;
        }
        int n2 = this.poolIdx[n];
        if (n2 == 0) {
            return null;
        }
        byte by = this.buf[n2];
        switch (by) {
            case 1: {
                this.poolObj[n] = this.names.fromUtf(this.buf, n2 + 3, this.getChar(n2 + 1));
                break;
            }
            case 2: {
                throw this.badClassFile("unicode.str.not.supported", new Object[0]);
            }
            case 7: {
                this.poolObj[n] = this.readClassOrType(this.getChar(n2 + 1));
                break;
            }
            case 8: {
                this.poolObj[n] = this.readName(this.getChar(n2 + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.VarSymbol(0L, nameAndType.name, nameAndType.type, classSymbol);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.MethodSymbol(0L, nameAndType.name, nameAndType.type, classSymbol);
                break;
            }
            case 12: {
                this.poolObj[n] = new ClassFile.NameAndType(this.readName(this.getChar(n2 + 1)), this.readType(this.getChar(n2 + 3)));
                break;
            }
            case 3: {
                this.poolObj[n] = this.getInt(n2 + 1);
                break;
            }
            case 4: {
                this.poolObj[n] = new Float(this.getFloat(n2 + 1));
                break;
            }
            case 5: {
                this.poolObj[n] = new Long(this.getLong(n2 + 1));
                break;
            }
            case 6: {
                this.poolObj[n] = new Double(this.getDouble(n2 + 1));
                break;
            }
            default: {
                throw this.badClassFile("bad.const.pool.tag", Byte.toString(by));
            }
        }
        return this.poolObj[n];
    }

    Type readType(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToType(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Object readClassOrType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        int n3 = n2 + 3;
        assert (this.buf[n3] == 91 || this.buf[n3 + c - 1] != 59);
        return this.buf[n3] == 91 || this.buf[n3 + c - 1] == 59 ? this.sigToType(this.buf, n3, c) : this.enterClass(this.names.fromUtf(ClassReader.internalize(this.buf, n3, c)));
    }

    List<Type> readTypeParams(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToTypeParams(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Symbol.ClassSymbol readClassSymbol(int n) {
        return (Symbol.ClassSymbol)this.readPool(n);
    }

    Name readName(int n) {
        return (Name)this.readPool(n);
    }

    Type sigToType(Name name) {
        return name == null ? null : this.sigToType(name.table.names, name.index, name.len);
    }

    Type sigToType(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToType();
    }

    Type sigToType() {
        switch ((char)this.signature[this.sigp]) {
            case 'T': {
                ++this.sigp;
                int n = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.sigEnterPhase ? Type.noType : this.findTypeVar(this.names.fromUtf(this.signature, n, this.sigp - 1 - n));
            }
            case '+': {
                ++this.sigp;
                Type type = this.sigToType();
                return new Type.ArgumentType(type, BoundKind.EXTENDS, this.syms.boundClass);
            }
            case '*': {
                ++this.sigp;
                return new Type.ArgumentType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
            case '-': {
                ++this.sigp;
                Type type = this.sigToType();
                return new Type.ArgumentType(type, BoundKind.SUPER, this.syms.boundClass);
            }
            case 'B': {
                ++this.sigp;
                return this.syms.byteType;
            }
            case 'C': {
                ++this.sigp;
                return this.syms.charType;
            }
            case 'D': {
                ++this.sigp;
                return this.syms.doubleType;
            }
            case 'F': {
                ++this.sigp;
                return this.syms.floatType;
            }
            case 'I': {
                ++this.sigp;
                return this.syms.intType;
            }
            case 'J': {
                ++this.sigp;
                return this.syms.longType;
            }
            case 'L': {
                int n = this.sigp;
                Type type = this.classSigToType();
                if (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    throw this.badClassFile("deprecated inner class signature syntax (please recompile from source)", new Object[0]);
                }
                return type;
            }
            case 'S': {
                ++this.sigp;
                return this.syms.shortType;
            }
            case 'V': {
                ++this.sigp;
                return this.syms.voidType;
            }
            case 'Z': {
                ++this.sigp;
                return this.syms.booleanType;
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.sigToType(), (Symbol.TypeSymbol)this.syms.arrayClass);
            }
            case '(': {
                ++this.sigp;
                List<Type> list = this.sigToTypes(')');
                Type type = this.sigToType();
                ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                while (this.signature[this.sigp] == 94) {
                    ++this.sigp;
                    listBuffer.append(this.sigToType());
                }
                return new Type.MethodType(list, type, listBuffer.toList(), this.syms.methodClass);
            }
            case '<': {
                this.typevars = this.typevars.dup(this.currentOwner);
                Type.ForAll forAll = new Type.ForAll(this.sigToTypeParams(), this.sigToType());
                this.typevars = this.typevars.leave();
                return forAll;
            }
        }
        throw this.badClassFile("bad.signature", Convert.utf2string(this.signature, this.sigp, 10));
    }

    Type classSigToType() {
        if (this.signature[this.sigp] != 76) {
            throw this.badClassFile("bad.class.signature", Convert.utf2string(this.signature, this.sigp, 10));
        }
        ++this.sigp;
        Type type = Type.noType;
        ByteBuffer byteBuffer = new ByteBuffer();
        block9: while (true) {
            byte by = this.signature[this.sigp++];
            switch (by) {
                case 46: 
                case 59: {
                    Symbol.ClassSymbol classSymbol = this.enterClass(this.names.fromUtf(byteBuffer.elems, 0, byteBuffer.length));
                    type = type == Type.noType ? classSymbol.erasure(this.types) : new Type.ClassType(type, Type.emptyList, classSymbol);
                    if (by == 59) {
                        return type;
                    }
                    byteBuffer.appendByte(36);
                    continue block9;
                }
                case 60: {
                    Symbol.ClassSymbol classSymbol = this.enterClass(this.names.fromUtf(byteBuffer.elems, 0, byteBuffer.length));
                    type = new Type.ClassType(type, this.sigToTypes('>'), classSymbol);
                    switch (this.signature[this.sigp++]) {
                        case 59: {
                            if (this.sigp < this.signature.length && this.signature[this.sigp] == 46) {
                                this.sigp += byteBuffer.length + 3;
                                byteBuffer.appendByte(36);
                                continue block9;
                            }
                            return type;
                        }
                        case 46: {
                            byteBuffer.appendByte(36);
                            continue block9;
                        }
                    }
                    throw new AssertionError(this.signature[this.sigp - 1]);
                }
                case 47: {
                    byteBuffer.appendByte(46);
                    continue block9;
                }
            }
            byteBuffer.appendByte(by);
        }
    }

    List<Type> sigToTypes(char c) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        while (this.signature[this.sigp] != c) {
            listBuffer.append(this.sigToType());
        }
        ++this.sigp;
        return listBuffer.toList();
    }

    List<Type> sigToTypeParams(Name name) {
        return this.sigToTypeParams(name.table.names, name.index, name.len);
    }

    List<Type> sigToTypeParams(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            int n = this.sigp;
            this.sigEnterPhase = true;
            while (this.signature[this.sigp] != 62) {
                listBuffer.append(this.sigToTypeParam());
            }
            this.sigEnterPhase = false;
            this.sigp = n;
            while (this.signature[this.sigp] != 62) {
                this.sigToTypeParam();
            }
            ++this.sigp;
        }
        return listBuffer.toList();
    }

    Type sigToTypeParam() {
        Type.TypeVar typeVar;
        int n = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = this.names.fromUtf(this.signature, n, this.sigp - n);
        if (this.sigEnterPhase) {
            typeVar = new Type.TypeVar(name, this.currentOwner);
            this.typevars.enter(typeVar.tsym);
        } else {
            typeVar = (Type.TypeVar)this.findTypeVar(name);
        }
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        Type type = null;
        if (this.signature[this.sigp] == 58 && this.signature[this.sigp + 1] == 58) {
            ++this.sigp;
            type = this.syms.objectType;
        }
        while (this.signature[this.sigp] == 58) {
            ++this.sigp;
            listBuffer.append(this.sigToType());
        }
        if (!this.sigEnterPhase) {
            this.types.setBounds(typeVar, listBuffer.toList(), type);
        }
        return typeVar;
    }

    Type findTypeVar(Name name) {
        Scope.Entry entry = this.typevars.lookup(name);
        if (entry.scope != null) {
            return entry.sym.type;
        }
        throw this.badClassFile("undecl.type.var", name);
    }

    void unrecognized(Name name) {
        if (this.checkClassFile) {
            this.printCCF("ccf.unrecognized.attribute", name);
        }
    }

    void readMemberAttr(Symbol symbol, Name name, int n) {
        if (name == this.names.ConstantValue) {
            Object object = this.readPool(this.nextChar());
            if ((symbol.flags() & 0x10L) != 0L) {
                ((Symbol.VarSymbol)symbol).constValue = object;
            }
        } else if (name == this.names.Code) {
            if (this.readAllOfClassFile) {
                ((Symbol.MethodSymbol)symbol).code = this.readCode(symbol);
            } else {
                this.bp += n;
            }
        } else if (name == this.names.Exceptions) {
            int n2 = this.nextChar();
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (int i = 0; i < n2; ++i) {
                listBuffer.append(this.readClassSymbol((int)this.nextChar()).type);
            }
            if (symbol.type.thrown().isEmpty()) {
                symbol.type.asMethodType().thrown = listBuffer.toList();
            }
        } else if (name == this.names.Synthetic) {
            if (this.allowGenerics || (symbol.flags_field & 0x80000000L) == 0L) {
                symbol.flags_field |= 0x1000L;
            }
        } else if (name == this.names.Bridge) {
            symbol.flags_field |= 0x80000000L;
            if (!this.allowGenerics) {
                symbol.flags_field &= 0xFFFFFFFFFFFFEFFFL;
            }
        } else if (name == this.names.Deprecated) {
            symbol.flags_field |= 0x20000L;
        } else if (name == this.names.Varargs) {
            if (this.allowVarargs) {
                symbol.flags_field |= 0x400000000L;
            }
        } else if (name == this.names.Annotation) {
            if (this.allowAnnotations) {
                symbol.flags_field |= 0x2000L;
            }
        } else if (name == this.names.Enum) {
            symbol.flags_field |= 0x4000L;
        } else if (this.allowGenerics && name == this.names.Signature) {
            List<Type> list = symbol.type.thrown();
            symbol.type = this.readType(this.nextChar());
            if (symbol.kind == 16 && symbol.type.thrown().isEmpty()) {
                symbol.type.asMethodType().thrown = list;
            }
        } else if (name == this.names.RuntimeVisibleAnnotations) {
            this.attachAnnotations(symbol, n);
        } else if (name == this.names.RuntimeInvisibleAnnotations) {
            this.attachAnnotations(symbol, n);
        } else if (name == this.names.RuntimeVisibleParameterAnnotations) {
            this.attachParameterAnnotations(symbol, n);
        } else if (name == this.names.RuntimeInvisibleParameterAnnotations) {
            this.attachParameterAnnotations(symbol, n);
        } else if (name == this.names.LocalVariableTable) {
            int n3 = this.bp + n;
            if (this.saveParameterNames) {
                List<Symbol.VarSymbol> list = ((Symbol.MethodSymbol)symbol).params();
                int n4 = (symbol.flags() & 8L) == 0L ? 1 : 0;
                int n5 = n4 + Code.width(symbol.type.argtypes());
                int n6 = this.nextChar();
                block1: for (int i = 0; i < n6; ++i) {
                    char c = this.nextChar();
                    char c2 = this.nextChar();
                    char c3 = this.nextChar();
                    char c4 = this.nextChar();
                    int n7 = this.nextChar();
                    if (c != '\u0000' || n4 > n7 || n7 >= n5) continue;
                    int n8 = n4;
                    for (Symbol.VarSymbol varSymbol : list) {
                        if (n8 == n7) {
                            varSymbol.name = this.readName(c3);
                            continue block1;
                        }
                        n8 += Code.width(varSymbol.type);
                    }
                }
            }
            this.bp = n3;
        } else if (name == this.names.AnnotationDefault) {
            this.attachAnnotationDefault(symbol, n);
        } else {
            this.unrecognized(name);
            this.bp += n;
        }
    }

    void readMemberAttrs(Symbol symbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            int n2 = this.nextInt();
            this.readMemberAttr(symbol, name, n2);
        }
    }

    void readClassAttr(Symbol.ClassSymbol classSymbol, Name name, int n) {
        if (name == this.names.SourceFile) {
            classSymbol.sourcefile = this.readName(this.nextChar());
        } else if (name == this.names.InnerClasses) {
            this.readInnerClasses(classSymbol);
        } else if (this.allowGenerics && name == this.names.Signature) {
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            classType.typarams_field = this.readTypeParams(this.nextChar());
            classType.supertype_field = this.sigToType();
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            while (this.sigp != this.siglimit) {
                listBuffer.append(this.sigToType());
            }
            classType.interfaces_field = listBuffer.toList();
        } else {
            this.readMemberAttr(classSymbol, name, n);
        }
    }

    void readClassAttrs(Symbol.ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            int n2 = this.nextInt();
            this.readClassAttr(classSymbol, name, n2);
        }
    }

    Code readCode(Symbol symbol) {
        return null;
    }

    void attachAnnotations(Symbol symbol, int n) {
        int n2 = this.nextChar();
        if (n2 != 0) {
            ListBuffer<CompoundAnnotationProxy> listBuffer = new ListBuffer<CompoundAnnotationProxy>();
            for (int i = 0; i < n2; ++i) {
                listBuffer.append(this.readCompoundAnnotation());
            }
            this.annotate.later(new AnnotationCompleter(symbol, listBuffer.toList()));
        }
    }

    void attachParameterAnnotations(Symbol symbol, int n) {
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        int n2 = this.buf[this.bp++] & 0xFF;
        List<Symbol.VarSymbol> list = methodSymbol.params();
        for (int i = 0; i < n2; ++i) {
            this.attachAnnotations((Symbol)list.head, -1);
            list = list.tail;
        }
    }

    void attachAnnotationDefault(Symbol symbol, int n) {
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        Attribute attribute = this.readAttributeValue();
        this.annotate.later(new AnnotationDefaultCompleter(methodSymbol, attribute));
    }

    Type readTypeOrClassSymbol(int n) {
        if (this.buf[this.poolIdx[n]] == 7) {
            return this.readClassSymbol((int)n).type;
        }
        return this.readType(n);
    }

    Type readEnumType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        if (this.buf[n2 + c + 2] != 59) {
            return this.enterClass((Name)this.readName((int)n)).type;
        }
        return this.readType(n);
    }

    CompoundAnnotationProxy readCompoundAnnotation() {
        Type type = this.readTypeOrClassSymbol(this.nextChar());
        int n = this.nextChar();
        ListBuffer<Pair<Name, Attribute>> listBuffer = new ListBuffer<Pair<Name, Attribute>>();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            Attribute attribute = this.readAttributeValue();
            listBuffer.append(new Pair<Name, Attribute>(name, attribute));
        }
        return new CompoundAnnotationProxy(type, listBuffer.toList());
    }

    Attribute readAttributeValue() {
        char c = (char)this.buf[this.bp++];
        switch (c) {
            case 'B': {
                return new Attribute.Constant(this.syms.byteType, this.readPool(this.nextChar()));
            }
            case 'C': {
                return new Attribute.Constant(this.syms.charType, this.readPool(this.nextChar()));
            }
            case 'D': {
                return new Attribute.Constant(this.syms.doubleType, this.readPool(this.nextChar()));
            }
            case 'F': {
                return new Attribute.Constant(this.syms.floatType, this.readPool(this.nextChar()));
            }
            case 'I': {
                return new Attribute.Constant(this.syms.intType, this.readPool(this.nextChar()));
            }
            case 'J': {
                return new Attribute.Constant(this.syms.longType, this.readPool(this.nextChar()));
            }
            case 'S': {
                return new Attribute.Constant(this.syms.shortType, this.readPool(this.nextChar()));
            }
            case 'Z': {
                return new Attribute.Constant(this.syms.booleanType, this.readPool(this.nextChar()));
            }
            case 's': {
                return new Attribute.Constant(this.syms.stringType, this.readPool(this.nextChar()).toString());
            }
            case 'e': {
                return new EnumAttributeProxy(this.readEnumType(this.nextChar()), this.readName(this.nextChar()));
            }
            case 'c': {
                return new Attribute.Class(this.types, this.readTypeOrClassSymbol(this.nextChar()));
            }
            case '[': {
                int n = this.nextChar();
                ListBuffer<Attribute> listBuffer = new ListBuffer<Attribute>();
                for (int i = 0; i < n; ++i) {
                    listBuffer.append(this.readAttributeValue());
                }
                return new ArrayAttributeProxy(listBuffer.toList());
            }
            case '@': {
                return this.readCompoundAnnotation();
            }
        }
        throw new AssertionError((Object)("unknown annotation tag '" + c + "'"));
    }

    Symbol.VarSymbol readField() {
        long l = this.adjustFieldFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(l, name, type, this.currentOwner);
        this.readMemberAttrs(varSymbol);
        return varSymbol;
    }

    Symbol.MethodSymbol readMethod() {
        long l = this.adjustMethodFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        if (name == this.names.init && this.currentOwner.hasOuterInstance()) {
            type = new Type.MethodType(type.argtypes().tail, type.restype(), type.thrown(), this.syms.methodClass);
        }
        Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(l, name, type, this.currentOwner);
        Symbol symbol = this.currentOwner;
        this.currentOwner = methodSymbol;
        this.readMemberAttrs(methodSymbol);
        this.currentOwner = symbol;
        return methodSymbol;
    }

    void skipMember() {
        this.bp += 6;
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.bp += 2;
            int n2 = this.nextInt();
            this.bp += n2;
        }
    }

    void enterTypevars(Type type) {
        if (type.outer().tag == 10) {
            this.enterTypevars(type.outer());
        }
        List<Type> list = type.typarams();
        while (list.nonEmpty()) {
            this.typevars.enter(((Type)list.head).tsym);
            list = list.tail;
        }
    }

    void readClass(Symbol.ClassSymbol classSymbol) {
        int n;
        int n2;
        int n3;
        Symbol.ClassSymbol classSymbol2;
        Type.ClassType classType = (Type.ClassType)classSymbol.type;
        classSymbol.members_field = new Scope(classSymbol);
        this.typevars = this.typevars.dup(this.currentOwner);
        if (classType.outer().tag == 10) {
            this.enterTypevars(classType.outer());
        }
        long l = this.adjustClassFlags(this.nextChar());
        if (classSymbol.owner.kind == 1) {
            classSymbol.flags_field = l;
        }
        if (classSymbol != (classSymbol2 = this.readClassSymbol(this.nextChar()))) {
            throw this.badClassFile("class.file.wrong.class", classSymbol2.flatname);
        }
        int n4 = this.bp;
        this.nextChar();
        char c = this.nextChar();
        this.bp += c * 2;
        int n5 = this.nextChar();
        for (n3 = 0; n3 < n5; ++n3) {
            this.skipMember();
        }
        n3 = this.nextChar();
        for (n2 = 0; n2 < n3; ++n2) {
            this.skipMember();
        }
        this.readClassAttrs(classSymbol);
        if (this.readAllOfClassFile) {
            for (n2 = 1; n2 < this.poolObj.length; ++n2) {
                this.readPool(n2);
            }
            classSymbol.pool = new Pool(this.poolObj.length, this.poolObj);
        }
        this.bp = n4;
        n2 = this.nextChar();
        if (classType.supertype_field == null) {
            classType.supertype_field = n2 == 0 ? Type.noType : this.readClassSymbol(n2).erasure(this.types);
        }
        n2 = this.nextChar();
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (n = 0; n < n2; ++n) {
            Type type = this.readClassSymbol(this.nextChar()).erasure(this.types);
            listBuffer.append(type);
        }
        if (classType.interfaces_field == null) {
            classType.interfaces_field = listBuffer.toList();
        }
        if (n5 != this.nextChar()) assert (false);
        for (n = 0; n < n5; ++n) {
            this.enterMember(classSymbol, this.readField());
        }
        if (n3 != this.nextChar()) assert (false);
        for (n = 0; n < n3; ++n) {
            this.enterMember(classSymbol, this.readMethod());
        }
        this.typevars = this.typevars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
            Name name = this.readName(this.nextChar());
            if (name == null) {
                name = this.names.empty;
            }
            long l = this.adjustClassFlags(this.nextChar());
            if (classSymbol2 == null) continue;
            if (name == this.names.empty) {
                name = this.names.one;
            }
            Symbol.ClassSymbol classSymbol3 = this.enterClass(name, classSymbol2);
            if ((l & 8L) == 0L) {
                ((Type.ClassType)classSymbol3.type).outer_field = classSymbol2.type;
                if (classSymbol3.erasure_field != null) {
                    ((Type.ClassType)classSymbol3.erasure_field).outer_field = this.types.erasure(classSymbol2.type);
                }
            }
            if (classSymbol != classSymbol2) continue;
            classSymbol3.flags_field = l;
            this.enterMember(classSymbol, classSymbol3);
        }
    }

    private void readClassFile(Symbol.ClassSymbol classSymbol) throws IOException {
        int n = this.nextInt();
        if (n != -889275714) {
            throw this.badClassFile("illegal.start.of.class.file", new Object[0]);
        }
        char c = this.nextChar();
        char c2 = this.nextChar();
        if (c2 > Target.MAX().majorVersion || c2 * 1000 + c < Target.MIN().majorVersion * 1000 + Target.MIN().minorVersion) {
            throw this.badClassFile("wrong.version", Integer.toString(c2), Integer.toString(c), Integer.toString(Target.MAX().majorVersion), Integer.toString(Target.MAX().minorVersion));
        }
        if (this.checkClassFile && c2 == Target.MAX().majorVersion && c > Target.MAX().minorVersion) {
            this.printCCF("found.later.version", Integer.toString(c));
        }
        this.indexPool();
        this.readClass(classSymbol);
    }

    long adjustFieldFlags(long l) {
        return l;
    }

    long adjustMethodFlags(long l) {
        if ((l & 0x40L) != 0L) {
            l &= 0xFFFFFFFFFFFFFFBFL;
            l |= 0x80000000L;
            if (!this.allowGenerics) {
                l &= 0xFFFFFFFFFFFFEFFFL;
            }
        }
        if ((l & 0x80L) != 0L) {
            l &= 0xFFFFFFFFFFFFFF7FL;
            l |= 0x400000000L;
        }
        return l;
    }

    long adjustClassFlags(long l) {
        return l;
    }

    static boolean isZip(String string) {
        return new File(string).isFile();
    }

    Archive openArchive(String string) throws IOException {
        Archive archive = this.archives.get(string);
        if (archive == null) {
            ZipFile zipFile = new ZipFile(string);
            ListBuffer<ZipEntry> listBuffer = new ListBuffer<ZipEntry>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                listBuffer.append(enumeration.nextElement());
            }
            archive = new Archive(zipFile, listBuffer.toList());
            this.archives.put(string, archive);
        }
        return archive;
    }

    public void close() {
        Iterator<Archive> iterator = this.archives.values().iterator();
        while (iterator.hasNext()) {
            Archive archive = iterator.next();
            iterator.remove();
            try {
                archive.zdir.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol symbol) {
        Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(0L, name, symbol);
        classSymbol.completer = this;
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol typeSymbol) {
        Name name2 = Symbol.TypeSymbol.formFlatName(name, typeSymbol);
        Symbol.ClassSymbol classSymbol = this.classes.get(name2);
        if (classSymbol == null) {
            classSymbol = this.defineClass(name, typeSymbol);
            this.classes.put(name2, classSymbol);
        } else if ((classSymbol.name != name || classSymbol.owner != typeSymbol) && typeSymbol.kind == 2) {
            classSymbol.owner.members().remove(classSymbol);
            classSymbol.name = name;
            classSymbol.owner = typeSymbol;
            classSymbol.fullname = Symbol.ClassSymbol.formFullName(name, typeSymbol);
        }
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name) {
        Symbol.ClassSymbol classSymbol = this.classes.get(name);
        if (classSymbol == null) {
            Name name2 = Convert.packagePart(name);
            if (name2 == this.names.empty) {
                name2 = this.names.emptyPackage;
            }
            classSymbol = this.defineClass(Convert.shortName(name), this.enterPackage(name2));
            this.classes.put(name, classSymbol);
        }
        return classSymbol;
    }

    @Override
    public void complete(Symbol symbol) throws Symbol.CompletionFailure {
        if (symbol.kind == 2) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
            classSymbol.members_field = new Scope.ErrorScope(classSymbol);
            this.completeOwners(classSymbol.owner);
            this.fillIn(classSymbol);
        } else if (symbol.kind == 1) {
            Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)symbol;
            this.fillIn(packageSymbol);
        }
        this.annotate.flush();
    }

    private void completeOwners(Symbol symbol) {
        if (symbol.kind != 1) {
            this.completeOwners(symbol.owner);
        }
        symbol.complete();
    }

    private void fillIn(Symbol.ClassSymbol classSymbol) {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure(classSymbol, "user-selected completion failure by class name");
        }
        this.currentOwner = classSymbol;
        FileEntry fileEntry = classSymbol.classfile;
        if (fileEntry != null) {
            String string = this.currentClassFileName;
            try {
                assert (!this.filling);
                InputStream inputStream = fileEntry.open();
                this.currentClassFileName = fileEntry.getPath();
                if (this.verbose) {
                    this.printVerbose("loading", this.currentClassFileName);
                }
                if (fileEntry.getName().endsWith(".class")) {
                    this.filling = true;
                    int n = (int)fileEntry.length();
                    if (this.buf.length < n) {
                        this.buf = new byte[n];
                    }
                    for (int i = 0; i < n; i += inputStream.read(this.buf, i, n - i)) {
                    }
                    inputStream.close();
                    this.bp = 0;
                    this.readClassFile(classSymbol);
                } else {
                    this.sourceCompleter.complete(classSymbol, this.currentClassFileName, inputStream);
                }
                return;
            }
            catch (IOException iOException) {
                throw this.badClassFile("unable.to.access.file", iOException.getMessage());
            }
            finally {
                this.filling = false;
                this.currentClassFileName = string;
            }
        }
        String string = ClassReader.externalizeFileName(classSymbol.flatname);
        throw this.newCompletionFailure(classSymbol, Log.getLocalizedString("dot.class.not.found", string));
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.ClassSymbol classSymbol, String string) {
        Symbol.CompletionFailure completionFailure = this.cachedCompletionFailure;
        completionFailure.sym = classSymbol;
        completionFailure.errmsg = string;
        return completionFailure;
    }

    public Symbol.ClassSymbol loadClass(Name name) throws Symbol.CompletionFailure {
        boolean bl = this.classes.get(name) == null;
        Symbol.ClassSymbol classSymbol = this.enterClass(name);
        if (classSymbol.members_field == null && classSymbol.completer != null) {
            try {
                classSymbol.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                if (bl) {
                    this.classes.remove(name);
                }
                throw completionFailure;
            }
        }
        return classSymbol;
    }

    public boolean packageExists(Name name) {
        return this.enterPackage(name).exists();
    }

    public Symbol.PackageSymbol enterPackage(Name name) {
        Symbol.PackageSymbol packageSymbol = this.packages.get(name);
        if (packageSymbol == null) {
            assert (name.length() != 0) : "rootPackage missing!";
            packageSymbol = new Symbol.PackageSymbol(Convert.shortName(name), this.enterPackage(Convert.packagePart(name)));
            packageSymbol.completer = this;
            this.packages.put(name, packageSymbol);
        }
        return packageSymbol;
    }

    public Symbol.PackageSymbol enterPackage(Name name, Symbol.PackageSymbol packageSymbol) {
        return this.enterPackage(Symbol.TypeSymbol.formFullName(name, packageSymbol));
    }

    private void includeClassFile(Symbol.PackageSymbol packageSymbol, FileEntry fileEntry) {
        int n;
        int n2;
        Object object;
        if ((packageSymbol.flags_field & 0x800000L) == 0L) {
            object = packageSymbol;
            while (object != null && ((Symbol)object).kind == 1) {
                ((Symbol)object).flags_field |= 0x800000L;
                object = ((Symbol)object).owner;
            }
        }
        if (((String)(object = fileEntry.getName())).endsWith(".class")) {
            n2 = 0x2000000;
            n = 6;
        } else {
            n2 = 0x4000000;
            n = 5;
        }
        Name name = this.names.fromString(((String)object).substring(0, ((String)object).length() - n));
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)packageSymbol.members_field.lookup((Name)name).sym;
        if (classSymbol == null) {
            classSymbol = this.enterClass(name, packageSymbol);
            if (classSymbol.classfile == null) {
                classSymbol.classfile = fileEntry;
            }
            if (classSymbol.owner == packageSymbol) {
                packageSymbol.members_field.enter(classSymbol);
            }
        } else if (classSymbol.classfile != null && (classSymbol.flags_field & (long)n2) == 0L && (classSymbol.flags_field & 0x6000000L) != 0L) {
            long l = fileEntry.lastModified();
            long l2 = classSymbol.classfile.lastModified();
            if (l >= 0L && l2 >= 0L && l > l2) {
                classSymbol.classfile = fileEntry;
            }
        }
        classSymbol.flags_field |= (long)n2;
    }

    private void list(String string, String string2, String[] stringArray, Symbol.PackageSymbol packageSymbol) {
        try {
            if (ClassReader.isZip(string)) {
                Archive archive = this.openArchive(string);
                if (string2.length() != 0 && !(string2 = string2.replace('\\', '/')).endsWith("/")) {
                    string2 = string2 + "/";
                }
                int n = string2.length();
                List<ZipEntry> list = archive.entries;
                while (list.nonEmpty()) {
                    ZipEntry zipEntry = (ZipEntry)list.head;
                    String string3 = zipEntry.getName();
                    if (string3.startsWith(string2)) {
                        if (this.endsWith(string3, stringArray)) {
                            String string4 = string3.substring(n);
                            if (string4.length() > 0 && string4.indexOf(47) < 0) {
                                this.includeClassFile(packageSymbol, new FileEntry.Zipped(string4, archive.zdir, zipEntry));
                            }
                        } else {
                            this.extraZipFileActions(packageSymbol, string3, string2, string);
                        }
                    }
                    list = list.tail;
                }
            } else {
                File file = string2.length() != 0 ? new File(string, string2) : new File(string);
                String[] stringArray2 = file.list();
                if (stringArray2 != null && this.caseMapCheck(file, string2)) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string5 = stringArray2[i];
                        if (this.isValidFile(string5, stringArray)) {
                            this.includeClassFile(packageSymbol, new FileEntry.Regular(string5, new File(file, string5)));
                            continue;
                        }
                        this.extraFileActions(packageSymbol, string5, file);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean endsWith(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isValidFile(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.endsWith(string2) || !this.isJavaIdentifier(string.substring(0, string.length() - string2.length()))) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaIdentifier(String string) {
        if (string.length() < 1) {
            return false;
        }
        if (surrogatesSupported) {
            int n = string.codePointAt(0);
            if (!Character.isJavaIdentifierStart(n)) {
                return false;
            }
            for (int i = Character.charCount(n); i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n)) continue;
                return false;
            }
        } else {
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                return false;
            }
            for (int i = 1; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean caseMapCheck(File file, String string) throws IOException {
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        String string2 = file.getCanonicalPath();
        char[] cArray = string2.toCharArray();
        char[] cArray2 = string.toCharArray();
        int n = cArray.length - 1;
        int n2 = cArray2.length - 1;
        while (n >= 0 && n2 >= 0) {
            while (n >= 0 && cArray[n] == File.separatorChar) {
                --n;
            }
            while (n2 >= 0 && cArray2[n2] == File.separatorChar) {
                --n2;
            }
            if (n < 0 || n2 < 0) continue;
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            --n;
            --n2;
        }
        return n2 < 0;
    }

    protected void extraZipFileActions(Symbol.PackageSymbol packageSymbol, String string, String string2, String string3) {
    }

    protected void extraFileActions(Symbol.PackageSymbol packageSymbol, String string, File file) {
    }

    private static boolean surrogatesSupported() {
        try {
            boolean bl = Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    private void listAll(Collection<String> collection, String string, String[] stringArray, Symbol.PackageSymbol packageSymbol) {
        for (String string2 : collection) {
            this.list(string2, string, stringArray, packageSymbol);
        }
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol) {
        Name name;
        if (packageSymbol.members_field == null) {
            packageSymbol.members_field = new Scope(packageSymbol);
        }
        if ((name = packageSymbol.fullname) == this.names.emptyPackage) {
            name = this.names.empty;
        }
        String string = ClassReader.externalizeFileName(name);
        this.listAll(this.paths.bootClassPath(), string, classOnly, packageSymbol);
        if (this.sourceCompleter != null && this.paths.sourcePath() == null) {
            this.listAll(this.paths.userClassPath(), string, classOrJava, packageSymbol);
        } else {
            this.listAll(this.paths.userClassPath(), string, classOnly, packageSymbol);
            if (this.sourceCompleter != null) {
                this.listAll(this.paths.sourcePath(), string, javaOnly, packageSymbol);
            }
        }
    }

    private void printVerbose(String string, String string2) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, string2));
    }

    private void printCCF(String string, Object object) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, object));
    }

    public static interface SourceCompleter {
        public void complete(Symbol.ClassSymbol var1, String var2, InputStream var3) throws Symbol.CompletionFailure;
    }

    static class Archive {
        ZipFile zdir;
        List<ZipEntry> entries;

        Archive(ZipFile zipFile, List<ZipEntry> list) {
            this.zdir = zipFile;
            this.entries = list;
        }
    }

    class AnnotationCompleter
    extends AnnotationDeproxy
    implements Annotate.Annotator {
        final Symbol sym;
        final List<CompoundAnnotationProxy> l;
        final String classFileName;

        @Override
        public String toString() {
            return " ClassReader annotate " + this.sym.owner + "." + this.sym + " with " + this.l;
        }

        AnnotationCompleter(Symbol symbol, List<CompoundAnnotationProxy> list) {
            this.sym = symbol;
            this.l = list;
            this.classFileName = ClassReader.this.currentClassFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enterAnnotation() {
            String string = ClassReader.this.currentClassFileName;
            try {
                ClassReader.this.currentClassFileName = this.classFileName;
                List<Attribute.Compound> list = this.deproxyCompoundList(this.l);
                this.sym.attributes_field = this.sym.attributes_field == null ? list : list.prependList(this.sym.attributes_field);
            }
            finally {
                ClassReader.this.currentClassFileName = string;
            }
        }
    }

    class AnnotationDefaultCompleter
    extends AnnotationDeproxy
    implements Annotate.Annotator {
        final Symbol.MethodSymbol sym;
        final Attribute value;
        final String classFileName;

        @Override
        public String toString() {
            return " ClassReader store default for " + this.sym.owner + "." + this.sym + " is " + this.value;
        }

        AnnotationDefaultCompleter(Symbol.MethodSymbol methodSymbol, Attribute attribute) {
            this.classFileName = ClassReader.this.currentClassFileName;
            this.sym = methodSymbol;
            this.value = attribute;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enterAnnotation() {
            String string = ClassReader.this.currentClassFileName;
            try {
                ClassReader.this.currentClassFileName = this.classFileName;
                this.sym.defaultValue = this.deproxy(this.sym.type.restype(), this.value);
            }
            finally {
                ClassReader.this.currentClassFileName = string;
            }
        }
    }

    class AnnotationDeproxy
    implements ProxyVisitor {
        Attribute result;
        Type type;

        AnnotationDeproxy() {
        }

        List<Attribute.Compound> deproxyCompoundList(List<CompoundAnnotationProxy> list) {
            ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
            List<CompoundAnnotationProxy> list2 = list;
            while (list2.nonEmpty()) {
                listBuffer.append(this.deproxyCompound((CompoundAnnotationProxy)list2.head));
                list2 = list2.tail;
            }
            return listBuffer.toList();
        }

        Attribute.Compound deproxyCompound(CompoundAnnotationProxy compoundAnnotationProxy) {
            ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> listBuffer = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
            List<Pair<Name, Attribute>> list = compoundAnnotationProxy.values;
            while (list.nonEmpty()) {
                Symbol.MethodSymbol methodSymbol = this.findAccessMethod(compoundAnnotationProxy.type, (Name)((Pair)list.head).fst);
                listBuffer.append(new Pair<Symbol.MethodSymbol, Attribute>(methodSymbol, this.deproxy(methodSymbol.type.restype(), (Attribute)((Pair)list.head).snd)));
                list = list.tail;
            }
            return new Attribute.Compound(compoundAnnotationProxy.type, listBuffer.toList());
        }

        Symbol.MethodSymbol findAccessMethod(Type type, Name name) {
            Scope.Entry entry = type.tsym.members().lookup(name);
            while (entry.scope != null) {
                Symbol symbol = entry.sym;
                if (symbol.kind == 16 && symbol.type.argtypes().length() == 0) {
                    return (Symbol.MethodSymbol)symbol;
                }
                entry = entry.next();
            }
            throw new AssertionError((Object)("cannot find method " + type + "." + name + "()"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Attribute deproxy(Type type, Attribute attribute) {
            Type type2 = this.type;
            try {
                this.type = type;
                attribute.accept(this);
                Attribute attribute2 = this.result;
                return attribute2;
            }
            finally {
                this.type = type2;
            }
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            this.result = constant;
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.result = clazz;
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            throw new AssertionError();
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            throw new AssertionError();
        }

        @Override
        public void visitArray(Attribute.Array array) {
            throw new AssertionError();
        }

        @Override
        public void visitError(Attribute.Error error) {
            throw new AssertionError();
        }

        @Override
        public void visitEnumAttributeProxy(EnumAttributeProxy enumAttributeProxy) {
            Symbol.TypeSymbol typeSymbol = enumAttributeProxy.enumType.tsym;
            Symbol.VarSymbol varSymbol = null;
            Scope.Entry entry = typeSymbol.members().lookup(enumAttributeProxy.enumerator);
            while (entry.scope != null) {
                if (entry.sym.kind == 4) {
                    varSymbol = (Symbol.VarSymbol)entry.sym;
                    break;
                }
                entry = entry.next();
            }
            if (varSymbol == null) {
                ClassReader.this.log.error(0, "unknown.enum.constant", ClassReader.this.currentClassFileName, typeSymbol, enumAttributeProxy.enumerator);
                this.result = new Attribute.Error(typeSymbol.type);
            } else {
                this.result = new Attribute.Enum(typeSymbol.type, varSymbol);
            }
        }

        @Override
        public void visitArrayAttributeProxy(ArrayAttributeProxy arrayAttributeProxy) {
            int n = arrayAttributeProxy.values.length();
            Attribute[] attributeArray = new Attribute[n];
            Type type = ClassReader.this.types.elemtype(this.type);
            int n2 = 0;
            List<Attribute> list = arrayAttributeProxy.values;
            while (list.nonEmpty()) {
                attributeArray[n2++] = this.deproxy(type, (Attribute)list.head);
                list = list.tail;
            }
            this.result = new Attribute.Array(this.type, attributeArray);
        }

        @Override
        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy compoundAnnotationProxy) {
            this.result = this.deproxyCompound(compoundAnnotationProxy);
        }
    }

    static class CompoundAnnotationProxy
    extends Attribute {
        final List<Pair<Name, Attribute>> values;

        public CompoundAnnotationProxy(Type type, List<Pair<Name, Attribute>> list) {
            super(type);
            this.values = list;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitCompoundAnnotationProxy(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("@");
            stringBuffer.append(this.type.tsym.fullName());
            stringBuffer.append("/*proxy*/{");
            boolean bl = true;
            List<Pair<Name, Attribute>> list = this.values;
            while (list.nonEmpty()) {
                Pair pair = (Pair)list.head;
                if (!bl) {
                    stringBuffer.append(",");
                }
                bl = false;
                stringBuffer.append(pair.fst);
                stringBuffer.append("=");
                stringBuffer.append(pair.snd);
                list = list.tail;
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    static class ArrayAttributeProxy
    extends Attribute {
        List<Attribute> values;

        ArrayAttributeProxy(List<Attribute> list) {
            super(null);
            this.values = list;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitArrayAttributeProxy(this);
        }

        public String toString() {
            return "{" + this.values + "}";
        }
    }

    static class EnumAttributeProxy
    extends Attribute {
        Type enumType;
        Name enumerator;

        public EnumAttributeProxy(Type type, Name name) {
            super(null);
            this.enumType = type;
            this.enumerator = name;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitEnumAttributeProxy(this);
        }

        public String toString() {
            return "/*proxy enum*/" + this.enumType + "." + this.enumerator;
        }
    }

    static interface ProxyVisitor
    extends Attribute.Visitor {
        public void visitEnumAttributeProxy(EnumAttributeProxy var1);

        public void visitArrayAttributeProxy(ArrayAttributeProxy var1);

        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy var1);
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.ClassSymbol classSymbol, Object object, Object object2) {
            super(classSymbol, Log.getLocalizedString("bad.class.file.header", object, object2));
        }
    }
}

