################################################################
### AES-128 in CTR mode			       	             ###
### bitsliced implementation for Intel Core 2 processors     ###
### requires support of SSE extensions up to SSSE3           ###
### Author: Emilia Käsper				     ###	
### Date: 2009-03-19					     ###
### Public domain        	             		     ###
################################################################

.include "common.s"

#####################
#int action in %edi
#ECRYPT_ctx* ctx in %rsi
#const u8* input in %rdx
#u8* output in %rcx
#u32 msglen in %r8d
#####################
.globl ECRYPT_process_bytes
ECRYPT_process_bytes:
cmpl	$0, %r8d
jne	.START
ret
.START:
# bitsliced key
leaq (%rsi), %rax

pushq	%rbx
pushq	%rbp
pushq	%r12
pushq	%r13
pushq	%r15

#msglen
movl	%r8d, %r12d
#input
movq	%rdx, %rbx
#output
movq	%rcx, %rbp

.ENC_BLOCK:
	movdqa 1408(%rsi), %xmm0
	movdqa %xmm0, %xmm1
	movdqa %xmm0, %xmm2
	movdqa %xmm1, %xmm3
	movdqa %xmm0, %xmm4
	movdqa %xmm2, %xmm5
	movdqa %xmm1, %xmm6
	movdqa %xmm3, %xmm7

	paddd CTRINC1, %xmm1
	paddd CTRINC2, %xmm2
	paddd CTRINC3, %xmm3
	paddd CTRINC4, %xmm4
	paddd CTRINC5, %xmm5
	paddd CTRINC6, %xmm6
	paddd CTRINC7, %xmm7

	pshufb M0, %xmm0
	pshufb M0, %xmm1
	pshufb M0, %xmm2
	pshufb M0, %xmm3
	pshufb M0, %xmm4
	pshufb M0, %xmm5
	pshufb M0, %xmm6
	pshufb M0, %xmm7

aes128 %xmm0, %xmm1, %xmm2, %xmm3, %xmm4, %xmm5, %xmm6, %xmm7, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %rax


# output in first block > [xmm8, xmm9, xmm12, xmm14, xmm11, xmm15, xmm10, xmm13] < last block

	cmpl  	$128, %r12d
	jb	.PARTIAL
	je	.FULL

	addl 	$8, 1408(%rsi)
	pxor	(%rbx), %xmm8
	pxor	16(%rbx), %xmm9
	pxor	32(%rbx), %xmm12
	pxor	48(%rbx), %xmm14
	pxor	64(%rbx), %xmm11
	pxor	80(%rbx), %xmm15
	pxor	96(%rbx), %xmm10
	pxor	112(%rbx), %xmm13
	movdqa	%xmm8,	(%rbp)
	movdqa	%xmm9,	16(%rbp)
	movdqa	%xmm12,	32(%rbp)
	movdqa	%xmm14,	48(%rbp)
	movdqa	%xmm11,	64(%rbp)
	movdqa	%xmm15,	80(%rbp)
	movdqa	%xmm10,	96(%rbp)
	movdqa	%xmm13,	112(%rbp)
	subl	$128, %r12d
	addq	$128, %rbx
	addq	$128, %rbp
	jmp	.ENC_BLOCK	
	
.PARTIAL:
	# add partial bytes #
	movl	%r12d,	%r13d
	shr	$4, 	%r12d
	addl	%r12d, 1408(%rsi)
	movq	%rsp,	%r15
	subq	$128, %rsp
	and $0xFFFFFFFFFFFFFF00, %rsp
	movdqa	%xmm8, (%rsp)	
	movdqa	%xmm9, 16(%rsp)
	movdqa	%xmm12, 32(%rsp)
	movdqa	%xmm14, 48(%rsp)
	movdqa	%xmm11, 64(%rsp)
	movdqa	%xmm15, 80(%rsp)
	movdqa	%xmm10, 96(%rsp)
	movdqa	%xmm13, 112(%rsp)
.BYTES:
	movb	(%rbx), %al
	xorb	(%rsp), %al
	movb	%al,	(%rbp)
	addq	$1,	%rbx
	addq	$1,	%rbp
	addq	$1,	%rsp
	subl	$1,	%r13d
	cmp	$0, 	%r13d
	jne	.BYTES	
	movq	%r15, %rsp
	jmp	.END
	
.FULL:
	addl 	$8, 1408(%rsi)
	pxor	(%rbx), %xmm8
	pxor	16(%rbx), %xmm9
	pxor	32(%rbx), %xmm12
	pxor	48(%rbx), %xmm14
	pxor	64(%rbx), %xmm11
	pxor	80(%rbx), %xmm15
	pxor	96(%rbx), %xmm10
	pxor	112(%rbx), %xmm13
	movdqa	%xmm8,	(%rbp)
	movdqa	%xmm9,	16(%rbp)
	movdqa	%xmm12,	32(%rbp)
	movdqa	%xmm14,	48(%rbp)
	movdqa	%xmm11,	64(%rbp)
	movdqa	%xmm15,	80(%rbp)
	movdqa	%xmm10,	96(%rbp)
	movdqa	%xmm13,	112(%rbp)


.END:
	popq	%r15
	popq	%r13
	popq	%r12
	popq	%rbp
	popq	%rbx
	ret
# Author: Emilia Käsper				     	
# Date: 2009-03-19					     
# Public domain 

.include "common.s"

.text
.p2align 5
.globl _ECRYPT_keysetup
.globl  ECRYPT_keysetup
_ECRYPT_keysetup:
ECRYPT_keysetup:
mov %rsp,%r11
and $31,%r11
add $0,%r11
sub %r11,%rsp

bitslicekey0 %rsi, %rdi

keyexp1  %xmm0, %xmm1, %xmm2, %xmm3, %xmm4, %xmm5, %xmm6, %xmm7, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %rdi
keyexp   %xmm0, %xmm1, %xmm4, %xmm6, %xmm3, %xmm7, %xmm2, %xmm5, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %xmm1, 2, %rdi
keyexp   %xmm0, %xmm1, %xmm3, %xmm2, %xmm6, %xmm5, %xmm4, %xmm7, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %xmm6, 3, %rdi
keyexp   %xmm0, %xmm1, %xmm6, %xmm4, %xmm2, %xmm7, %xmm3, %xmm5, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %xmm3, 4, %rdi
keyexp   %xmm0, %xmm1, %xmm2, %xmm3, %xmm4, %xmm5, %xmm6, %xmm7, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %xmm3, 5, %rdi
keyexp   %xmm0, %xmm1, %xmm4, %xmm6, %xmm3, %xmm7, %xmm2, %xmm5, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %xmm5, 6, %rdi
keyexp   %xmm0, %xmm1, %xmm3, %xmm2, %xmm6, %xmm5, %xmm4, %xmm7, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %xmm3, 7, %rdi
keyexp   %xmm0, %xmm1, %xmm6, %xmm4, %xmm2, %xmm7, %xmm3, %xmm5, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %xmm7, 8, %rdi
keyexp9  %xmm0, %xmm1, %xmm2, %xmm3, %xmm4, %xmm5, %xmm6, %xmm7, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %rdi
keyexp10 %xmm0, %xmm1, %xmm4, %xmm6, %xmm3, %xmm7, %xmm2, %xmm5, %xmm8, %xmm9, %xmm10, %xmm11, %xmm12, %xmm13, %xmm14, %xmm15, %rdi

add %r11,%rsp

ret
# Author: Emilia Käsper				     	
# Date: 2009-03-19					     
# Public domain 

.text
.p2align 5
.globl _ECRYPT_init
.globl ECRYPT_init
_ECRYPT_init:
ECRYPT_init:
mov %rsp,%r11
and $31,%r11
add $0,%r11
sub %r11,%rsp

# Nothing to do

add %r11,%rsp
mov %rdi,%rax
mov %rsi,%rdx
ret


.text
.p2align 5
.globl _ECRYPT_ivsetup
.globl ECRYPT_ivsetup
_ECRYPT_ivsetup:
ECRYPT_ivsetup:
mov %rsp,%r11
and $31,%r11
add $0,%r11
sub %r11,%rsp

movdqa 0(%rsi),%xmm0
movdqa %xmm0,1408(%rdi)

add %r11,%rsp
mov %rdi,%rax
mov %rsi,%rdx
ret
# Author: Emilia Käsper and Peter Schwabe
# Date: 2009-03-19
# Public domain

.data

.globl RCON
.globl ROTB
.globl EXPB0
.globl ONE
.globl BS0
.globl BS1
.globl BS2
.globl CTRINC1
.globl CTRINC2
.globl CTRINC3
.globl CTRINC4
.globl CTRINC5
.globl CTRINC6
.globl CTRINC7
.globl M0
.globl SRM0
.globl SR

.p2align 6
#.align 16

#.section .rodata

RCON: .int 0x00000000, 0x00000000, 0x00000000, 0xffffffff
ROTB: .int 0x0c000000, 0x00000000, 0x04000000, 0x08000000
EXPB0: .int 0x03030303, 0x07070707, 0x0b0b0b0b, 0x0f0f0f0f
CTRINC1: .int 0x00000001, 0x00000000, 0x00000000, 0x00000000
CTRINC2: .int 0x00000002, 0x00000000, 0x00000000, 0x00000000
CTRINC3: .int 0x00000003, 0x00000000, 0x00000000, 0x00000000
CTRINC4: .int 0x00000004, 0x00000000, 0x00000000, 0x00000000
CTRINC5: .int 0x00000005, 0x00000000, 0x00000000, 0x00000000
CTRINC6: .int 0x00000006, 0x00000000, 0x00000000, 0x00000000
CTRINC7: .int 0x00000007, 0x00000000, 0x00000000, 0x00000000

BS0: .quad 0x5555555555555555, 0x5555555555555555
BS1: .quad 0x3333333333333333, 0x3333333333333333
BS2: .quad 0x0f0f0f0f0f0f0f0f, 0x0f0f0f0f0f0f0f0f
ONE: .quad 0xffffffffffffffff, 0xffffffffffffffff
M0:  .quad 0x02060a0e03070b0f, 0x0004080c0105090d
SRM0:	.quad 0x0304090e00050a0f, 0x01060b0c0207080d
SR: .quad 0x0504070600030201, 0x0f0e0d0c0a09080b



