/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

class SynthContext {
    private static final Map contextMap = new HashMap();
    private JComponent component;
    private Region region;
    private SynthStyle style;
    private int state;

    public int getComponentState() {
        return this.state;
    }

    SynthContext() {
    }

    void dispose() {
        this.component = null;
        this.style = null;
        SynthContext.releaseContext(this);
    }

    boolean isSubregion() {
        return this.getRegion().isSubregion();
    }

    void setComponentState(int n2) {
        this.state = n2;
    }

    public Region getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseContext(SynthContext synthContext) {
        Map map = contextMap;
        synchronized (map) {
            List list = (List)contextMap.get(synthContext.getClass());
            if (list == null) {
                list = new ArrayList(5);
                contextMap.put(synthContext.getClass(), list);
            }
            list.add(synthContext);
        }
    }

    public SynthStyle getStyle() {
        return this.style;
    }

    void setStyle(SynthStyle synthStyle) {
        this.style = synthStyle;
    }

    public JComponent getComponent() {
        return this.component;
    }

    SynthContext(JComponent jComponent, Region region, SynthStyle synthStyle, int n2) {
        this.reset(jComponent, region, synthStyle, n2);
    }

    void reset(JComponent jComponent, Region region, SynthStyle synthStyle, int n2) {
        this.component = jComponent;
        this.region = region;
        this.style = synthStyle;
        this.state = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SynthContext getContext(Class clazz, JComponent jComponent, Region region, SynthStyle synthStyle, int n2) {
        SynthContext synthContext = null;
        Map map = contextMap;
        synchronized (map) {
            int n3;
            List list = (List)contextMap.get(clazz);
            if (list != null && (n3 = list.size()) > 0) {
                synthContext = (SynthContext)list.remove(n3 - 1);
            }
        }
        if (synthContext == null) {
            try {
                synthContext = (SynthContext)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("could not create: " + illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                System.out.println("ie: " + instantiationException);
            }
        }
        synthContext.reset(jComponent, region, synthStyle, n2);
        return synthContext;
    }
}

