/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class WindowsMenuBarUI
extends BasicMenuBarUI {
    protected void installDefaults() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            Color color = xPStyle.getColor("sysmetrics.menubar", null);
            if (color != null) {
                uIDefaults.put("MenuBar.background", new ColorUIResource(color));
            }
        } else {
            Object object = uIDefaults.get("MenuBar.classicBackground");
            if (object instanceof Object[] && ((Object[])object).length > 0) {
                uIDefaults.put("MenuBar.background", ((Object[])object)[0]);
            }
        }
        super.installDefaults();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.menuBar);
        if (actionMap == null) {
            actionMap = new ActionMapUIResource();
            SwingUtilities.replaceUIActionMap(this.menuBar, actionMap);
        }
        actionMap.put("takeFocus", new TakeFocus());
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuBarUI();
    }

    private static class TakeFocus
    extends AbstractAction {
        private TakeFocus() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                menuSelectionManager.setSelectedPath(menuElementArray);
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsLookAndFeel.repaintRootPane(jMenuBar);
            }
        }
    }
}

