/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;
import java.security.Permission;

public abstract class Authenticator {
    private static Authenticator theAuthenticator;
    private String requestingHost;
    private InetAddress requestingSite;
    private int requestingPort;
    private String requestingProtocol;
    private String requestingPrompt;
    private String requestingScheme;

    protected final int getRequestingPort() {
        return this.requestingPort;
    }

    private void reset() {
        this.requestingHost = null;
        this.requestingSite = null;
        this.requestingPort = -1;
        this.requestingProtocol = null;
        this.requestingPrompt = null;
        this.requestingScheme = null;
    }

    protected final String getRequestingHost() {
        return this.requestingHost;
    }

    protected final String getRequestingPrompt() {
        return this.requestingPrompt;
    }

    protected final String getRequestingProtocol() {
        return this.requestingProtocol;
    }

    protected final String getRequestingScheme() {
        return this.requestingScheme;
    }

    public static synchronized void setDefault(Authenticator authenticator) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            NetPermission netPermission = new NetPermission("setDefaultAuthenticator");
            securityManager.checkPermission(netPermission);
        }
        theAuthenticator = authenticator;
    }

    protected final InetAddress getRequestingSite() {
        return this.requestingSite;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n2, String string, String string2, String string3) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        if ((object = theAuthenticator) == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            super.reset();
            ((Authenticator)object).requestingSite = inetAddress;
            ((Authenticator)object).requestingPort = n2;
            ((Authenticator)object).requestingProtocol = string;
            ((Authenticator)object).requestingPrompt = string2;
            ((Authenticator)object).requestingScheme = string3;
            return ((Authenticator)object).getPasswordAuthentication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(String string, InetAddress inetAddress, int n2, String string2, String string3, String string4) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        if ((object = theAuthenticator) == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            super.reset();
            ((Authenticator)object).requestingHost = string;
            ((Authenticator)object).requestingSite = inetAddress;
            ((Authenticator)object).requestingPort = n2;
            ((Authenticator)object).requestingProtocol = string2;
            ((Authenticator)object).requestingPrompt = string3;
            ((Authenticator)object).requestingScheme = string4;
            return ((Authenticator)object).getPasswordAuthentication();
        }
    }
}

