/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.ch.ChannelInputStream;
import sun.nio.cs.StreamDecoder;
import sun.nio.cs.StreamEncoder;

public final class Channels {
    private Channels() {
    }

    public static InputStream newInputStream(ReadableByteChannel readableByteChannel) {
        return new ChannelInputStream(readableByteChannel);
    }

    public static OutputStream newOutputStream(final WritableByteChannel writableByteChannel) {
        return new OutputStream(){
            private ByteBuffer bb = null;
            private byte[] bs = null;
            private byte[] b1 = null;

            public void close() throws IOException {
                writableByteChannel.close();
            }

            public synchronized void write(int n2) throws IOException {
                if (this.b1 == null) {
                    this.b1 = new byte[1];
                }
                this.b1[0] = (byte)n2;
                this.write(this.b1);
            }

            public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
                if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (n3 == 0) {
                    return;
                }
                ByteBuffer byteBuffer = this.bs == byArray ? this.bb : ByteBuffer.wrap(byArray);
                byteBuffer.limit(Math.min(n2 + n3, byteBuffer.capacity()));
                byteBuffer.position(n2);
                this.bb = byteBuffer;
                this.bs = byArray;
                Channels.write(writableByteChannel, byteBuffer);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int write(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        if (writableByteChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)writableByteChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                if (!selectableChannel.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                return writableByteChannel.write(byteBuffer);
            }
        }
        return writableByteChannel.write(byteBuffer);
    }

    public static ReadableByteChannel newChannel(InputStream inputStream) {
        String string;
        if (inputStream instanceof FileInputStream && (string = inputStream.getClass().toString()).equals("java.io.FileInputStream")) {
            return ((FileInputStream)inputStream).getChannel();
        }
        return new ReadableByteChannelImpl(inputStream);
    }

    public static WritableByteChannel newChannel(OutputStream outputStream) {
        String string;
        if (outputStream instanceof FileOutputStream && (string = outputStream.getClass().toString()).equals("java.io.FileOutputStream")) {
            return ((FileOutputStream)outputStream).getChannel();
        }
        return new WritableByteChannelImpl(outputStream);
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, String string) {
        return Channels.newReader(readableByteChannel, Charset.forName(string).newDecoder(), -1);
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n2) {
        charsetDecoder.reset();
        return StreamDecoder.forDecoder(readableByteChannel, charsetDecoder, n2);
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, String string) {
        return Channels.newWriter(writableByteChannel, Charset.forName(string).newEncoder(), -1);
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n2) {
        charsetEncoder.reset();
        return StreamEncoder.forEncoder(writableByteChannel, charsetEncoder, n2);
    }

    private static class ReadableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements ReadableByteChannel {
        InputStream in;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private boolean open = true;
        private Object readLock = new Object();

        protected void implCloseChannel() throws IOException {
            this.in.close();
            this.open = false;
        }

        ReadableByteChannelImpl(InputStream inputStream) {
            this.in = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer byteBuffer) throws IOException {
            int n2 = byteBuffer.remaining();
            int n3 = 0;
            Object object = this.readLock;
            synchronized (object) {
                int n4;
                for (n4 = 0; n4 < n2; n4 += n3) {
                    int n5 = Math.min(n2 - n4, 8192);
                    if (this.buf.length < n5) {
                        this.buf = new byte[n5];
                    }
                    if (n4 > 0 && this.in.available() <= 0) break;
                    try {
                        this.begin();
                        n3 = this.in.read(this.buf, 0, n5);
                        this.end(n3 > 0);
                    }
                    catch (Throwable throwable) {
                        this.end(n3 > 0);
                        throw throwable;
                    }
                    if (n3 < 0) break;
                    byteBuffer.put(this.buf, 0, n3);
                }
                if (n3 < 0 && n4 == 0) {
                    return -1;
                }
                return n4;
            }
        }
    }

    private static class WritableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements WritableByteChannel {
        OutputStream out;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private boolean open = true;
        private Object writeLock = new Object();

        protected void implCloseChannel() throws IOException {
            this.out.close();
            this.open = false;
        }

        WritableByteChannelImpl(OutputStream outputStream) {
            this.out = outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(ByteBuffer byteBuffer) throws IOException {
            int n2 = byteBuffer.remaining();
            Object object = this.writeLock;
            synchronized (object) {
                int n3;
                int n4;
                for (n3 = 0; n3 < n2; n3 += n4) {
                    n4 = Math.min(n2 - n3, 8192);
                    if (this.buf.length < n4) {
                        this.buf = new byte[n4];
                    }
                    byteBuffer.get(this.buf, 0, n4);
                    try {
                        this.begin();
                        this.out.write(this.buf, 0, n4);
                        this.end(n4 > 0);
                    }
                    catch (Throwable throwable) {
                        this.end(n4 > 0);
                        throw throwable;
                    }
                }
                return n3;
            }
        }
    }
}

