/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.image.ColorModel;
import sun.java2d.loops.PixelWriter;

abstract class XorPixelWriter
extends PixelWriter {
    protected ColorModel dstCM;

    XorPixelWriter() {
    }

    public void writePixel(int n2, int n3) {
        Object object = this.dstRast.getDataElements(n2, n3, null);
        this.xorPixel(object);
        this.dstRast.setDataElements(n2, n3, object);
    }

    protected abstract void xorPixel(Object var1);

    public static class ByteData
    extends XorPixelWriter {
        byte[] xorData;

        protected void xorPixel(Object object) {
            byte[] byArray = (byte[])object;
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2 = i2;
                byArray[n2] = (byte)(byArray[n2] ^ this.xorData[i2]);
            }
        }

        ByteData(Object object, Object object2) {
            this.xorData = (byte[])object;
            this.xorPixel(object2);
            this.xorData = (byte[])object2;
        }
    }

    public static class DoubleData
    extends XorPixelWriter {
        long[] xorData;

        protected void xorPixel(Object object) {
            double[] dArray = (double[])object;
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                long l2 = Double.doubleToLongBits(dArray[i2]) ^ this.xorData[i2];
                dArray[i2] = Double.longBitsToDouble(l2);
            }
        }

        DoubleData(Object object, Object object2) {
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])object2;
            this.xorData = new long[dArray.length];
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.xorData[i2] = Double.doubleToLongBits(dArray[i2]) ^ Double.doubleToLongBits(dArray2[i2]);
            }
        }
    }

    public static class FloatData
    extends XorPixelWriter {
        int[] xorData;

        protected void xorPixel(Object object) {
            float[] fArray = (float[])object;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                int n2 = Float.floatToIntBits(fArray[i2]) ^ this.xorData[i2];
                fArray[i2] = Float.intBitsToFloat(n2);
            }
        }

        FloatData(Object object, Object object2) {
            float[] fArray = (float[])object;
            float[] fArray2 = (float[])object2;
            this.xorData = new int[fArray.length];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                this.xorData[i2] = Float.floatToIntBits(fArray[i2]) ^ Float.floatToIntBits(fArray2[i2]);
            }
        }
    }

    public static class IntData
    extends XorPixelWriter {
        int[] xorData;

        protected void xorPixel(Object object) {
            int[] nArray = (int[])object;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = i2;
                nArray[n2] = nArray[n2] ^ this.xorData[i2];
            }
        }

        IntData(Object object, Object object2) {
            this.xorData = (int[])object;
            this.xorPixel(object2);
            this.xorData = (int[])object2;
        }
    }

    public static class ShortData
    extends XorPixelWriter {
        short[] xorData;

        protected void xorPixel(Object object) {
            short[] sArray = (short[])object;
            for (int i2 = 0; i2 < sArray.length; ++i2) {
                int n2 = i2;
                sArray[n2] = (short)(sArray[n2] ^ this.xorData[i2]);
            }
        }

        ShortData(Object object, Object object2) {
            this.xorData = (short[])object;
            this.xorPixel(object2);
            this.xorData = (short[])object2;
        }
    }
}

