/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.Reflect;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.Util;

public class FileChannelImpl
extends FileChannel {
    private static NativeDispatcher nd;
    private static long allocationGranularity;
    private static Field isAMappedBufferField;
    private FileDescriptor fd;
    private boolean writable;
    private boolean readable;
    private boolean appending;
    private Object parent;
    private NativeThreadSet threads = new NativeThreadSet(2);
    private List lockList = new ArrayList(2);
    private Object positionLock = new Object();
    private static volatile boolean transferSupported;
    private static final int TRANSFER_SIZE = 8192;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    public static final int NO_LOCK = -1;
    public static final int LOCKED = 0;
    public static final int RET_EX_LOCK = 1;
    public static final int INTERRUPTED = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static native long initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l2;
            int n2;
            long l3;
            block11: {
                boolean bl2;
                long l4;
                block10: {
                    l3 = -1L;
                    n2 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l4 = 0L;
                            Object var8_6 = null;
                            this.threads.remove(n2);
                            bl2 = l3 > -1L;
                            break block10;
                        }
                        n2 = this.threads.add();
                        while ((l3 = this.position0(this.fd, -1L)) == -3L && this.isOpen()) {
                        }
                        l2 = IOStatus.normalize(l3);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.threads.remove(n2);
                        this.end(l3 > -1L);
                        if (!$assertionsDisabled && !IOStatus.check(l3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(l3)) {
                    throw new AssertionError();
                }
                return l4;
            }
            Object var8_7 = null;
            this.threads.remove(n2);
            this.end(l3 > -1L);
            if (!$assertionsDisabled && !IOStatus.check(l3)) {
                throw new AssertionError();
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long size() throws IOException {
        this.ensureOpen();
        Object object = this.positionLock;
        synchronized (object) {
            long l2;
            int n2;
            long l3;
            block11: {
                boolean bl2;
                long l4;
                block10: {
                    l3 = -1L;
                    n2 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l4 = -1L;
                            Object var8_6 = null;
                            this.threads.remove(n2);
                            bl2 = l3 > -1L;
                            break block10;
                        }
                        n2 = this.threads.add();
                        while ((l3 = this.size0(this.fd)) == -3L && this.isOpen()) {
                        }
                        l2 = IOStatus.normalize(l3);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.threads.remove(n2);
                        this.end(l3 > -1L);
                        if (!$assertionsDisabled && !IOStatus.check(l3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(l3)) {
                    throw new AssertionError();
                }
                return l4;
            }
            Object var8_7 = null;
            this.threads.remove(n2);
            this.end(l3 > -1L);
            if (!$assertionsDisabled && !IOStatus.check(l3)) {
                throw new AssertionError();
            }
            return l2;
        }
    }

    static {
        $assertionsDisabled = !FileChannelImpl.class.desiredAssertionStatus();
        transferSupported = true;
        Util.load();
        allocationGranularity = FileChannelImpl.initIDs();
        nd = new FileDispatcher();
        isAMappedBufferField = Reflect.lookupField("java.nio.MappedByteBuffer", "isAMappedBuffer");
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseChannel() throws IOException {
        nd.preClose(this.fd);
        this.threads.signal();
        List list = this.lockList;
        synchronized (list) {
            Iterator iterator = this.lockList.iterator();
            while (iterator.hasNext()) {
                FileLockImpl fileLockImpl = (FileLockImpl)iterator.next();
                fileLockImpl.invalidate();
                this.release0(this.fd, fileLockImpl.position(), fileLockImpl.size());
            }
            this.lockList.clear();
        }
        if (this.parent != null) {
            if (this.parent instanceof FileInputStream) {
                ((FileInputStream)this.parent).close();
            } else if (this.parent instanceof FileOutputStream) {
                ((FileOutputStream)this.parent).close();
            } else if (this.parent instanceof RandomAccessFile) {
                ((RandomAccessFile)this.parent).close();
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        } else {
            nd.close(this.fd);
        }
    }

    private native long map0(int var1, long var2, long var4) throws IOException;

    private native long transferTo0(int var1, long var2, long var4, int var6);

    private static native int unmap0(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkList(long l2, long l3) throws OverlappingFileLockException {
        List list = this.lockList;
        synchronized (list) {
            Iterator iterator = this.lockList.iterator();
            while (iterator.hasNext()) {
                FileLock fileLock = (FileLock)iterator.next();
                if (!fileLock.overlaps(l2, l3)) continue;
                throw new OverlappingFileLockException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void force(boolean bl2) throws IOException {
        int n2;
        int n3;
        block8: {
            boolean bl3;
            block7: {
                this.ensureOpen();
                n3 = -1;
                n2 = -1;
                try {
                    this.begin();
                    if (!this.isOpen()) {
                        Object var5_4 = null;
                        this.threads.remove(n2);
                        bl3 = n3 > -1;
                        break block7;
                    }
                    n2 = this.threads.add();
                    while ((n3 = this.force0(this.fd, bl2)) == -3) {
                        if (this.isOpen()) continue;
                        break block8;
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.threads.remove(n2);
                    this.end(n3 > -1);
                    if (!$assertionsDisabled && !IOStatus.check(n3)) {
                        throw new AssertionError();
                    }
                    throw throwable;
                }
            }
            this.end(bl3);
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return;
        }
        Object var5_5 = null;
        this.threads.remove(n2);
        this.end(n3 > -1);
        if (!$assertionsDisabled && !IOStatus.check(n3)) {
            throw new AssertionError();
        }
    }

    private native long size0(FileDescriptor var1);

    private native int truncate0(FileDescriptor var1, long var2);

    private native long position0(FileDescriptor var1, long var2);

    native void release0(FileDescriptor var1, long var2, long var4) throws IOException;

    private native int force0(FileDescriptor var1, boolean var2);

    native int lock0(FileDescriptor var1, boolean var2, long var3, long var5, boolean var7) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n2;
            int n3;
            int n4;
            block12: {
                boolean bl2;
                int n5;
                block11: {
                    n4 = 0;
                    n3 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n5 = 0;
                            Object var7_7 = null;
                            this.threads.remove(n3);
                            bl2 = n4 > 0;
                            break block11;
                        }
                        n3 = this.threads.add();
                        while ((n4 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.positionLock)) == -3 && this.isOpen()) {
                        }
                        n2 = IOStatus.normalize(n4);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.threads.remove(n3);
                        this.end(n4 > 0);
                        if (!$assertionsDisabled && !IOStatus.check(n4)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(n4)) {
                    throw new AssertionError();
                }
                return n5;
            }
            Object var7_8 = null;
            this.threads.remove(n3);
            this.end(n4 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            int n2;
            int n3;
            int n4;
            block13: {
                boolean bl2;
                int n5;
                block12: {
                    n4 = 0;
                    n3 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n5 = 0;
                            Object var7_7 = null;
                            this.threads.remove(n3);
                            bl2 = n4 > 0;
                            break block12;
                        }
                        n3 = this.threads.add();
                        if (this.appending) {
                            this.position(this.size());
                        }
                        while ((n4 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.positionLock)) == -3 && this.isOpen()) {
                        }
                        n2 = IOStatus.normalize(n4);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.threads.remove(n3);
                        this.end(n4 > 0);
                        if (!$assertionsDisabled && !IOStatus.check(n4)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(n4)) {
                    throw new AssertionError();
                }
                return n5;
            }
            Object var7_8 = null;
            this.threads.remove(n3);
            this.end(n4 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer, long l2) throws IOException {
        int n2;
        int n3;
        int n4;
        block8: {
            if (byteBuffer == null) {
                throw new NullPointerException();
            }
            this.ensureOpen();
            n4 = 0;
            n3 = -1;
            this.begin();
            if (this.isOpen()) break block8;
            int n5 = -1;
            Object var8_7 = null;
            this.threads.remove(n3);
            this.end(n4 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw new AssertionError();
            }
            return n5;
        }
        try {
            n3 = this.threads.add();
            while ((n4 = IOUtil.read(this.fd, byteBuffer, l2, nd, this.positionLock)) == -3 && this.isOpen()) {
            }
            n2 = IOStatus.normalize(n4);
            Object var8_8 = null;
            this.threads.remove(n3);
            this.end(n4 > 0);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.threads.remove(n3);
            this.end(n4 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw new AssertionError();
            }
            throw throwable;
        }
        if (!$assertionsDisabled && !IOStatus.check(n4)) {
            throw new AssertionError();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, long l2) throws IOException {
        int n2;
        int n3;
        int n4;
        block9: {
            if (byteBuffer == null) {
                throw new NullPointerException();
            }
            this.ensureOpen();
            if (l2 < 0L) {
                throw new IllegalArgumentException("Negative position");
            }
            n4 = 0;
            n3 = -1;
            this.begin();
            if (this.isOpen()) break block9;
            int n5 = -1;
            Object var8_7 = null;
            this.threads.remove(n3);
            this.end(n4 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw new AssertionError();
            }
            return n5;
        }
        try {
            n3 = this.threads.add();
            while ((n4 = IOUtil.write(this.fd, byteBuffer, l2, nd, this.positionLock)) == -3 && this.isOpen()) {
            }
            n2 = IOStatus.normalize(n4);
            Object var8_8 = null;
            this.threads.remove(n3);
            this.end(n4 > 0);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.threads.remove(n3);
            this.end(n4 > 0);
            if (!$assertionsDisabled && !IOStatus.check(n4)) {
                throw new AssertionError();
            }
            throw throwable;
        }
        if (!$assertionsDisabled && !IOStatus.check(n4)) {
            throw new AssertionError();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long read0(ByteBuffer[] byteBufferArray) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l2;
            int n2;
            long l3;
            block12: {
                boolean bl2;
                long l4;
                block11: {
                    l3 = 0L;
                    n2 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l4 = 0L;
                            Object var9_7 = null;
                            this.threads.remove(n2);
                            bl2 = l3 > 0L;
                            break block11;
                        }
                        n2 = this.threads.add();
                        while ((l3 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l2 = IOStatus.normalize(l3);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(n2);
                        this.end(l3 > 0L);
                        if (!$assertionsDisabled && !IOStatus.check(l3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(l3)) {
                    throw new AssertionError();
                }
                return l4;
            }
            Object var9_8 = null;
            this.threads.remove(n2);
            this.end(l3 > 0L);
            if (!$assertionsDisabled && !IOStatus.check(l3)) {
                throw new AssertionError();
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long write0(ByteBuffer[] byteBufferArray) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            long l2;
            int n2;
            long l3;
            block13: {
                boolean bl2;
                long l4;
                block12: {
                    l3 = 0L;
                    n2 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l4 = 0L;
                            Object var9_7 = null;
                            this.threads.remove(n2);
                            bl2 = l3 > 0L;
                            break block12;
                        }
                        n2 = this.threads.add();
                        if (this.appending) {
                            this.position(this.size());
                        }
                        while ((l3 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l2 = IOStatus.normalize(l3);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(n2);
                        this.end(l3 > 0L);
                        if (!$assertionsDisabled && !IOStatus.check(l3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(l3)) {
                    throw new AssertionError();
                }
                return l4;
            }
            Object var9_8 = null;
            this.threads.remove(n2);
            this.end(l3 > 0L);
            if (!$assertionsDisabled && !IOStatus.check(l3)) {
                throw new AssertionError();
            }
            return l2;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read0(Util.subsequence(byteBufferArray, n2, n3));
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.write0(Util.subsequence(byteBufferArray, n2, n3));
    }

    private static void unmap(MappedByteBuffer mappedByteBuffer) {
        Cleaner cleaner = ((DirectBuffer)((Object)mappedByteBuffer)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileChannel position(long l2) throws IOException {
        this.ensureOpen();
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int n2;
            long l3;
            block12: {
                boolean bl2;
                FileChannel fileChannel;
                block11: {
                    l3 = -1L;
                    n2 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            fileChannel = null;
                            Object var9_7 = null;
                            this.threads.remove(n2);
                            bl2 = l3 > -1L;
                            break block11;
                        }
                        n2 = this.threads.add();
                        while ((l3 = this.position0(this.fd, l2)) == -3L && this.isOpen()) {
                        }
                        fileChannelImpl = this;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.threads.remove(n2);
                        this.end(l3 > -1L);
                        if (!$assertionsDisabled && !IOStatus.check(l3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(l3)) {
                    throw new AssertionError();
                }
                return fileChannel;
            }
            Object var9_8 = null;
            this.threads.remove(n2);
            this.end(l3 > -1L);
            if (!$assertionsDisabled && !IOStatus.check(l3)) {
                throw new AssertionError();
            }
            return fileChannelImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileChannel truncate(long l2) throws IOException {
        this.ensureOpen();
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 > this.size()) {
            return this;
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.positionLock;
        synchronized (object) {
            FileChannelImpl fileChannelImpl;
            int n2;
            int n3;
            block14: {
                boolean bl2;
                FileChannel fileChannel;
                block13: {
                    n3 = -1;
                    n2 = -1;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            fileChannel = null;
                            Object var8_7 = null;
                            this.threads.remove(n2);
                            bl2 = n3 > -1;
                            break block13;
                        }
                        n2 = this.threads.add();
                        while ((n3 = this.truncate0(this.fd, l2)) == -3 && this.isOpen()) {
                        }
                        fileChannelImpl = this;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.threads.remove(n2);
                        this.end(n3 > -1);
                        if (!$assertionsDisabled && !IOStatus.check(n3)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return fileChannel;
            }
            Object var8_8 = null;
            this.threads.remove(n2);
            this.end(n3 > -1);
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return fileChannelImpl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileLock lock(long l2, long l3, boolean bl2) throws IOException {
        int n2;
        boolean bl3;
        FileLockImpl fileLockImpl;
        block17: {
            FileLockImpl fileLockImpl3;
            block16: {
                FileLock fileLock;
                block15: {
                    this.ensureOpen();
                    if (bl2 && !this.readable) {
                        throw new NonReadableChannelException();
                    }
                    if (!bl2 && !this.writable) {
                        throw new NonWritableChannelException();
                    }
                    fileLockImpl = new FileLockImpl(this, l2, l3, bl2);
                    this.checkList(l2, l3);
                    this.addList(fileLockImpl);
                    bl3 = true;
                    n2 = -1;
                    try {
                        try {
                            this.begin();
                            if (!this.isOpen()) {
                                fileLock = null;
                                Object var13_10 = null;
                                this.threads.remove(n2);
                                break block15;
                            }
                            n2 = this.threads.add();
                            int n3 = this.lock0(this.fd, true, l2, l3, bl2);
                            if (n3 == 1) {
                                if (!$assertionsDisabled && !bl2) {
                                    throw new AssertionError();
                                }
                                FileLockImpl fileLockImpl2 = new FileLockImpl(this, l2, l3, false);
                                this.addList(fileLockImpl2);
                                this.removeList(fileLockImpl);
                                fileLockImpl3 = fileLockImpl2;
                                break block16;
                            }
                            if (n3 == 2 || n3 == -1) {
                                this.removeList(fileLockImpl);
                                bl3 = false;
                            }
                            break block17;
                        }
                        catch (IOException iOException) {
                            this.removeList(fileLockImpl);
                            throw iOException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        this.threads.remove(n2);
                        try {
                            this.end(bl3);
                            throw throwable;
                        }
                        catch (ClosedByInterruptException closedByInterruptException) {
                            throw new FileLockInterruptionException();
                        }
                    }
                }
                try {}
                catch (ClosedByInterruptException closedByInterruptException) {
                    throw new FileLockInterruptionException();
                }
                this.end(bl3);
                return fileLock;
            }
            Object var13_11 = null;
            this.threads.remove(n2);
            try {}
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new FileLockInterruptionException();
            }
            this.end(bl3);
            return fileLockImpl3;
        }
        Object var13_12 = null;
        this.threads.remove(n2);
        try {}
        catch (ClosedByInterruptException closedByInterruptException) {
            throw new FileLockInterruptionException();
        }
        this.end(bl3);
        return fileLockImpl;
    }

    public FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        this.ensureOpen();
        if (bl2 && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!bl2 && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = new FileLockImpl(this, l2, l3, bl2);
        this.checkList(l2, l3);
        this.addList(fileLockImpl);
        int n2 = this.lock0(this.fd, false, l2, l3, bl2);
        if (n2 == -1) {
            this.removeList(fileLockImpl);
            return null;
        }
        if (n2 == 1) {
            if (!$assertionsDisabled && !bl2) {
                throw new AssertionError();
            }
            FileLockImpl fileLockImpl2 = new FileLockImpl(this, l2, l3, false);
            this.addList(fileLockImpl2);
            this.removeList(fileLockImpl);
            return fileLockImpl2;
        }
        return fileLockImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addList(FileLock fileLock) {
        List list = this.lockList;
        synchronized (list) {
            this.lockList.add(fileLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeList(FileLock fileLock) {
        List list = this.lockList;
        synchronized (list) {
            this.lockList.remove(fileLock);
        }
    }

    public long transferFrom(ReadableByteChannel readableByteChannel, long l2, long l3) throws IOException {
        this.ensureOpen();
        if (!readableByteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (l2 < 0L || l3 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 > this.size()) {
            return 0L;
        }
        if (readableByteChannel instanceof FileChannelImpl) {
            return this.transferFromFileChannel((FileChannelImpl)readableByteChannel, l2, l3);
        }
        return this.transferFromArbitraryChannel(readableByteChannel, l2, l3);
    }

    private long transferFromArbitraryChannel(ReadableByteChannel readableByteChannel, long l2, long l3) throws IOException {
        int n2 = (int)Math.min(l3, 8192L);
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n2);
        long l4 = 0L;
        long l5 = l2;
        try {
            Util.erase(byteBuffer);
            while (l4 < l3) {
                byteBuffer.limit(Math.min((int)(l3 - l4), 8192));
                int n3 = readableByteChannel.read(byteBuffer);
                if (n3 <= 0) break;
                byteBuffer.flip();
                int n4 = this.write(byteBuffer, l5);
                l4 += (long)n4;
                if (n4 != n3) break;
                l5 += (long)n4;
                byteBuffer.clear();
            }
            long l6 = l4;
            return l6;
        }
        catch (IOException iOException) {
            if (l4 > 0L) {
                long l7 = l4;
                return l7;
            }
            throw iOException;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer);
        }
    }

    private long transferToArbitraryChannel(long l2, int n2, WritableByteChannel writableByteChannel) throws IOException {
        int n3 = Math.min(n2, 8192);
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n3);
        long l3 = 0L;
        long l4 = l2;
        try {
            Util.erase(byteBuffer);
            while (l3 < (long)n2) {
                byteBuffer.limit(Math.min((int)((long)n2 - l3), 8192));
                int n4 = this.read(byteBuffer, l4);
                if (n4 <= 0) break;
                byteBuffer.flip();
                int n5 = writableByteChannel.write(byteBuffer);
                l3 += (long)n5;
                if (n5 != n4) break;
                l4 += (long)n5;
                byteBuffer.clear();
            }
            long l5 = l3;
            return l5;
        }
        catch (IOException iOException) {
            if (l3 > 0L) {
                long l6 = l3;
                return l6;
            }
            throw iOException;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToDirectly(long l2, int n2, WritableByteChannel writableByteChannel) throws IOException {
        int n3;
        long l3;
        block11: {
            long l4;
            FileDescriptor fileDescriptor;
            block10: {
                if (!transferSupported) {
                    return -4L;
                }
                fileDescriptor = null;
                if (writableByteChannel instanceof FileChannelImpl) {
                    fileDescriptor = ((FileChannelImpl)writableByteChannel).fd;
                } else if (writableByteChannel instanceof SelChImpl) {
                    fileDescriptor = ((SelChImpl)((Object)writableByteChannel)).getFD();
                }
                if (fileDescriptor == null) {
                    return -4L;
                }
                l3 = -1L;
                n3 = -1;
                this.begin();
                if (this.isOpen()) break block10;
                long l5 = -1L;
                this.threads.remove(n3);
                this.end(l3 > -1L);
                return l5;
            }
            try {
                n3 = this.threads.add();
                while ((l3 = this.transferTo0(IOUtil.fdVal(this.fd), l2, n2, IOUtil.fdVal(fileDescriptor))) == -3L && this.isOpen()) {
                }
                if (l3 != -4L) break block11;
                transferSupported = false;
                l4 = -4L;
                this.threads.remove(n3);
                this.end(l3 > -1L);
            }
            catch (Throwable throwable) {
                this.threads.remove(n3);
                this.end(l3 > -1L);
                throw throwable;
            }
            return l4;
        }
        long l6 = IOStatus.normalize(l3);
        this.threads.remove(n3);
        this.end(l3 > -1L);
        return l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferToTrustedChannel(long l2, int n2, WritableByteChannel writableByteChannel) throws IOException {
        long l3;
        block4: {
            if (!(writableByteChannel instanceof FileChannelImpl) && !(writableByteChannel instanceof SelChImpl)) {
                return -4L;
            }
            MappedByteBuffer mappedByteBuffer = null;
            try {
                mappedByteBuffer = this.map(FileChannel.MapMode.READ_ONLY, l2, n2);
                l3 = writableByteChannel.write(mappedByteBuffer);
                if (mappedByteBuffer == null) break block4;
            }
            catch (Throwable throwable) {
                if (mappedByteBuffer != null) {
                    FileChannelImpl.unmap(mappedByteBuffer);
                }
                throw throwable;
            }
            FileChannelImpl.unmap(mappedByteBuffer);
        }
        return l3;
    }

    public long transferTo(long l2, long l3, WritableByteChannel writableByteChannel) throws IOException {
        long l4;
        this.ensureOpen();
        if (!writableByteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (writableByteChannel instanceof FileChannelImpl && !((FileChannelImpl)writableByteChannel).writable) {
            throw new NonWritableChannelException();
        }
        if (l2 < 0L || l3 < 0L) {
            throw new IllegalArgumentException();
        }
        long l5 = this.size();
        if (l2 > l5) {
            return 0L;
        }
        int n2 = (int)Math.min(l3, Integer.MAX_VALUE);
        if (l5 - l2 < (long)n2) {
            n2 = (int)(l5 - l2);
        }
        if ((l4 = this.transferToDirectly(l2, n2, writableByteChannel)) >= 0L) {
            return l4;
        }
        l4 = this.transferToTrustedChannel(l2, n2, writableByteChannel);
        if (l4 >= 0L) {
            return l4;
        }
        return this.transferToArbitraryChannel(l2, n2, writableByteChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferFromFileChannel(FileChannelImpl fileChannelImpl, long l2, long l3) throws IOException {
        long l4;
        block6: {
            MappedByteBuffer mappedByteBuffer = null;
            try {
                long l5 = 0L;
                int n2 = (int)Math.min(l3, Integer.MAX_VALUE);
                Object object = fileChannelImpl.positionLock;
                synchronized (object) {
                    long l6 = fileChannelImpl.position();
                    mappedByteBuffer = fileChannelImpl.map(FileChannel.MapMode.READ_ONLY, l6, n2);
                    l5 = this.write(mappedByteBuffer, l2);
                    fileChannelImpl.position(l6 + l5);
                }
                l4 = l5;
                if (mappedByteBuffer == null) break block6;
            }
            catch (Throwable throwable) {
                if (mappedByteBuffer != null) {
                    FileChannelImpl.unmap(mappedByteBuffer);
                }
                throw throwable;
            }
            FileChannelImpl.unmap(mappedByteBuffer);
        }
        return l4;
    }

    void release(FileLockImpl fileLockImpl) throws IOException {
        this.ensureOpen();
        this.release0(this.fd, fileLockImpl.position(), fileLockImpl.size());
        this.removeList(fileLockImpl);
    }

    private FileChannelImpl(FileDescriptor fileDescriptor, boolean bl2, boolean bl3, Object object, boolean bl4) {
        this.fd = fileDescriptor;
        this.readable = bl2;
        this.writable = bl3;
        this.parent = object;
        this.appending = bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l2, long l3) throws IOException {
        Unmapper unmapper;
        int n2;
        int n3;
        int n4;
        long l4;
        block31: {
            MappedByteBuffer mappedByteBuffer;
            int n5;
            block29: {
                block30: {
                    block28: {
                        this.ensureOpen();
                        if (l2 < 0L) {
                            throw new IllegalArgumentException("Negative position");
                        }
                        if (l3 < 0L) {
                            throw new IllegalArgumentException("Negative size");
                        }
                        if (l3 > Integer.MAX_VALUE) {
                            throw new IllegalArgumentException("Size exceeds Integer.MAX_VALUE");
                        }
                        n5 = -1;
                        if (mapMode == FileChannel.MapMode.READ_ONLY) {
                            n5 = 0;
                        } else if (mapMode == FileChannel.MapMode.READ_WRITE) {
                            n5 = 1;
                        } else if (mapMode == FileChannel.MapMode.PRIVATE) {
                            n5 = 2;
                        }
                        if (!$assertionsDisabled && n5 < 0) {
                            throw new AssertionError();
                        }
                        if (mapMode != FileChannel.MapMode.READ_ONLY && !this.writable) {
                            throw new NonWritableChannelException();
                        }
                        if (!this.readable) {
                            throw new NonReadableChannelException();
                        }
                        l4 = -1L;
                        n4 = -1;
                        this.begin();
                        if (this.isOpen()) break block28;
                        MappedByteBuffer mappedByteBuffer2 = null;
                        Object var15_11 = null;
                        this.threads.remove(n4);
                        this.end(l4 > 0L);
                        if (!$assertionsDisabled && !IOStatus.check(l4)) {
                            throw new AssertionError();
                        }
                        return mappedByteBuffer2;
                    }
                    n4 = this.threads.add();
                    if (this.size() < l2 + l3) {
                        while ((n3 = this.truncate0(this.fd, l2 + l3)) == -3 && this.isOpen()) {
                        }
                    }
                    if (l3 != 0L) break block29;
                    l4 = 0L;
                    if (this.writable && n5 != 0) break block30;
                    MappedByteBuffer mappedByteBuffer3 = Util.newMappedByteBufferR(0, 0L, null);
                    Object var15_12 = null;
                    this.threads.remove(n4);
                    this.end(l4 > 0L);
                    if (!$assertionsDisabled && !IOStatus.check(l4)) {
                        throw new AssertionError();
                    }
                    return mappedByteBuffer3;
                }
                MappedByteBuffer mappedByteBuffer4 = Util.newMappedByteBuffer(0, 0L, null);
                Object var15_13 = null;
                this.threads.remove(n4);
                this.end(l4 > 0L);
                if (!$assertionsDisabled && !IOStatus.check(l4)) {
                    throw new AssertionError();
                }
                return mappedByteBuffer4;
            }
            try {
                n3 = (int)(l2 % allocationGranularity);
                while ((l4 = this.map0(n5, l2 - (long)n3, l3 + (long)n3)) == -3L && this.isOpen()) {
                }
                if (!$assertionsDisabled && l4 <= 0L) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && l4 % allocationGranularity != 0L) {
                    throw new AssertionError();
                }
                n2 = (int)l3;
                unmapper = new Unmapper(l4, l3 + (long)n3);
                if (this.writable && n5 != 0) break block31;
                mappedByteBuffer = Util.newMappedByteBufferR(n2, l4 + (long)n3, unmapper);
                Object var15_14 = null;
                this.threads.remove(n4);
                this.end(l4 > 0L);
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                this.threads.remove(n4);
                this.end(l4 > 0L);
                if (!$assertionsDisabled && !IOStatus.check(l4)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !IOStatus.check(l4)) {
                throw new AssertionError();
            }
            return mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(n2, l4 + (long)n3, unmapper);
        Object var15_15 = null;
        this.threads.remove(n4);
        this.end(l4 > 0L);
        if (!$assertionsDisabled && !IOStatus.check(l4)) {
            throw new AssertionError();
        }
        return mappedByteBuffer;
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl2, boolean bl3, Object object) {
        return new FileChannelImpl(fileDescriptor, bl2, bl3, object, false);
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl2, boolean bl3, Object object, boolean bl4) {
        return new FileChannelImpl(fileDescriptor, bl2, bl3, object, bl4);
    }

    private static class Unmapper
    implements Runnable {
        private long address;
        private long size;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !(class$sun$nio$ch$FileChannelImpl == null ? (class$sun$nio$ch$FileChannelImpl = FileChannelImpl.class$("sun.nio.ch.FileChannelImpl")) : class$sun$nio$ch$FileChannelImpl).desiredAssertionStatus();
        }

        public void run() {
            if (this.address == 0L) {
                return;
            }
            FileChannelImpl.unmap0(this.address, this.size);
            this.address = 0L;
        }

        private Unmapper(long l2, long l3) {
            if (!$assertionsDisabled && l2 == 0L) {
                throw new AssertionError();
            }
            this.address = l2;
            this.size = l3;
        }
    }
}

