/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AbstractPollArrayWrapper;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;

class PollArrayWrapper
extends AbstractPollArrayWrapper {
    static final short POLLCONN = 4;
    int interruptFD;

    void free() {
        this.pollArray.free();
    }

    public void interrupt() {
        PollArrayWrapper.interrupt(this.interruptFD);
    }

    PollArrayWrapper(int n2) {
        n2 = (n2 + 1) * 8;
        this.pollArray = new AllocatedNativeObject(n2, false);
        this.pollArrayAddress = this.pollArray.address();
        this.totalChannels = 1;
    }

    void grow(int n2) {
        PollArrayWrapper pollArrayWrapper = new PollArrayWrapper(n2);
        for (int i2 = 0; i2 < this.totalChannels; ++i2) {
            PollArrayWrapper.replaceEntry(this, i2, pollArrayWrapper, i2);
        }
        this.pollArray.free();
        this.pollArray = pollArrayWrapper.pollArray;
        this.pollArrayAddress = this.pollArray.address();
    }

    private static native void interrupt(int var0);

    void release(int n2) {
    }

    void initInterrupt(int n2, int n3) {
        this.interruptFD = n3;
        this.putDescriptor(0, n2);
        this.putEventOps(0, 1);
        this.putReventOps(0, 0);
    }

    int poll(int n2, int n3, long l2) {
        return this.poll0(this.pollArrayAddress + (long)(n3 * 8), n2, l2);
    }

    private native int poll0(long var1, int var3, long var4);

    void addEntry(SelChImpl selChImpl) {
        this.putDescriptor(this.totalChannels, IOUtil.fdVal(selChImpl.getFD()));
        this.putEventOps(this.totalChannels, 0);
        this.putReventOps(this.totalChannels, 0);
        ++this.totalChannels;
    }

    static void replaceEntry(PollArrayWrapper pollArrayWrapper, int n2, PollArrayWrapper pollArrayWrapper2, int n3) {
        pollArrayWrapper2.putDescriptor(n3, pollArrayWrapper.getDescriptor(n2));
        pollArrayWrapper2.putEventOps(n3, pollArrayWrapper.getEventOps(n2));
        pollArrayWrapper2.putReventOps(n3, pollArrayWrapper.getReventOps(n2));
    }
}

