
#ifndef ARCS_H
#define ARCS_H

#include "basic.h"

#define MAX_ARCCOLORS 7
#define MAX_ARCPATHS 128
#define MAX_ARCPATHLEN 16

class ArcViz : public Visualization {

public:
	// needs to be reset by caller
	int num_paths;
	// needs to be set by caller (in screen coordinates)
	float archeight;
	// screen dimensions
	ArcViz(int sx, int sy, int xs, int ys);
	// draw all the arcs
	void Draw();
	// simply increments num_paths
	void AddPath();
	// p: path number
	// id: integer label of the node
	// c_ind: color index into linearNodeColors
	// x: x-coordinate (0.0-1.0)
	void AddNode(int p, int id, int c_ind, float x);
	// simply sets y coordinate of path (not normalized, actual screen coordinates)
	void SetPathY(int p, float y);

private:
	void DrawCircleSegment(float x1, float x2, float y, int cind1, int cind2);
	float linearNodeColors[MAX_ARCCOLORS][3];
	float pathxs[MAX_ARCPATHS][MAX_ARCPATHLEN]; // range from startx to startx + xsize
	int pathlens[MAX_ARCPATHS];
	float pathy[MAX_ARCPATHS]; // range from starty to starty + ysize
	int pathcolors[MAX_ARCPATHS][MAX_ARCPATHLEN]; // index into linearNodeColors
	int pathnodelabels[MAX_ARCPATHS][MAX_ARCPATHLEN];
};



#endif

