
#include <stdio.h>
#include <math.h>
#include "glut.h"
#include "basic.h"


Visualization::Visualization() { };

Visualization::Visualization(int sx, int sy, int xs, int ys) : startx(sx), starty(sy), xsize(xs), ysize(ys) { };


int Visualization::ClickDetected(int x, int y) {
	if ((y>=starty)&&(y<=starty+ysize) &&
		(x>=startx)&&(x<=startx+xsize)) {
		return 1;
	} else {
		return 0;
	}
}

Cube::Cube() { }

Cube::Cube(float x, float y, float z, float s) : sx(x), sy(y), sz(z), size(s) { }

void Cube::Init(float x, float y, float z, float s) {
	sx = x; sy = y; sz = z; size = s;
}

void Cube::Draw() { 

	glBegin(GL_QUADS);

	// z = 0
	glVertex3f(sx,sy,sz);
	glVertex3f(sx,sy+size,sz);
	glVertex3f(sx+size,sy+size,sz);
	glVertex3f(sx+size,sy,sz);
	// z = 1
	glVertex3f(sx,sy,sz+size);
	glVertex3f(sx,sy+size,sz+size);
	glVertex3f(sx+size,sy+size,sz+size);
	glVertex3f(sx+size,sy,sz+size);
	// y = 0
	glVertex3f(sx,sy,sz);
	glVertex3f(sx,sy,sz+size);
	glVertex3f(sx+size,sy,sz+size);
	glVertex3f(sx+size,sy,sz);
	// y = 1
	glVertex3f(sx,sy+size,sz);
	glVertex3f(sx,sy+size,sz+size);
	glVertex3f(sx+size,sy+size,sz+size);
	glVertex3f(sx+size,sy+size,sz);
	// x = 0
	glVertex3f(sx,sy,sz);
	glVertex3f(sx,sy,sz+size);
	glVertex3f(sx,sy+size,sz+size);
	glVertex3f(sx,sy+size,sz);
	// x = 1
	glVertex3f(sx+size,sy,sz);
	glVertex3f(sx+size,sy,sz+size);
	glVertex3f(sx+size,sy+size,sz+size);
	glVertex3f(sx+size,sy+size,sz);

	glEnd();

}

