
#ifndef DYNAMICS_H
#define DYNAMICS_H


#define MAX_N_PATHS 40000
#define NUM_MEASURES 5
#define MAX_NUM_SIGANS 512
#define MAX_DISTINCT_PATHS 200
#define MAX_OBSERVATION 8


#include "basic.h"
#include "graph.h"
#include "histogram.h"
#include "timetext.h"
#include "drawtext.h"
#include "arcs.h"
#include "measures.h"
#include "eventshrub.h"
#include "legend.h"


struct SignatureParam {
	int k[3];
	int t[3];
	float a[3];
};

class SignatureAnomaly {
public:
	int start;
	int end;
	unsigned char flags[10];
	SignatureAnomaly() { for (int i=0;i<10;i++) flags[i] = (unsigned char)0; }
};

class Path {
public:
	int length;
	int addlater;
	int nodeArray[MAX_N_NODES];
	//int timestamp;
	//int year, month, day, hour, min;
	char attributes[5][64];
	//int univtime;

	
	int cdate; // yyyymmdd
	int ctime; // hhmmss

	int dpid; // which distinct path is this?
	float Q[NUM_MEASURES];
	float S[NUM_MEASURES];
	float T;
        char flag; //added by Ke Zhang, to indicate if the update is "U","D","F","W"
	int sig; // signature according to Ke Zhang
	int sig_inds[64];
	int num_sig_inds;
	Path() { 
		int i;
		length = 0; addlater = 0; 
		for (i=0;i<5;i++) attributes[i][0] = '\0';
		num_sig_inds = 0;
	};
	int FindNode(int n);
	int FindLink(int a, int b);
	void Print();

};


int nodesSame(Path *p1, Path *p2);

class DynamicsViz : public Visualization {
public:

	int toprightx, toprighty, toprightxsize, toprightysize;

	int npaths;
	Path *paths[MAX_N_PATHS];
	Path *other_observation_paths[MAX_OBSERVATION][MAX_N_PATHS];
	int notherpaths[MAX_OBSERVATION];
	int n_observations;

	int ndistinctpaths;
	Path distinctpaths[MAX_DISTINCT_PATHS];

	int show_timeline;
	int show_events;

	SignatureParam Sig;
	int default_k;
	int default_t;
	float default_a;
	SignatureAnomaly sigans[MAX_NUM_SIGANS];
	SignatureAnomaly siggroups[MAX_NUM_SIGANS];
	int num_sigan;
	int num_siggroups;
	float sig_thres;

	Labelled_Histogram H;
	int current_date, first_date, last_date;
	TimeText TT;
	TimeText *OTT[8];
	float pcolors[128][3];

	ArcViz AC;
	MeasuresViz MV;
	Graph G;

	EventsViz EV;
	Legend LG;

	NiceText NT;

	int aux_mode;

	DynamicsViz(int sx, int sy, int xs, int ys);
	void SetAggregates();

	void UpdateUniquePaths(int p);
	void UpdateOtherUniquePaths(int p, int o);
	void UpdateUniquePathPtr(Path *pptr);
	
	void readPathPtr(char *buf, Path **parray, int &p);
	void readPath(char *buf);
	void readOtherPath(char *buf, int o);
	void readStats(char *fname);
	void readOtherObservations(char *fname);
	void PrintPaths();
	void Draw();
	void DrawPath(Path *pptr);
	void DrawPath3D(int p);
	void DrawPaths3D();
	void Init();
	void ConstructGraph();

	void AdvanceDate();
	void BackDate();
	void SetDate(int d);
	void AddTimeItems();

	//add by Ke Zhang
	void CreateSignature(int start, int end, int limit, int tInterval, float freq);
	void CreateBatchSignatures();
	void CreateSignatureGroup(int p);

	void GenerateOnlyEvents();
	void GenerateSigAnEvents();
};

#endif

