
#ifndef ERMODEL_H
#define ERMODEL_H

#define MAX_STRLEN 64
#define MAX_ATTRIBUTES 16
#define MAX_RELATIONSHIPS_PER_ENTITY 16
#define MAX_RELATIONSHIPS 128
#define MAX_ENTITIES 128

class Relationship;

class Entity {
public:
	int id;
	char name[MAX_STRLEN];
	
	// number of attributes of each type
	int num_int;
	int num_float;
	int num_ptr;

	char intAttrNames[MAX_ATTRIBUTES][MAX_STRLEN];
	char floatAttrNames[MAX_ATTRIBUTES][MAX_STRLEN];
	char ptrAttrNames[MAX_ATTRIBUTES][MAX_STRLEN];
	
	int numFromRelationships;
	Relationship *fromRelationships[MAX_RELATIONSHIPS_PER_ENTITY];
	int numToRelationships;
	Relationship *toRelationships[MAX_RELATIONSHIPS_PER_ENTITY];
	// for display
	float x, float y, float xsize, float ysize;

	Entity();
	void addAttribute(char *str, int t);
	void addFromRelationship(Relationship *r);
	void addToRelationship(Relationship *r);
	void Draw();
	void setCoords(float a, float b);
	void Save(FILE *fptr);
	void Load(FILE *fptr);
	void Print(FILE *fptr);
};

class Relationship {
public:
	int id;
	char name[MAX_STRLEN];
	int type; // one-to-one, one-to-many, many-to-one, many-to-many
	Entity *entity0;
	Entity *entity1;
	int numAttributes;
	char attributeNames[MAX_ATTRIBUTES][MAX_STRLEN];
	int attributeTypes[MAX_ATTRIBUTES]; // unsigned int, string, float

	Relationship();
	void addAttribute(char *str, int t);
	void Draw();
	void Save(FILE *fptr);
	void Load(FILE *fptr);
	void Print(FILE *fptr);
};

class ERModel {
public:
	int numEntities;
	Entity entities[MAX_ENTITIES];
	int numRelationships;
	Relationship relationships[MAX_RELATIONSHIPS];
	int selectedEntity;

	ERModel();
	void Init();
	Entity *addEntity(char *str);
	Relationship *addRelationship(char *str, int t, Entity *e0, Entity *e1);
	void Draw();
	void SelectEntity(float x, float y);
	void MoveEntity(float x, float y);
	void Save();
	void Load();
	void Print();
	void Extend();

};


// relationships

// Owns: One-to-many, Operator, AS
// Owns: One-to-many, Operator, IPPrefix
// Owns: One-to-many, Operator, Host
// FromAS: Many-to-many, OASC, AS
// ToAS: Many-to-many, OASC, AS
// Involves: Many-to-one, BGPUpdateMessage, IPPrefix
// Involves: Many-to-one, BGPUpdateMessage, ASPath
// PathContains: Many-to-many (attr: order_number), ASPath, AS



#endif

