
#ifndef EVENTSHRUB_H
#define EVENTSHRUB_H

#include "basic.h"

#define MAX_EVENTS 256

class EventShrub {

public:
	// ****** need to set for every event*******************
	int Flag;
	float r; // radius of the circle
	// all coordinates are in screen space
	// ****** for horizontal *******************************
	float x, y; // center of the circle
	float x1, x2; // x coordinates of the base
	// ****** for vertical *********************************
	float y1, y2; // y coordinates of the vertical base
	float yv; // center of the vertical circle
	int show_begin, show_end; // whether begin and end vertical coords are valid
	// ****** set by constructor ***************************
	int resolution;
	// ****** auxilliary info, not necessary for display ***
	int sid, eid; // start and end id
	int n; // quantity to map to size
	// ****** set by globals *******************************
	static float colors[6][3];
	static float ymin; // horizontal base
	static float xv_min; // vertical base
	static float xv; // vertical center

	EventShrub();
	void DrawCircle(int flag); // 0 horizontal, 1 vertical
	void Draw();
	void DrawBase();
	void DrawVert();
	void DrawVertBase();

};

class EventsViz : public Visualization {
public:
	// dimensions of the vertical display
	int vstartx, vstarty, vxsize, vysize;
	int num_events; // user has to set this
	EventShrub events[MAX_EVENTS]; // user has to input these
	// dimensions of the horizontal display
	EventsViz(int sx, int sy, int xs, int ys);
	// draw the horizontal shrubs
	void Draw();
	// draw the vertical shrubs
	void DrawVert();
	// arrange the heights of the shrubs to avoid occlusion
	void SettleHeights();
	// dimensions of the vertical display
	void SetVerticalDimensions(int sx, int sy, int xs, int ys);
};


#endif

