
#ifndef GRAPH_H
#define GRAPH_H

#define MAX_N_NODES 512
#define MAX_N_LINKS 64
#define MAX_N_NODES_IN_GRAPH 65536

#include "basic.h"
#include "drawtext.h"



class Node {

public:
	// ******** FOR GRAPHICS **********************************************
	float xcoord; // x coordinate, not normalized to 0-1
	int level; // y coordinate, not normalized to 0-1
	// ******** FOR GRAPHICS TEXT *****************************************
	int AS; // the AS number this node represents. for text label
	static NiceText NT; // to draw nice fonts
	// ******** HELPER VARIABLES FOR TO SET NETWORK Y-COORDS **************
	int maxlevel;
	int countedlevel;
	// ******** TOPOLOGY **************************************************
	int nlinks;
	Node *links[MAX_N_LINKS];
	Node *templink;
	// ******** FOR DEPTH-FIRST SEARCH ************************************
	int dfsflag;
	// ******** FOR ARCS **************************************************
	int linearX; // not normalized to 0-1. between 0 and Graph::maxlinearx



	// ******** CONSTRUCTOR ***********************************************
	Node(int id) : linearX(-1) , countedlevel(0) { 
		dfsflag = 0; xcoord = -1; level = -1; nlinks = 0; AS = id; templink = NULL; };
	// ******** TOPOLOGY **************************************************
	void AddLink(Node *n); // add to links. will check for duplicates
	void AddTempLink(Node *n); // set templink
	void RemoveTempLink(); // set templink to NULL
	void PermanizeLink(); // add templink to links
	// ******** SET COORDINATES FOR NETWORK *******************************
	int SetLevel(int n);
	int NumInLevel(int n);
	// ******** SET COORDINATES FOR ARCS **********************************
	void SetLinearX(int *next);
	// ******** GRAPHICS **************************************************
	void Draw(); // draw itself and recursively draw all links. need to call InitDFS first
	// ******** AUXILLIARY TOPOLOGY ***************************************
	int DetectCycle(); // return 1 if cycle detected. need to call InitDFS first
	void InitDFS(); // needs to be called before Draw() and DetectCycle()
	void Print();

};

class Graph : public Visualization {

public:
	// ************ TOPOLOGY ************************************
	int selectedPoint; // selected Point. index into nodes
	int root; // index into nodes
	Node *nodes[MAX_N_NODES_IN_GRAPH]; // all the nodes in the graph
	// ************ FOR ARCS ************************************
	int maxlinearx;
	// ************ RANGE OF NODE COORDINATES *******************
	int x,y; // max network node coordinates, used to set viewport


	// ************ TOPOLOGY ************************************
	Graph(int sx, int sy, int xs, int ys); // window dimensions
	int DetectCycle(); // return 1 if graph contains cycle
	void Init(); // delete all nodes. set selectedPoint to -1
	// ************ GRAPHICS ************************************
	void Draw();
	void DrawPath(int *nodenums, int len, int wid, float *colors, float depth);
	// ************ MOUSE INTERACTION ***************************
	// select point based on mouse coordinates. sets selectedPoint
	void SelectPoint(int i, int j);
	// moves selectedPoint to the mouse coordinates
	void MovePoint(int i, int j);

};


#endif

