
#ifndef HISTOGRAM_H
#define HISTOGRAM_H

#include "basic.h"
#include "drawtext.h"

#define MAX_RES 4096
#define MAX_LAYERS 16

class Histogram : public Visualization {

public:

	int resolution; // number of entries
	int numlayers;
	int maxheight; // max data entry
	int data[MAX_LAYERS][MAX_RES];
	float depths[MAX_LAYERS]; // depth of each layer
	float colors[MAX_LAYERS][4];

	Histogram();
	Histogram(int sx, int sy, int xs, int ys, int r);
	int AddLayer(float d, float *c); // depth, color
	void AddData(int l, int *d); // layer, data
	void Draw();
	void SetNumLayers(int i);
	void SetResolution(int i);

};


class Labelled_Histogram : public Visualization {

public:

	Histogram H;
	NiceText NT;
	int labels[MAX_RES];
	int current_ind;

	Labelled_Histogram();
	Labelled_Histogram(int sx, int sy, int xs, int ys, int r);

	int AddLayer(float d, float *c); // depth, color
	void AddData(int l, int *d); // layer, data
	void Draw();
	void ScreenToData(int sx, int &d);
	void DataToScreen(int d, int &sx);
	void AddLabels(int *d);
	void SetNumLayers(int i);
	void SetResolution(int i);
	void Advance();
	void Back();
	void SetInd(int ind);

};




#endif

