
#include "legend.h"


Legend::Legend() { title[0] = title2[0] = '\0'; }

Legend::Legend(int sx, int sy, int xs, int ys): Visualization(sx,sy,xs,ys), numitems(0) 
{ title[0] = title2[0] = '\0'; }

void Legend::Draw() {
	int i;
	float each;


	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(startx,startx+xsize,starty,starty+ysize);
			// left, right, bottom, top
	glViewport(startx, starty, xsize, ysize);
			// startx, starty, xsize, ysize
			// coordinates begin from lower left corner of window
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	each = (float)ysize/(float)(numitems+2);

	glColor3f(0.1,0.1,0.1);
	glRasterPos3f(startx+1.5*each,starty+ysize-0.8*each,0.0);
	NT.font.Render(title);
	glRasterPos3f(startx+1.5*each,starty+ysize-1.8*each,0.0);
	NT.font.Render(title2);

	for (i=0;i<numitems;i++) {
		glColor4f(colors[i*4],colors[i*4+1],colors[i*4+2],colors[i*4+3]);
		glBegin(GL_QUADS);
		glVertex3f(startx,starty+ysize-(0.1+(float)(i+2))*each,0.0);
		glVertex3f(startx+0.8*each,starty+ysize-(0.1+(float)(i+2))*each,0.0);
		glVertex3f(startx+0.8*each,starty+ysize-(0.9+(float)(i+2))*each,0.0);
		glVertex3f(startx,starty+ysize-(0.9+(float)(i+2))*each,0.0);
		glEnd();
		glRasterPos3f(startx+1.5*each,starty+ysize-(0.8+(float)(i+2))*each,0.0);
		NT.font.Render(names[i]);
	}
}

