
#include <stdio.h>
#include <math.h>
#include "glut.h"
#include "measures.h"


MeasuresViz::MeasuresViz(int sx, int sy, int xs, int ys) : Visualization(sx,sy,xs,ys) {
	for (int i=0;i<MAX_MEASURES;i++) measure_muls[i] = 3;
}

void MeasuresViz::Draw() {

	int i, j, p;
	float eachx;
	char buf[16];

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(startx, startx+xsize ,starty-40,starty+ysize);
			// left, right, bottom, top
	glViewport(startx, starty-40, xsize, ysize+40);
			// startx, starty, xsize, ysize
			// coordinates begin from lower left corner of window
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	
	eachx = xsize / (float)num_measures;
	for (i=0;i<num_measures;i++) {
		// label the measures
		glColor4f(0.1,0.1,0.1,1.0);
		glRasterPos3f(startx + eachx*(float)i,starty-40.0,0.0);
		NT.font.Render(measure_names[i]);
		// label the values
		for (j=0;j<num_vals[i];j++) {
			glColor4f(val_colors[i][j][0],val_colors[i][j][1],val_colors[i][j][2],val_colors[i][j][3]);
			glRasterPos3f(startx + eachx*((float)j/(float)num_vals[i]+(float)i),starty-30.0,0.0);
			NT.font.Render(val_names[i][j]);
		}
		// draw background
		glColor4f(0.7,0.7,0.7,1.0);
		glBegin(GL_QUADS);
		glVertex3f(startx + eachx*(float)i, starty, -0.2);
		glVertex3f(startx + eachx*((float)i+0.8), starty, -0.2);
		glVertex3f(startx + eachx*((float)i+0.8), starty + ysize, -0.2);
		glVertex3f(startx + eachx*(float)i, starty + ysize, -0.2);
		glEnd();
		glLineWidth(1);
		glColor4f(0.1,0.1,0.1,1.0);
		glBegin(GL_LINES); // left vertical bar
		glVertex3f(startx + eachx*(float)i, starty + ysize, -0.1);
		glVertex3f(startx + eachx*(float)i, starty - 10.0, -0.1);
		glEnd();
		glBegin(GL_LINES); // right vertical bar
		glVertex3f(startx + eachx*((float)i + 0.8), starty + ysize, -0.1);
		glVertex3f(startx + eachx*((float)i + 0.8), starty - 10.0, -0.1);
		glEnd();
		// draw the multiplier bars
		glColor4f(0.1,0.1,0.1,1.0);
		glLineWidth(1);
		glBegin(GL_LINES); // horizontal line
		glVertex3f(startx + eachx*(float)i, starty - 5.0, -0.1);
		glVertex3f(startx + eachx*(0.8+(float)i), starty - 5.0, -0.1);
		glEnd();
		glLineWidth(3);
		glBegin(GL_LINES); // vertical bar according to the multiplier
		glVertex3f(startx + eachx*((float)i + (float)measure_muls[i]/(float)MAX_MEASUREMUL * 0.8), starty, -0.1);
		glVertex3f(startx + eachx*((float)i + (float)measure_muls[i]/(float)MAX_MEASUREMUL * 0.8), starty - 10.0, -0.1);
		glEnd();
		// write the upper value
		sprintf(buf,"%.1f", 0.8*eachx/(float)pow(2,measure_muls[i]));
		glRasterPos3f(startx + eachx*((float)i + 0.8), starty - 20.0, -0.1);
		NT.font.Render(buf);
		// draw the graph
		for (j=0;j<num_vals[i];j++) {
			glColor4f(val_colors[i][j][0],val_colors[i][j][1],val_colors[i][j][2],val_colors[i][j][3]);
			glLineWidth(1);
			glBegin(GL_LINE_STRIP);
			for (p=0;p<num_paths;p++) {
				glVertex3f(startx + eachx*(float)i + measures[p][i][j] * (float)pow(2,measure_muls[i]), pathy[p], 0.0);
			}
			glEnd();
		}		
	}
}

void MeasuresViz::AddPath() {
	if (num_paths < MAX_MEASURESPATHS) num_paths++;
}


int MeasuresViz::ClickLabelDetected(int x, int y) {

	if ((y<starty)&&(y>=starty-40) &&
		(x>=startx)&&(x<=startx+xsize)) {
		return 1;
	} else {
		return 0;
	}

}


void MeasuresViz::SelectMeasureMul(int x) {

	selected_measure_mul = (x - startx) * num_measures / xsize;
	printf("selected measure mul %d\n", selected_measure_mul);

}


void MeasuresViz::SetMeasureMul(int x) {

	float eachx;
	float fx;
	int n;

	eachx = xsize/(float)num_measures;
	fx = (float)(x - startx);
	
	if (fx < eachx * (float)selected_measure_mul) fx = eachx * (float)selected_measure_mul;
	if (fx > eachx * ((float)selected_measure_mul+0.8)) fx = eachx * ((float)selected_measure_mul+0.8);

	n = (int)((fx - eachx * (float)selected_measure_mul) / (0.8 * eachx) * (float)MAX_MEASUREMUL);
	measure_muls[selected_measure_mul] = n;

}



