
#ifndef MEASURES_H
#define MEASURES_H

#include "basic.h"
#include "drawtext.h"

#define MAX_MEASURESPATHS 128
#define MAX_MEASURES 8
#define MAX_VALS 4
#define MAX_MEASURE_STRLEN 32
#define MAX_MEASUREMUL 8

class MeasuresViz : public Visualization {

public:

	int num_measures;
	int num_vals[MAX_MEASURES]; // each measure has a Q and S value
	int num_paths;
	float pathy[MAX_MEASURESPATHS]; // range from starty to starty + ysize
	float measures[MAX_MEASURESPATHS][MAX_MEASURES][MAX_VALS];
	char val_names[MAX_MEASURES][MAX_VALS][MAX_MEASURE_STRLEN];
	char measure_names[MAX_MEASURES][MAX_MEASURE_STRLEN];
	float val_colors[MAX_MEASURES][MAX_VALS][4];
	int measure_muls[MAX_MEASURES]; // multiplier
	int selected_measure_mul; // which measure to edit multiplier

	NiceText NT;

	MeasuresViz(int sx, int sy, int xs, int ys);
	void Draw();
	void AddPath();
	int ClickLabelDetected(int x, int y);
	void SelectMeasureMul(int x);
	void SetMeasureMul(int x);

};



#endif
