
#ifndef OASC_H
#define OASC_H

#define MAX_AS 8
#define MAX_OASC 50000
#define MAX_UPDATE_OASC 300000
#define MAX_DAYS 2048
#define NUM_OASC_TYPES 8
#define MAX_HIGHLIGHT 32
#define MAX_COUNTRIES 300

// for enum CHANGE_TYPE
// for nextday
#include "structures.h"
#include "basic.h"
#include "quadtree.h"
#include "histogram.h"
#include "drawtext.h"
#include "legend.h"
#include "timetext.h"
#include "scatterplot.h"

class IPPrefix {

public:
  unsigned char IPAddress[4];
  int Mask;
  char text[32]; // "d.d.d.d/d"

  IPPrefix();
  unsigned int IPAddressToInt();
  void IntToIPAddress(unsigned int i);
  void GenerateText();
  void Print();
  void ReMask(); // mask the IP address according to Mask

};


class OASC {

public:

  CHANGE_TYPE type;
  int numfrom;
  int numto;
  int fromAS[MAX_AS];
  int toAS[MAX_AS];
  int cdate; // yyyymmdd
  int ctime; // hhmmss
  IPPrefix P;

  static int maxAS;
  static int minAS;

  static void AssignText(int t, char *t_ptr);

  OASC() : numfrom(0), numto(0) { };

  OASC &operator=(const OASC &rhs);
  
  void Print();
  int isPrivate();
  void AddFromAS(int a);
  void AddToAS(int a);

};

class Countries {
public:
	//char names[MAX_COUNTRIES][8];
	//int numAS[MAX_COUNTRIES];
	//int AS[MAX_COUNTRIES][100000];
	//int numcountries;
	int ASList[30000];
	char buf[100000];
	int numAS;
	char cname[32];
	Countries();
	void ReadCountry(char *fname);
	//void AddEntry(char *n, int a);
	//void ReadFromFile(char *fname);

};


class OASCViz : public Visualization {

public:

	int numdays;
	int numdaily, numdetail;
	OASC detailOASC[MAX_UPDATE_OASC];
	OASC dailyOASC[MAX_OASC];
	int dates[MAX_DAYS];
	int daily_counts[MAX_DAYS][NUM_OASC_TYPES];
	int first_date, last_date;
	int current_date;
	int detail_start, detail_end;
	int show_type[8];
	int show_lines;

	int highlight_AS_click_mode;
	int highlight_AS_list_mode;
	int highlight_AS_country_mode;
	int highlight_IP_mode;
	int highlighted_AS[MAX_HIGHLIGHT];
	int num_highlighted_AS;
	int highlighted_AS_clicked;
	int highlighted_AS_range;
	int highlighted_IP[MAX_HIGHLIGHT];
	int ignored_AS[MAX_HIGHLIGHT];
	int ignored_IP[MAX_HIGHLIGHT];

	int highlight_IP_click_mode;
	OASC highlighted_IP_prefix;

	int per; // 0: per day, 1: per update

	int perupdate_time, perupdate_window, perupdate_incr;
	int perupdate_incr_type; // 0: entry, 1:time
	int current_entry; // for per update

	int preprocess_begin, preprocess_end;

	int qtoffx, qtoffy;
	QuadTree Q;
	SurroundingLines S;
	Labelled_Histogram H;
	NiceText NT;
	Legend LG; // for per day counts of different types
	Legend LG2; // for per update counts of different types
	TimeText TT;
	Countries CN;
	Scatterplot3D SP;

	int dimension_flag; // show 2D or 3D display

	void Init();
	void ReadDetail(int stime, int etime);
	void ReadDaily(int d);
	int ReadOneOASC(FILE *fptr);
	void ReadDetail(int d);
	int ReadOneDetail(FILE *fptr);
	// generate the count for each type on each date, output to file
	void PreProcess(char *fname);
	// read the file containing the count
	void ReadCount(char *fname);
	void Draw();
	void Draw3D();
	OASCViz();
	OASCViz(int sx, int sy, int xs, int ys);
	void AssignColor(int t, float *f_ptr);
	void AdvanceDate();
	void BackDate();
	void SetDate(int d);
	void AddTimeItem(OASC &OO);
	void DisplayOASC(OASC &OO, int high);
	void DisplayOASC3D(OASC &OO, int high);
	void DisplayOASCOutline(OASC &OO);
	int FilterOASC(OASC &OO);
	void AddHighlightAS(int a);
	void RemoveHighlightAS(int a);
	int Within(OASC &address, OASC &prefix);
	int DecideHighlight(OASC &OO);

};

#endif

