
#ifndef QUADTREE_H
#define QUADTREE_H

#include "basic.h"
#include "drawtext.h"

class QuadTree : public Visualization{
public:
	QuadTree();
	// startx, starty, size
	QuadTree(int sx, int sy, int s);
	// set up the viewing coordinates and calls DrawSquare
	void Draw();
	// draw a texture-mapped 1x1 square on the X-Y plane
	void DrawSquare();
	// draw a texture-mapped 1x1 square on the X-Z plane
	void DrawSquareXZ();
	// makes the texture map. has to be called first, before Draw()
	void MakeTextureMap();
	// screenx and screeny to integer value
	void ScreenToData(int sx, int sy, unsigned int &di, int &mi);
	// integer (value, mask) to screenx and screeny and size
	void DataToScreen(unsigned int di, int mi, int &sx, int &sy, int &xs, int &ys);
	// integer (value, mask) to screenx and screeny normalized 0-1
	void DataToScreenNormalized(unsigned int di, int mi, float &sx, float &sy);

};

class SurroundingLines : public Visualization {
public:
	// num pixels the SurroundingLines lie outside the Quadtree
	int margin;
	// min and max data values to be mapped to line pixels
	int min, max;
	// data values mapped to the beginning of lines 1, 2 and 3
	int p1, p2, p3;
	NiceText NT;
	SurroundingLines();
	// screen startx, starty, size (num pixels), margin (num pixels),
	// min and max data val
	// note that sx, sy and s are the dimensions of the quadtree square.
	// the surrounding lines lie outside the square, according to 
	// SurroundingLines::margin
	SurroundingLines(int sx, int sy, int s, int mar, int mn, int mx);
	void Draw();
	int ClickDetected(int x, int y);
	// integer value to screenx and screeny
	void DataToScreen(int di, int &x, int &y);
	// screenx and screeny to integer
	void ScreenToData(int sx, int sy, int &di);

};

#endif

