
#ifndef SCATTERPLOT_H
#define SCATTERPLOT_H

#define MAX_SCATTERPLOT_POINTS 4096
#define SCATTERPLOT_TEXRES 64

#include "glut.h"
#include "basic.h"

class Scatterplot3D : public Visualization {

public:

	// user need to initialize this to zero before adding points
	int num_points;
	// points should be 0-1 in the x, y and z dimensions
	float point_coords[MAX_SCATTERPLOT_POINTS][3];
	float point_colors[MAX_SCATTERPLOT_POINTS][3];
	float point_sizes[MAX_SCATTERPLOT_POINTS];
	// rotation angles
	float x_rot, y_rot;

	
	GLubyte TextureProjXY[SCATTERPLOT_TEXRES][SCATTERPLOT_TEXRES][4];
	GLuint texNameProjXY;
	GLubyte TextureProjXZ[SCATTERPLOT_TEXRES][SCATTERPLOT_TEXRES][4];
	GLuint texNameProjXZ;
	GLubyte TextureProjYZ[SCATTERPLOT_TEXRES][SCATTERPLOT_TEXRES][4];
	GLuint texNameProjYZ;

	Scatterplot3D();
	Scatterplot3D(int sx, int sy, int xs, int ys);
	// set up screen projection, rotation
	// then draws XY and YZ projected texture planes, and plot
	void Draw();
	// draws all the points
	void DrawPlot();
	// add a point
	void AddPoint(float *coords, float *color, float size);
	// make XY, YZ and XZ texture planes projection of points
	// needs to be called after all points added, and before Draw()
	void MakeTexMaps();

};

#endif