
#include "spline.h"

int PascalTri[200][200];

float power(float base, int deg) {
  if (deg==0) {
    return 1.0;
  } else if (deg==1) {
    return base;
  } else {
    return (base*power(base,deg-1));
  }
}


float Spline::Berstein(int n, int i, float t) {
  return(((float)PascalTri[n][i])*power(1.0-t,n-i)*power(t,i));
}

void Spline::Init_Pascal(int nControls) {
  int i, n;
  for (n=0; n<nControls; n++) {
    for (i=0; i<=n; i++) {
      if ((i==0) || (i==n)) {
	PascalTri[n][i]=1;
      } else {
	PascalTri[n][i] = PascalTri[n-1][i-1]+PascalTri[n-1][i];
      }
    }
  } 
}

void Spline::Bezier(int nControls, SplinePoint *ccurve, double t, SplinePoint &p) {
  int i;
  p.x = p.y = p.z = 0.0;
  for (i=0; i<nControls; i++) {
    p.x += ccurve[i].x*Berstein(nControls-1,i,t);
    p.y += ccurve[i].y*Berstein(nControls-1,i,t);
    p.z += ccurve[i].z*Berstein(nControls-1,i,t);
  }
}

