
#include "glut.h"
#include "glui.h"

#include "structures.h"



// yyyymmdd
int nextday(int d) {

	int ndays;

	if ((d%10000) == 1231) { // if end of the year
		d -= 1230;
		d += 10000;
	} else {
		if (((d/100)%100) == 2) { // if february
			if (((((d/10000)%4) == 0) &&
				(((d/10000)%100) != 0)) ||
				(((d/10000)%400) == 0)) { // if leap year
				ndays = 29;
			} else { // not leap year
				ndays = 28;
			}
		} else if ((((d/100)%100) == 9) || (((d/100)%100) == 4) || 
					(((d/100)%100) == 6) || (((d/100)%100) == 11)) { // 30-day month
			ndays = 30;
		} else { // 31-day month
			ndays = 31;
		}

		if ((d%100)==ndays) {
			d-=(ndays-1);
			d+=100;
		} else {
			d++;
		}
	}

	return d;
}


// yyyymmdd
int prevday(int d) {

	int ndays;

	if ((d%10000) == 0101) { // if beginning of the year
		d -= 10101;
		d += 1231;
	} else if ((d%100)==1) { // if beginning of the month
		if (((d/100)%100)-1 == 2) { // if prev month is february
			if (((((d/10000)%4) == 0) &&
				(((d/10000)%100) != 0)) ||
				(((d/10000)%400) == 0)) { // if leap year
				ndays = 29;
			} else { // not leap year
				ndays = 28;
			}
		} else if ((((d/100)%100)-1 == 9) || (((d/100)%100)-1 == 4) || 
					(((d/100)%100)-1 == 6) || (((d/100)%100)-1 == 11)) { // if prev-month has 30 days
			ndays = 30;
		} else { // 31-day month
			ndays = 31;
		}
		d -= 101;
		d += ndays;
	} else {
		d--;
	}

	return d;
}

// from ddmmss to decimal int
int timetoint(int t) {
	int h, m, s;
	h = t / 10000;
	m = (t / 100) % 100;
	s = t % 100;

	return (s + 60 * (m + 60*h));

}

