
#ifndef TIMETEXT_H
#define TIMETEXT_H

#define MAX_TIME_ITEMS 4096
#define MAX_TIME_STR 256

#include "basic.h"
#include "drawtext.h"

class TimeText : public Visualization {
public:
	// need to be set by user
	int numitems;
	// automatically set by constructor
	int maxitems;
	// need to be set by user
	int mintime, maxtime;
	// the time of each item
	int times[MAX_TIME_ITEMS];
	// the color of each item
	float colors[MAX_TIME_ITEMS][4];
	// the text of each item
	char texts[MAX_TIME_ITEMS][MAX_TIME_STR];
	// the y coordinate of each item (sx to sx+xs)
	float ycoords[MAX_TIME_ITEMS];
	NiceText NT;

	TimeText();
	// dimensions
	TimeText(int sx, int sy, int xs, int ys);
	// draw
	void Draw();
	// automatically set y coords
	void Arrange(); 


};

#endif

