
#ifndef COMPARISON_H
#define COMPARISON_H

#define MAX_NFILES 32


void CrossProduct(float *a, float *b, float *r) {
	r[0] = a[1] * b[2] - b[1] * a[2];
	r[1] = a[2] * b[0] - b[2] * a[0];
	r[2] = a[0] * b[1] - b[0] * a[1];
}

class Comparison {

public:

	int beginunivtime, endunivtime;
	float startx, starty, xsize, ysize;
	float rdstartx, rdstarty, rdxsize, rdysize;
	float mstartx, mstarty, mxsize, mysize;

	Graph AllTopology;
	Graph *graphs[MAX_NFILES];
	char filenames[MAX_NFILES][32];

	int nfiles;

	int maxnumanns;

	Comparison() : nfiles(0) , maxnumanns(0) { };

	void Init(float sx, float sy, float xs, float ys) {
		startx = sx; starty = sy; xsize = xs; ysize = ys;
	};
	
	void InitRD(float sx, float sy, float xs, float ys) {
		rdstartx = sx; rdstarty = sy; rdxsize = xs; rdysize = ys;
	};

	void InitM(float sx, float sy, float xs, float ys) {
		mstartx = sx; mstarty = sy; mxsize = xs; mysize = ys;
	};

	void ReadMaster(char *fname) {

		FILE *fptr;
		char buf[64];
		int i;
		char fullpath[64];

		fptr = fopen(fname,"rt");

		fgets(buf,64,fptr);
		sscanf(buf,"%d", &nfiles);
		for (i=0;i<nfiles;i++) {
			fgets(buf,64,fptr);
			sscanf(buf,"%s", filenames[i]);
			graphs[i] = new Graph();
			strcpy(fullpath,"../data/");
			strcat(fullpath, filenames[i]);
			graphs[i]->readMRT(fullpath);
			if (graphs[i]->maxnumanns > maxnumanns) maxnumanns = graphs[i]->maxnumanns;
			AllTopology.AddGraph(graphs[i]);
		}

		fclose(fptr);

		AllTopology.ConstructGraph();


	};

	void highlightPath(int x, int y) {

		int temp, converted;
		float temp2;
		float eachx;
		int i;

		temp = (int)rdstarty + (int)rdysize - y;
		temp2 = 1.25 + (float)temp/8.0 - 5.0;
		converted = (int)(temp2/1.25);

		eachx = rdxsize/(float)nfiles;
		i = x/(int)eachx;

		if ((i>=0)&&(i<nfiles)) {
			graphs[i]->highlightedpath = converted;
			graphs[i]->shadowpath = graphs[i]->highlightedpath + graphs[i]->firstwritepath;
		}

	};

	void DrawAgg() {

		int i;
		float eachy;
	
		eachy = 0.5 * ysize / (float)nfiles;

		for (i=0; i<nfiles; i++) {

			AV.DrawOverviewBounds();

			if (comparison_anns) {
				// ************* Number of announcements ************************	
				glMatrixMode(GL_PROJECTION);
				glLoadIdentity();
				gluOrtho2D(0,512,0,maxnumanns);
						// left, right, bottom, top
				glViewport(startx, starty + eachy * (float)i, xsize, eachy);
						// startx, starty, xsize, ysize
						// coordinates begin from lower left corner of window
			    glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();
			    glDisable(GL_TEXTURE_2D);
				glDisable(GL_LIGHTING);		
				glPushMatrix();
				graphs[i]->DrawTimeLine(-1);
				glColor3f(0.5,0.5,0.5);
				glBegin(GL_LINES);
				glVertex3f(0.0,0.0,0.0);
				glVertex3f(512.0,0.0,0.0);
				glEnd();
			    glPopMatrix();
			}

			if (comparison_unique) {
				// ************* Show each distinct path as a horizontal line ***
				glMatrixMode(GL_PROJECTION);
				glLoadIdentity();
				gluOrtho2D(0,512,-1,2*(graphs[i]->ndistinctpaths+1));
						// left, right, bottom, top
				glViewport(startx, starty + eachy * (float)i, xsize, eachy);
						// startx, starty, xsize, ysize
						// coordinates begin from lower left corner of window
				glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();
				glDisable(GL_TEXTURE_2D);
				glDisable(GL_LIGHTING);
				glPushMatrix();
				graphs[i]->DrawTimeDistinctPaths(-1);
				glPopMatrix();

				AV.DrawDetailBounds();

				// ************* Draw Detail Window *****************************
				glMatrixMode(GL_PROJECTION);
				glLoadIdentity();
				gluOrtho2D(0,512,-1,2*(graphs[i]->ndistinctpaths+1));
						// left, right, bottom, top
				glViewport(startx, starty + 0.5*ysize + eachy * (float)i, xsize, eachy);
						// startx, starty, xsize, ysize
						// coordinates begin from lower left corner of window
				glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();
			    glDisable(GL_TEXTURE_2D);
				glDisable(GL_LIGHTING);		
				glPushMatrix();
				graphs[i]->DrawNewWinDistinctPaths(AV.detailstart, AV.detailend);
				glPopMatrix();
			}


		}

	};

	void DrawMap() {

		int i;

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(-0.2*AllTopology.x,1.2*AllTopology.x,-0.2*AllTopology.y,1.2*AllTopology.y);
				// left, right, bottom, top
		glViewport(mstartx, mstarty, mxsize, mysize);
				// startx, starty, xsize, ysize
				// coordinates begin from lower left corner of window		

	    glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();	

	    glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);

		glPushMatrix();
		AllTopology.Draw();
		for (i=0;i<nfiles;i++) {
			AllTopology.DrawOtherPathsInSlots(AV.detailstart,AV.detailend,graphs[i],i);
		}
		glPopMatrix();

	};

	void DrawRawData() {

		int i;

		float from[3];
		float to[3];
		float xvec[3];
		float diff[3];
		float up[3];

		float eachx;

		eachx = rdxsize/(float)nfiles;

		for (i=0;i<nfiles;i++) {

			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			if ((com_rd_mode==0) || (com_rd_mode==1)) {
				gluOrtho2D(0,70,50-(int)rdysize/8,50);
						// left, right, bottom, top
				glViewport(rdstartx + eachx * (float)i, rdstarty, eachx, rdysize);
						// startx, starty, xsize, ysize
						// coordinates begin from lower left corner of window
			} else {
				glOrtho(-30.0,30.0,-30.0,30.0,1.5,200.0);
						// left, right, bottom, top, near, far
				glViewport(rdstartx + eachx * (float)i, rdstarty, eachx, rdysize);
						// startx, starty, xsize, ysize
						// coordinates begin from lower left corner of window
			}

		    glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();		

		    glDisable(GL_TEXTURE_2D);
			glDisable(GL_LIGHTING);	

			from[0] = 0.0;
			from[1] = 0.0;
			from[2] = 50.0;
			to[0] = 25.0;
			to[1] = 15.0;
			to[2] = 0.0;
			diff[0] = to[0] - from[0];
			diff[1] = to[1] - from[1];
			diff[2] = to[2] - from[2];
			xvec[0] = 1.0;
			xvec[1] = 0.0;
			xvec[2] = 0.0;
			CrossProduct(xvec,diff,up);
			

			if (com_rd_mode==2) gluLookAt(from[0],from[1],from[2],to[0],to[1],to[2],
											up[0],up[1],up[2]);


			glPushMatrix();	

			if (RD.mode==0) {
				graphs[i]->WritePaths(RD.detailstart,RD.raw_data_time_window);
			} else {
				graphs[i]->WriteDetailPaths(RD.detailstarttime,RD.detailwindow);
			}


			glPopMatrix();
		}
	};



};



#endif

