
#ifndef RAWDATAVIZ_H
#define RAWDATAVIZ_H

class RawDataViz {

public:

	float startx, starty, xsize, ysize;
	int detailstart; // 0-511
	int raw_data_time_window;
	int mode, detailstarttime, detailwindow;

	RawDataViz() : raw_data_time_window(100) , mode(0) { };

	void Init(float sx, float sy, float xs, float ys) {
		startx = sx; starty = sy; xsize = xs; ysize = ys;
		printf("ysize is %f\n", ysize);
	};

	void moveBound(int x) {
		detailstart = x;
	};


	int highlightPath(int y) {
		int temp, converted;
		float temp2;
		temp = (int)starty + (int)ysize - y;
		printf("path clicked %d\n", temp);
		temp2 = 1.25 + (float)temp/8.0 - 5.0;
		printf("temp2 is %f\n", temp2);
		converted = (int)(temp2/1.25);
		printf("converted %d\n", converted);
		return converted;

	};

	void Draw() { 

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(0,200,50-(int)ysize/8,50);
				// left, right, bottom, top
		glViewport(startx, starty, xsize, ysize);
				// startx, starty, xsize, ysize
				// coordinates begin from lower left corner of window		

	    glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();	

	    glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);

		glPushMatrix();

		if (mode==0) {
			G1.WritePaths(detailstart,raw_data_time_window);
		} else {
			G1.WriteDetailPaths(detailstarttime,detailwindow);
		}

		glPopMatrix();
	
	};

	float FindStartMeasures() {
		return startx + xsize * G1.measures_startx/200.0;
	};

	void SetMeasure(float x) {
		int m;
		x = x - startx;
		x = 200.0 * x/xsize;
		x = x - G1.measures_startx;
		m = (int)(x/G1.measures_eachx);
		if ((m>=0)&&(m<NUM_MEASURES)) {
			G1.measure_mul[m] = x - (float)m * G1.measures_eachx;
		}

	};



};

#endif RAWDATAVIZ_H

