
#ifndef STRUCTURES_H
#define STRUCTURES_H

#include <stdio.h>
#include <stdlib.h>

// a 128 X 128 matrix

// 128 X 128 = 16384 entries, corresponds to a mask of 14

enum CHANGE_TYPE { BSS , HSS , CMS , OS , CSM , OM , CMM , CSS };

float datetofloat(int d, int d2);
int date_off(int d1,int off);
int datediff(int d1, int d2);


class DisplayMatrix {
 public:

  int n[512][512];

  DisplayMatrix() {
	Initialize();
  };

  void Initialize() {
    int i,j;
    for (i=0;i<512;i++) {
      for (j=0;j<512;j++) {
		n[i][j] = 0;
      }
    }
  };

  void Print() {
    int i,j;
    for (i=0;i<512;i++) {
      for (j=0;j<512;j++) {
		printf ("%d ", n[i][j]);
      }
      printf("\n");
    }
  };

};

class ASChange {

public:

  CHANGE_TYPE type;
  int from;
  int to;
  unsigned char IPAddress[4];
  int Mask;
  int AS;

  int cdate;

  static int maxAS;
  static int minAS;

  ASChange() {};

  ASChange &operator=(const ASChange &rhs);
  
  int ReadInput(FILE *fptr);
  void Print();
  void PutInMatrix(DisplayMatrix *m);
  void MatrixPos(int &x, int &y);
  void DetailMatrixPos(int bit, int &xlower, int &xupper, int &ylower, int &yupper, int xdim, int ydim);
  void DrawInDetailMatrix(int bit, int xdim, int ydim);

};

class ASList {

public:

	int NumIPChange[65536];
	int Compacted[65536];
	int Indices[65536];
	int NumDistinctAS;
	
	ASList() { Initialize(); };

	void Initialize() { 
		for (int i = 0; i<65536; i++) {
			NumIPChange[i] = 0; 
			Indices[i] = 0;
		}
	};

	void SetIndices() {
		int i;
		NumDistinctAS=0;
		for (i=0;i<65536;i++) {
			if (NumIPChange[i]>0) {
				Compacted[NumDistinctAS] = i;
				NumDistinctAS++;
			}
		}
		for (i=0;i<NumDistinctAS;i++) Indices[Compacted[i]] = i;
	};

	void OutputToFile(char *fname) {
		FILE *fptr;
		fptr = fopen(fname,"wb");
		fwrite(&NumDistinctAS,sizeof(int),1,fptr);
		fwrite(Indices,sizeof(int),65536,fptr);
		fclose(fptr);
	};

	void ReadFromFile(char *fname) {
		FILE *fptr;
		fptr = fopen(fname,"rb");
		fread(&NumDistinctAS,sizeof(int),1,fptr);
		fread(Indices,sizeof(int),65536,fptr);
		fclose(fptr);
	}; 

};


class ASMatrix {

 public:

  ASChange *n[512][512];

  ASMatrix() {
	Initialize();
  };

  void Initialize() {
    int i,j;
    for (i=0;i<512;i++) {
      for (j=0;j<512;j++) {
		n[i][j] = NULL;
      }
    }
  };

};




#endif

