
#ifndef PATHVIZ_H
#define PATHVIZ_H

class PathViz {

public:

	float startx, starty, xsize, ysize;
	float xrot, yrot;

	int detailstart, detailend; // 0-511

	int selectedBound; // 0-start, 1-end

	int bothBoundsRefX;
	int StartRef, EndRef;

	PathViz() : xrot(0.0) , yrot(0.0) { };

	void Init(float sx, float sy, float xs, float ys) {
		startx = sx; starty = sy; xsize = xs; ysize = ys;
	};

	void selectBound(int x) {
		int sd, ed;
		sd = x - detailstart; if (sd<0) sd = -sd;
		ed = x - detailend; if (ed<0) ed = -ed;
		if (sd < ed) {
			selectedBound = 0;
		} else {
			selectedBound = 1;
		} 
		if ((sd>4)&&(ed>4)&&(x>detailstart)&&(x<detailend)) {
			selectedBound = 2; // move both bounds
			bothBoundsRefX = x;
			StartRef = detailstart;
			EndRef = detailend;
		}
	};

	void moveBound(int x) {
		int temp;
		if (selectedBound == 2) {
			detailstart = (x - bothBoundsRefX) + StartRef;
			detailend = (x - bothBoundsRefX) + EndRef;
			if (detailstart >= 505) detailstart = 505;
			if (detailend >= 505) detailend = 505;
			if (detailstart < 0) detailstart = 0;
			if (detailend < 0) detailend = 0;
			return;
		}
		if (selectedBound == 0) {
			detailstart = x;
		} else {
			detailend = x;
		}
		if (detailend < detailstart) {
			temp = detailend;
			detailend = detailstart;
			detailstart = temp;
		}
	};


	void setRotation(int x, int y) {
		xrot += 0.1*(float)x;
		yrot += 0.1*(float)y;
	};

	void Draw() { 
	/*	
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective( // field of view in degree  , aspect ratio  , Z near , Z far 
						45.0, 1.0, 1.0, 100.0);	
		glViewport(startx,starty,xsize,ysize);
				// startx, starty, xsize, ysize
				// coordinates begin from lower left corner of window
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);	
		gluLookAt(-10.0,15.0,30.0,  // eye  
					5.0,0.0,0.0,      // center 
					0.0, 1.0, 0.0);      // up is in postive Y direction 
		glPushMatrix();
		glRotatef(-yrot,1.0,0.0,0.0);
		glRotatef(xrot,0.0,1.0,0.0);
		G1.DrawAnnPaths(detailstart, detailend);
		glPopMatrix();
	*/

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(0.0,10.0,0.0,10.0);
				// left, right, bottom, top
		glViewport(startx, starty, xsize, ysize);
				// startx, starty, xsize, ysize
				// coordinates begin from lower left corner of window		

	    glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();	

	    glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);

		glPushMatrix();
		//G1.Draw();
		//G1.DrawPathsInSlots(detailstart,detailend); // draw all the paths travelled in this time window
		G1.DrawCustomHighlightTopology();
		glPopMatrix();
	



	};



};

#endif

