
#include "glut.h"
#include "glui.h"
#include "aggviz.h"
#include "tcpdump_data.h"

extern All_TCPdump_data ATCP;


void AggViz::Init(float sx, float sy, float xs, float ys) {
	startx = sx; starty = sy; xsize = xs; ysize = ys;
}

void AggViz::selectBound(int x) {
	int sd, ed;
	sd = x - detailstart; if (sd<0) sd = -sd;
	ed = x - detailend; if (ed<0) ed = -ed;
	if (sd < ed) {
		selectedBound = 0;
	} else {
		selectedBound = 1;
	} 
	if ((sd>4)&&(ed>4)&&(x>detailstart)&&(x<detailend)) {
		selectedBound = 2; // move both bounds
		bothBoundsRefX = x;
		StartRef = detailstart;
		EndRef = detailend;
	}
}

void AggViz::moveBound(int x) {
	int temp;
	if (selectedBound == 2) {
		detailstart = (x - bothBoundsRefX) + StartRef;
		detailend = (x - bothBoundsRefX) + EndRef;
		if (detailstart >= 511) detailstart = 511;
		if (detailend >= 511) detailend = 511;
		if (detailstart < 0) detailstart = 0;
		if (detailend < 0) detailend = 0;
		return;
	}
	if (selectedBound == 0) {
		detailstart = x;
	} else if (selectedBound == 1) {
		detailend = x;
	}
	if (detailend < detailstart) {
		temp = detailend;
		detailend = detailstart;
		detailstart = temp;
	}
}


void AggViz::DrawOverviewBounds() {

	char str[64];
	int i;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(0,512,0,10);
			// left, right, bottom, top
	glViewport(startx, starty, xsize, ysize);
			// startx, starty, xsize, ysize
			// coordinates begin from lower left corner of window
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    glDisable(GL_TEXTURE_2D);		
	glDisable(GL_LIGHTING);
	glPushMatrix();
		
	// draw line on either side of the bounding window
	glLineWidth(1);
	glColor3f(0.5,0.5,0.5);
	glBegin(GL_LINES);
	glVertex2i(detailstart,1);
	glVertex2i(detailstart,8);
	glVertex2i(detailend,1);
	glVertex2i(detailend,8);
	glEnd();

	// color the bounding window
	glColor3f(0.3,0.3,0.9);
	glBegin(GL_QUADS);
	glVertex3f((float)detailstart,1.0,-0.5);
	glVertex3f((float)detailstart,8.0,-0.5);
	glVertex3f((float)detailend,8.0,-0.5);
	glVertex3f((float)detailend,1.0,-0.5);
	glEnd();

	glPopMatrix();


	glColor3f(0.1,0.1,0.1);
	glBegin(GL_LINES);
	glVertex3f((float)detailstart,8.0,-0.5);
	glVertex3f((float)detailstart,9.0,-0.5);
	glEnd();


	i = ATCP.t_array[0].timestamp + 
		(detailstart * (ATCP.t_array[ATCP.numentries-1].timestamp - ATCP.t_array[0].timestamp))/512;
	sprintf(str,"%d",i);
	glColor3f(0.1,0.1,0.1);
	for (i=0;i<strlen(str);i++) {
		glRasterPos3f((float)detailstart + 4.0*(float)i,9.0,0.2f);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,str[i]);	
	}


	i = ATCP.t_array[0].timestamp + 
		(detailend * (ATCP.t_array[ATCP.numentries-1].timestamp - ATCP.t_array[0].timestamp))/512;
	sprintf(str,"%d",i);
	glColor3f(0.1,0.1,0.1);
	for (i=0;i<strlen(str);i++) {
		glRasterPos3f((float)detailend + 4.0*(float)i,8.0,0.2f);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,str[i]);	
	}


}

void AggViz::DrawTimeLine() {

	int i;
	char str[64];

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(0,512,0,10);
			// left, right, bottom, top
	glViewport(startx, starty, xsize, ysize);
			// startx, starty, xsize, ysize
			// coordinates begin from lower left corner of window
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	glPushMatrix();
		
	// draw line on either side of the bounding window
	glLineWidth(1);
	glColor3f(0.8,0.8,0.8);
	glBegin(GL_LINES);
	glVertex2i(0,1);
	glVertex2i(0,8);
	glVertex2i(511,1);
	glVertex2i(511,8);
	glVertex2i(0,1);
	glVertex2i(511,1);
	glVertex2i(0,8);
	glVertex2i(511,8);
	glEnd();

	glColor3f(0.2,0.2,0.2);
	glLineWidth(1);
	glBegin(GL_LINES);
	for (i=0;i<512;i++) {
		glVertex3f((float)i,
				1.0 + (float)(1 + ATCP.binsend[i] - ATCP.bins[i])/(float)ATCP.maxbin * 7.0,
				0.1);
		glVertex3f((float)i, 1.0, 0.1);
	}
	glEnd();

	sprintf(str,"%d",ATCP.t_array[0].timestamp);
	glColor3f(0.1,0.1,0.1);
	for (i=0;i<strlen(str);i++) {
		glRasterPos3f(4.0*(float)i,0.0,0.2f);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,str[i]);	
	}

	sprintf(str,"%d",ATCP.t_array[ATCP.numentries-1].timestamp);
	glColor3f(0.1,0.1,0.1);
	for (i=0;i<strlen(str);i++) {
		glRasterPos3f(480.0 + 4.0*(float)i,0.0,0.2f);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,str[i]);	
	}

}



void AggViz::Draw() { 

	char str[64];
	int i;

	// ****************** bounds ************************************************************** 

	DrawOverviewBounds();

	// ****************** time line, total number of announcements ****************** 

	DrawTimeLine();

/*

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(0,512,0,G1.maxnumanns);
				// left, right, bottom, top
		glViewport(startx, starty, xsize, 0.2 * ysize);
				// startx, starty, xsize, ysize
				// coordinates begin from lower left corner of window
	    glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	    glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);

		glPushMatrix();
	    G1.DrawTimeLine(-1);
		glColor3f(0.8,0.8,0.8);
		glBegin(GL_QUADS);
		glVertex3f(0.0,0.0,-0.7);
		glVertex3f(0.0,(float)G1.maxnumanns,-0.7);
		glVertex3f(512.0,(float)G1.maxnumanns,-0.7);
		glVertex3f(512.0,0.0,-0.7);
		glEnd();
		glColor3f(1.0,1.0,1.0);
		glBegin(GL_LINES);
		glVertex3f(0.0,0.0,0.5);
		glVertex3f(512.0,0.0,0.5);
		glEnd();
	    glPopMatrix();

		// ****************** label this display ***********************************************

		if (!publication) {
			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			gluOrtho2D(0,160,0,5);
					// left, right, bottom, top
			glViewport(startx - 0.15*xsize, starty, xsize, 0.2 * ysize);
					// startx, starty, xsize, ysize
					// coordinates begin from lower left corner of window
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			glDisable(GL_TEXTURE_2D);
			glDisable(GL_LIGHTING);
			glColor3f(1.0,1.0,1.0);
			strcpy(str,"Num updates (all time)");
			for (i=0;i<strlen(str);i++) {
				glRasterPos3f((float)i,1.0,1.0);
				glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,str[i]);
			}
		}


		// ****************** time line, paths **************************************************** 

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(0,512,-1,2*(G1.ndistinctpaths+1));
				// left, right, bottom, top
		glViewport(startx, starty + 0.25 * ysize, xsize, 0.2 * ysize);
				// startx, starty, xsize, ysize
				// coordinates begin from lower left corner of window
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	    glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);


		glColor3f(0.5,0.5,0.5);
		glBegin(GL_LINES);
		glVertex3f(0.0,0.0,0.0);
		glVertex3f(511.5,0.0,0.0);
		glVertex3f(0.0,2.0*((float)G1.ndistinctpaths+0.9),0.0);
		glVertex3f(511.5,2.0*((float)G1.ndistinctpaths+0.9),0.0);
		glVertex3f(0.0,0.0,0.0);
		glVertex3f(0.0,2.0*((float)G1.ndistinctpaths+0.9),0.0);
		glVertex3f(511.5,0.0,0.0);
		glVertex3f(511.5,2.0*((float)G1.ndistinctpaths+0.9),0.0);
		glEnd();


		glPushMatrix();
		G1.DrawTimeDistinctPaths(-1);
		glPopMatrix();

		// ****************** label this display ***********************************************

		if (!publication) {
			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			gluOrtho2D(0,160,0,5);
					// left, right, bottom, top
			glViewport(startx - 0.15*xsize, starty + 0.25 * ysize, xsize, 0.2 * ysize);
					// startx, starty, xsize, ysize
					// coordinates begin from lower left corner of window
		    glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
		    glDisable(GL_TEXTURE_2D);
			glDisable(GL_LIGHTING);
			glColor3f(1.0,1.0,1.0);
			strcpy(str,"Unique routes (all time)");
			for (i=0;i<strlen(str);i++) {
				glRasterPos3f((float)i,1.0,1.0);
				glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,str[i]);
			}
		}

	
		
		// ****************** bounds ************************************************************** 

		DrawDetailBounds();
	
		
		// ****************** window distinct paths **************************************************** 

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(0,512,-1,2*(G1.ndistinctpaths+1));
				// left, right, bottom, top
		glViewport(startx, starty + 0.5*ysize, xsize, 0.5 * ysize);
				// startx, starty, xsize, ysize
				// coordinates begin from lower left corner of window
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	    glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);

		glColor3f(0.5,0.5,0.5);
		glBegin(GL_LINES);
		glVertex3f(0.0,0.0,0.0);
		glVertex3f(511.5,0.0,0.0);
		glVertex3f(0.0,2.0*((float)G1.ndistinctpaths+0.9),0.0);
		glVertex3f(511.5,2.0*((float)G1.ndistinctpaths+0.9),0.0);
		glVertex3f(0.0,0.0,0.0);
		glVertex3f(0.0,2.0*((float)G1.ndistinctpaths+0.9),0.0);
		glVertex3f(511.5,0.0,0.0);
		glVertex3f(511.5,2.0*((float)G1.ndistinctpaths+0.9),0.0);
		glEnd();


		glPushMatrix();
		G1.DrawNewWinDistinctPaths(detailstart, detailend);
		glPopMatrix();

		
		// ****************** label this display ***********************************************


		if (!publication) {
			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			gluOrtho2D(0,160,0,5);
					// left, right, bottom, top
			glViewport(startx - 0.15*xsize, starty + 0.7 * ysize, xsize, 0.2 * ysize);
					// startx, starty, xsize, ysize
					// coordinates begin from lower left corner of window
		    glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
		    glDisable(GL_TEXTURE_2D);
			glDisable(GL_LIGHTING);
			glColor3f(1.0,1.0,1.0);
			strcpy(str,"Unique routes (window)");
			for (i=0;i<strlen(str);i++) {
				glRasterPos3f((float)i,1.0,1.0);
				glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,str[i]);
			}
		}
*/


}



