
#include <stdlib.h>
#include <math.h>
#include "glut.h"
#include "glui.h"
#include "display.h"

#include "quadtree.h"
#include "parcoords.h"
#include "parplanes.h"
#include "tcpdump_data.h"

#include "aggviz.h"


extern AggViz AV;

extern QuadTree Q;
extern ParCoords P;
extern ParPlanes PP;
extern All_TCPdump_data ATCP;


int BGPViewerTexMap[64][64];
GLubyte TextureBGPViewer[64][64][4];
GLuint texNameBGPViewer;

void Display::SetOrtho(float l, float r, float b, float t) {
	left = l; right = r; bottom = b; top = t;
}


void Display::SetDimensions(float sx, float sy, float xs, float ys) {
	startx = sx; starty = sy; xsize = xs; ysize = ys;
}


void Display::SelectNode(int x, int y, int a) {

	float nx, ny;

	// transform to display coordinates
	nx = ((float)x - startx)/xsize;
	nx = left + nx * (right-left);
	ny = ((float)y - starty)/ysize;
	ny = bottom + ny * (top-bottom);

	if (a==0) {
		if (ny > 1.1) {
			P.ToggleLabelAttackAxis(nx,ny);
		} else if (ny > 1.0) {
			P.ToggleLabelAxis(nx,ny);
		} else {
			P.SelectBound(nx, ny);
		}
	} else {
		if (ny <= 1.0) P.MoveBound(nx, ny);
	}

}



void Display::Draw() {

	int i;
	int e;

	char str1[32];
	char str2[32];
	char attackstr[32];
	glClearColor(1.0,1.0,1.0,0.0);
    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(left,right,bottom,top);
	  		     // left, right, bottom, top
	glViewport(startx, starty, xsize, ysize);
			// startx, starty, xsize, ysize
			// coordinates begin from lower left corner of window


	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	// draw the legend of the attack types on the right hand side of the screen
	float eachx;
	eachx = 1.0/(float)ATCP.num_attack_type;
	for (i=0;i<ATCP.num_attack_type;i++) {
		P.SetDisplayColor(i);
		glBegin(GL_QUADS);
		glVertex3f(1.45, eachx*(float)i, 0.1);
		glVertex3f(1.47, eachx*(float)i, 0.1);
		glVertex3f(1.47, eachx*(float)i+0.02, 0.1);
		glVertex3f(1.45, eachx*(float)i+0.02, 0.1);
		glEnd();
		glColor3f(0.1,0.1,0.1);
		for (e=0;e<strlen(ATCP.attack_str[i]);e++) {
			glRasterPos3f(1.48+0.01*(float)e,eachx*((float)i+0.1),0.1);
			glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,ATCP.attack_str[i][e]);	
		}
	}
	

	if (mode==0) { // draw the parallel coordinates
		P.DrawAxes();
		P.ResetValueLabels();
		if (use_user_time) {
			for (e=0; e<=ATCP.numentries; e++) {
				if ((ATCP.t_array[e].timestamp>=start_user_time) && 
					(ATCP.t_array[e].timestamp<=end_user_time) && 
					(CheckFilter(ATCP.t_array[e]))) {
					strcpy(attackstr,ATCP.attack_str[ATCP.t_array[e].type]);
					if (ATCP.t_array[e].srcPort>=0) {
						sprintf(str1,"%d",ATCP.t_array[e].srcPort);
						ATCP.t_array[e].IPtoText(0,str2);
						P.DrawOneLine(0,((float)(ATCP.t_array[e].srcPort))/65536.0,
								1,ATCP.t_array[e].IPtoFloat(0), ATCP.t_array[e].type, 
								str1, str2, ATCP.attack_str[ATCP.t_array[e].type]);
					}
					ATCP.t_array[e].IPtoText(0,str1);
					ATCP.t_array[e].IPtoText(1,str2);
					P.DrawOneLine(1,ATCP.t_array[e].IPtoFloat(0),
							2,ATCP.t_array[e].IPtoFloat(1), ATCP.t_array[e].type, 
							str1, str2, ATCP.attack_str[ATCP.t_array[e].type]);
					for (i=0; i<ATCP.t_array[e].num_dstPorts; i++) {
						ATCP.t_array[e].IPtoText(1,str1);
						sprintf(str2,"%d",ATCP.t_array[e].dstPorts[i]);
						P.DrawOneLine(2,ATCP.t_array[e].IPtoFloat(1),
							3,((float)(ATCP.t_array[e].dstPorts[i]))/65536.0, ATCP.t_array[e].type, 
							str1, str2, ATCP.attack_str[ATCP.t_array[e].type]);
					}
				}
			}
		} else {
			for (e=ATCP.bins[AV.detailstart]; e<=ATCP.binsend[AV.detailend]; e++) {
				if (CheckFilter(ATCP.t_array[e])) {
					strcpy(attackstr,ATCP.attack_str[ATCP.t_array[e].type]);
					if (ATCP.t_array[e].srcPort>=0) {
						sprintf(str1,"%d",ATCP.t_array[e].srcPort);
						ATCP.t_array[e].IPtoText(0,str2);
						P.DrawOneLine(0,((float)(ATCP.t_array[e].srcPort))/65536.0,
								1,ATCP.t_array[e].IPtoFloat(0), ATCP.t_array[e].type, 
								str1, str2, ATCP.attack_str[ATCP.t_array[e].type]);
					}
					ATCP.t_array[e].IPtoText(0,str1);
					ATCP.t_array[e].IPtoText(1,str2);
					P.DrawOneLine(1,ATCP.t_array[e].IPtoFloat(0),
							2,ATCP.t_array[e].IPtoFloat(1), ATCP.t_array[e].type, 
							str1, str2, ATCP.attack_str[ATCP.t_array[e].type]);
					for (i=0; i<ATCP.t_array[e].num_dstPorts; i++) {
						ATCP.t_array[e].IPtoText(1,str1);
						sprintf(str2,"%d",ATCP.t_array[e].dstPorts[i]);
						P.DrawOneLine(2,ATCP.t_array[e].IPtoFloat(1),
							3,((float)(ATCP.t_array[e].dstPorts[i]))/65536.0, ATCP.t_array[e].type, 
							str1, str2, ATCP.attack_str[ATCP.t_array[e].type]);
					}
				}
			}
		}
	} else if (mode==1) { // parallel planes
		DrawParPlanes();
	} else if (mode==2) { // parallel quadtrees
		Draw3D();
	}


}


void Display::DrawParPlanes() {

	int i;
	int e;

	char str1[32];
	char str2[32];
	char attackstr[32];

	// draw the parallel planes

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective( // field of view in degree  , aspect ratio  , Z near , Z far 
					45.0, 1.0, 0.1, 5.0);
	glViewport(0.0,0.0,700.0,700.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);	
	gluLookAt(0.5, 0.5, 3.5,  // eye  
				0.5, 0.5, 0.5,      // center 
				0.0, 1.0, 0.0);      // up is in postive Y direction
	glPushMatrix();
	
	glTranslatef( 0.5, 0.5, 0.5 );
	glRotatef( sideRotationX, 1.0, 0.0, 0.0 );
	//glRotatef( sideRotationY, 0.0, 0.0, 1.0 );
	glTranslatef( -0.5, -0.5, -0.5 );
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	PP.DrawPlanes();

	for (e=ATCP.bins[AV.detailstart]; e<=ATCP.binsend[AV.detailend]; e++) {
		if (ATCP.t_array[e].srcPort>=0) {
			for (i=0; i<ATCP.t_array[e].num_dstPorts; i++) {
				ATCP.t_array[e].IPtoText(1,str1);
				sprintf(str2,"%d",ATCP.t_array[e].dstPorts[i]);
				PP.DrawOneLine(((float)(ATCP.t_array[e].srcPort))/65536.0, // source port
								ATCP.t_array[e].IPtoFloat(0), // source IP
								((float)(ATCP.t_array[e].dstPorts[i]))/65536.0, // destination port
								ATCP.t_array[e].IPtoFloat(1), // destination IP
								ATCP.t_array[e].type); // attack type
			}
		}
	}


}

void Display::Draw3D() {

	int i;
	int qpos[2];
	float x, y;
	int e;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective( // field of view in degree  , aspect ratio  , Z near , Z far 
					60.0, 1.0, 0.1, 5.0);
	glViewport(0.0,0.0,600.0,600.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);	
	gluLookAt(0.5, 0.5, 3.5,  // eye  
				0.5, 0.5, 0.5,      // center 
				0.0, 1.0, 0.0);      // up is in postive Y direction
	glPushMatrix();
	
	glTranslatef( 0.5, 0.5, 0.5 );
	glRotatef( sideRotationX, 1.0, 0.0, 0.0 );
	glRotatef( sideRotationY, 0.0, 0.0, 1.0 );
	glTranslatef( -0.5, -0.5, -0.5 );
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	for (e=ATCP.bins[AV.detailstart]; e<=ATCP.binsend[AV.detailend]; e++) {
		P.SetDisplayColor(ATCP.t_array[e].type);
		glLineWidth(2);
		glBegin(GL_LINE_STRIP);

		if (ATCP.t_array[e].srcPort>=0) {
			glVertex3f(-1.0,0.5,((float)(ATCP.t_array[e].srcPort))/65536.0);
		}
		Q.IPtoQuad(ATCP.t_array[e].srcIP, qpos);
		x = (float)qpos[0]/(float)Q.side;
		y = (float)qpos[1]/(float)Q.side;
		glVertex3f(0.0,x,y);
		Q.IPtoQuad(ATCP.t_array[e].dstIP, qpos);
		x = (float)qpos[0]/(float)Q.side;	
		y = (float)qpos[1]/(float)Q.side;
		glVertex3f(1.0,x,y);
		glEnd();
		for (i=0; i<ATCP.t_array[e].num_dstPorts; i++) {
			glBegin(GL_LINES);
			Q.IPtoQuad(ATCP.t_array[e].dstIP, qpos);
			x = (float)qpos[0]/(float)Q.side;	
			y = (float)qpos[1]/(float)Q.side;
			glVertex3f(1.0,x,y);
			glVertex3f(2.0,0.5,((float)(ATCP.t_array[e].dstPorts[i]))/65536.0);
			glEnd();
		}
	}

	glColor4f(0.8,0.8,0.8,0.8);

	glEnable(GL_TEXTURE_2D);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glBindTexture(GL_TEXTURE_2D, texNameBGPViewer);

	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 0.0); glVertex3f(0.0,0.0,0.0);
	glTexCoord2f(0.0, 1.0); glVertex3f(0.0,1.0,0.0);
	glTexCoord2f(1.0, 1.0); glVertex3f(0.0,1.0,1.0);
	glTexCoord2f(1.0, 0.0); glVertex3f(0.0,0.0,1.0);
	glEnd();



	glBegin(GL_QUADS);
	glTexCoord2f(0.0, 0.0); glVertex3f(1.0,0.0,0.0);
	glTexCoord2f(0.0, 1.0); glVertex3f(1.0,1.0,0.0);
	glTexCoord2f(1.0, 1.0); glVertex3f(1.0,1.0,1.0);
	glTexCoord2f(1.0, 0.0); glVertex3f(1.0,0.0,1.0);
	glEnd();

	
	glDisable(GL_TEXTURE_2D);


	glLineWidth(2);

	glBegin(GL_LINES);
	glVertex3f(-1.0,0.5,0.0);
	glVertex3f(-1.0,0.5,1.0);
	glEnd();


	glBegin(GL_LINES);
	glVertex3f(2.0,0.5,0.0);
	glVertex3f(2.0,0.5,1.0);
	glEnd();

	
	glDisable(GL_BLEND);

	glPopMatrix();

}


// use first 12 bits
// make a 64 X 64 texture map
void Display::MakeTextureMap() {

	int i,k,n,xupper,xlower,yupper,ylower,x,y;


	for (k=0;k<64*64;k++) {

	  xupper = yupper = 63;
	  xlower = ylower = 0;

	  for (i=0;i<5;i++) {
	    n = (k >> ((5-i)*2)) & 3;
		if (n&1) { 
		    xlower += (1+xupper-xlower)/2;
		} else {
			xupper = xlower + (1+xupper-xlower)/2 - 1;
		}
		if (n&2) {
			ylower += (1+yupper-ylower)/2;
		} else {
			yupper = ylower + (1+yupper-ylower)/2 - 1;
		}
	  }
 
	  n = k & 3;
	  if (n&1) {
		x = xupper;
	  } else {
		x = xlower;
	  }
      if (n&2) {
        y = yupper;
	  } else {
        y = ylower;
	  }

	  BGPViewerTexMap[x][y] = k;

	}

	int val;
	int s,t;

	int defaultAlignment;

	glGetIntegerv(GL_UNPACK_ALIGNMENT, &defaultAlignment);

	glEnable(GL_TEXTURE_2D);

	for (s=0; s<64; s++) {	
		for (t=0; t<64; t++) {
			val = BGPViewerTexMap[s][t]/32;
			TextureBGPViewer[s][t][0] = (GLubyte)val;
			TextureBGPViewer[s][t][1] = (GLubyte)val;
			TextureBGPViewer[s][t][2] = (GLubyte)val;
			TextureBGPViewer[s][t][3] = 128; // half transparent, full opacity is 255
		}
	}


	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glGenTextures(1, &texNameBGPViewer);

	
	glBindTexture(GL_TEXTURE_2D, texNameBGPViewer);

	printf("BGP texture %d\n", (int)texNameBGPViewer);

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);


	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 64, 64, 0,
				GL_RGBA, GL_UNSIGNED_BYTE, TextureBGPViewer);


	glDisable(GL_TEXTURE_2D);

	glPixelStorei(GL_UNPACK_ALIGNMENT, defaultAlignment);


}


void Display::ReadFilterFile(char *fname) {

	FILE *fptr;
	char buffer[1024];
	char iden[32];
	int i, n, pos, pos2;

	num_filter_srcports = num_filter_dstports = num_filter_srcips = num_filter_dstips = 0;
	for (i=0;i<128;i++) {
		filter_dstports_isrange[i] = filter_dstips_isrange[i] = filter_srcports_isrange[i] = 
			filter_srcips_isrange[i] = 0;
	}

	fptr = fopen(fname,"rt");

	while ( !feof(fptr) && fgets(buffer,1024,fptr) != NULL ) {
		
		if (strlen(buffer)>5) {
			sscanf(buffer,"%s", iden);		
			if (strcmp(iden,"destination_port")==0) {
				pos = 16;
				while (pos < strlen(buffer)) {
					// find next delimiter, either ',' or '-' or EOL
					pos2 = pos;
					while ((buffer[pos2]!=',') && (buffer[pos2]!='-') && (pos2<strlen(buffer))) pos2++;
					if (buffer[pos2]==',') {
						buffer[pos2] = ' ';
						sscanf(&(buffer[pos]),"%d",&n);
						filter_dstports[num_filter_dstports][1] = n;
						num_filter_dstports++;
						//printf("read port %d\n", n);
					} else if (buffer[pos2]=='-') {
						buffer[pos2] = ' ';
						sscanf(&(buffer[pos]),"%d",&n);
						filter_dstports[num_filter_dstports][0] = n;
						filter_dstports_isrange[num_filter_dstports] = 1;
						//printf("read first port %d\n", n);
					} else {
						sscanf(&(buffer[pos]),"%d",&n);
						filter_dstports[num_filter_dstports][1] = n;
						num_filter_dstports++;
						//printf("read port %d\n", n);
					}
					pos = pos2;
				}
			} else if (strcmp(iden,"source_port")==0) {
				pos = 16;
				while (pos < strlen(buffer)) {
					// find next delimiter, either ',' or '-' or EOL
					pos2 = pos;
					while ((buffer[pos2]!=',') && (buffer[pos2]!='-') && (pos2<strlen(buffer))) pos2++;
					if (buffer[pos2]==',') {
						buffer[pos2] = ' ';
						sscanf(&(buffer[pos]),"%d",&n);
						filter_srcports[num_filter_srcports][1] = n;
						num_filter_srcports++;
						//printf("read port %d\n", n);
					} else if (buffer[pos2]=='-') {
						buffer[pos2] = ' ';
						sscanf(&(buffer[pos]),"%d",&n);
						filter_srcports[num_filter_srcports][0] = n;
						filter_srcports_isrange[num_filter_srcports] = 1;
						//printf("read first port %d\n", n);
					} else {
						sscanf(&(buffer[pos]),"%d",&n);
						filter_srcports[num_filter_srcports][1] = n;
						num_filter_srcports++;
						//printf("read port %d\n", n);
					}
					pos = pos2;
				}
			}
		}
	}

	for (i=0;i<num_filter_dstports;i++) {
		if (filter_dstports_isrange[i]==1) {
			printf("%d-%d\n", filter_dstports[i][0], filter_dstports[i][1]);
		} else {
			printf("%d\n", filter_dstports[i][1]);
		}
	}

}



int Display::CheckFilter(const TCPdump_data &t) {

	int i, j;
	int r;

	r = 0;

	if (filter_dstport) {
		for (i=0;i<num_filter_dstports;i++) {
			for (j=0;j<t.num_dstPorts;j++) {
				if (filter_dstports_isrange[i]) {
					if ((t.dstPorts[j]>=filter_dstports[i][0]) && 
						(t.dstPorts[j]<=filter_dstports[i][1])) {
						r = 1;
					}
				} else {
					if (t.dstPorts[j]==filter_dstports[i][1]) r = 1;
				}
			}
		}
		if (r==0) return 0;
	}

	r = 0;

	if (filter_srcport) {
		for (i=0;i<num_filter_srcports;i++) {
			if (filter_srcports_isrange[i]) {
				if ((t.srcPort>=filter_srcports[i][0]) && 
					(t.srcPort<=filter_srcports[i][1])) {
					r = 1;
				}
			} else {
				if (t.srcPort==filter_srcports[i][1]) r = 1;
			}
		}
		if (r==0) return 0;
	}


	return 1;

}

