
#ifndef DISPLAY_H
#define DISPLAY_H

#include "tcpdump_data.h"

#define MAX_N_NODES 1024
#define MAX_N_LINKS 4096
#define MAX_NODES_PER_CELL 32


class Display {
public:

	int mode;
	int current_entry;
	float startx, starty, xsize, ysize;
	float left, right, bottom, top;
	float sideRotationX, sideRotationY;

	int filter_srcports[128][2]; // from, to
	int filter_dstports[128][2]; // from, to
	unsigned char filter_srcips[128][2][4]; // from, to
	unsigned char filter_dstips[128][2][4]; // from, to
	int filter_srcports_isrange[128];
	int filter_srcips_isrange[128];
	int filter_dstports_isrange[128];
	int filter_dstips_isrange[128];
	int num_filter_srcports, num_filter_dstports, num_filter_srcips, num_filter_dstips;
	int filter_srcip, filter_srcport, filter_dstip, filter_dstport; // user set flags
	int start_user_time, end_user_time, use_user_time;

	Display() : mode(0), current_entry(0) , sideRotationX(0.0), sideRotationY(0.0) {};
	void SetOrtho(float l, float r, float b, float t);
	void SetDimensions(float sx, float sy, float xs, float ys);
	void Draw();
	void DrawParPlanes();
	void Draw3D();
	void SelectNode(int x, int y, int a); // a=0 select, a=1 move
	void MakeTextureMap();
	void ReadFilterFile(char *fname);
	int CheckFilter(const TCPdump_data & t);

};

#endif

