

#include <string.h>
#include "glut.h"
#include <time.h>
#include "glui.h"


#include "gui.h"
#include "display.h"
#include "tcpdump_data.h"
#include "parcoords.h"
#include "aggviz.h"


Display DP;
AggViz AV;

extern All_TCPdump_data ATCP;
extern ParCoords P;


// graphics canvas dimensions
int sidewidth, sideheight;
int sidex, sidey, controlx, controly, controlx2, controly2;

int last_x, last_y;

int temp;

float fov;

GLUI *glui;
GLUI *simulation_glui; 
GLUI_Panel *simulation_panel1;
GLUI_Checkbox   *mode_chkbx0, *mode_chkbx1, *mode_chkbx2;
GLUI_Spinner *srcport_upper_spinner, *srcport_lower_spinner;
GLUI_Spinner *dstport_upper_spinner, *dstport_lower_spinner;
GLUI_Spinner *srcip_upper0_spinner, *srcip_upper1_spinner, *srcip_upper2_spinner, *srcip_upper3_spinner;
GLUI_Spinner *srcip_lower0_spinner, *srcip_lower1_spinner, *srcip_lower2_spinner, *srcip_lower3_spinner;
GLUI_Spinner *dstip_upper0_spinner, *dstip_upper1_spinner, *dstip_upper2_spinner, *dstip_upper3_spinner;
GLUI_Spinner *dstip_lower0_spinner, *dstip_lower1_spinner, *dstip_lower2_spinner, *dstip_lower3_spinner;
GLUI_Spinner *delay_spinner;
char filename[16];
GLUI_EditText *filename_text;
int file_num;
GLUI_Checkbox   *filter_chkbx0, *filter_chkbx1, *filter_chkbx2, *filter_chkbx3;
GLUI *zoom_glui;
GLUI *filter_glui;
GLUI_Checkbox   *panelmode_chkbx0, *panelmode_chkbx1;
GLUI_Spinner *filter_spinner0, *filter_spinner1;
GLUI_Checkbox   *filter_timechkbx;

enum mouse_action { MOUSE_LEFT_DOWN , MOUSE_ROTATE , MOUSE_DEFAULT , MOUSE_MOVEBOUND ,
					MOUSE_DETAIL , MOUSE_SELECT_PATH , MOUSE_MEASURE , MOUSE_THRES };

mouse_action action;

int lastx, lasty;

clock_t old_time;
double delay = 0.3;

void sideGlutDisplay( void );

int side_window;

void redraw_func(int id);
void InitParCoords();

void advance_cb(int id) {
	if (DP.current_entry < ATCP.numentries - 1) {
		DP.current_entry++;
	} else {
		DP.current_entry = 0;
	}
	redraw_func(id);
}

void mode_cb(int id) {
	if (id==0) {
		mode_chkbx0->set_int_val(1);
		mode_chkbx1->set_int_val(0);
		mode_chkbx2->set_int_val(0);
	} else if (id==1) {
		mode_chkbx0->set_int_val(0);
		mode_chkbx1->set_int_val(1);
		mode_chkbx2->set_int_val(0);
	} else if (id==2) {
		mode_chkbx0->set_int_val(0);
		mode_chkbx1->set_int_val(0);
		mode_chkbx2->set_int_val(1);
	}
	
	DP.mode = id;
	redraw_func(id);
}


void uppersrcip_cb(int id) {
	char buf[32];
	ATCP.UpperSrcIP[id] = (unsigned char)temp;
	redraw_func(id);
}


void lowersrcip_cb(int id) {
	ATCP.LowerSrcIP[id] = (unsigned char)temp;
	redraw_func(id);
}


void upperdstip_cb(int id) {
	ATCP.UpperDstIP[id] = (unsigned char)temp;
	redraw_func(id);
}


void lowerdstip_cb(int id) {
	ATCP.LowerDstIP[id] = (unsigned char)temp;
	redraw_func(id);
}


void panelmode_cb(int id) {

	if (id==0) {
		panelmode_chkbx0->set_int_val(1);
		panelmode_chkbx1->set_int_val(0);
		filter_glui->show();
		zoom_glui->hide();
	} else if (id==1) {
		panelmode_chkbx0->set_int_val(0);
		panelmode_chkbx1->set_int_val(1);
		filter_glui->hide();
		zoom_glui->show();
	}
}

void redraw_func(int id) {
	InitParCoords();
    glutSetWindow(side_window);  
	glutPostRedisplay();
}


int movie_frame;
unsigned char imageBufferRGBA_ptr[10000000];

void tgaOut(char * fileName) {
	// create the TGA header
	unsigned char header[18];
    glutSetWindow(side_window);  
	glutPostRedisplay();	
	glReadBuffer(GL_FRONT);
	glReadPixels(0,0,(GLsizei)sidewidth,(GLsizei)sideheight,GL_RGBA, GL_UNSIGNED_BYTE, imageBufferRGBA_ptr);
	
	for(int counter=0;counter<18;counter++)
	{
		header[counter]=0;
	}
	header[2]=2;
	header[12]=sidewidth%256;
	header[13]=sidewidth/256;
	header[14]=sideheight%256;
	header[15]=sideheight/256;
	header[16]=24;
	header[17]=24;

	unsigned char RGB[3];
	FILE *file_ptr;
	file_ptr=fopen(fileName,"wb");
	if(file_ptr==NULL)
	{
		printf("unable to write to %s\n",fileName);
		return ;
	}
	fwrite(header,18,1,file_ptr);
	int x,y;
	int actualWidth;
	actualWidth = sidewidth;
	// for each pixel
	for(y=0;y<sideheight;y++) {
		for(x=0;x<sidewidth;x++) {
			RGB[0]=*(imageBufferRGBA_ptr+(x+y*actualWidth)*4+0);
			RGB[1]=*(imageBufferRGBA_ptr+(x+y*actualWidth)*4+1);
			RGB[2]=*(imageBufferRGBA_ptr+(x+y*actualWidth)*4+2);
			// have to swap the R and B as you save
			fwrite(RGB+2,1,1,file_ptr);
			fwrite(RGB+1,1,1,file_ptr);
			fwrite(RGB+0,1,1,file_ptr);
		}
	}
	fclose(file_ptr);
	return;
}





void makeframe_cb(int id) {
	
	char fname[32];

	sprintf(fname,"../movie/frame%03d.tga",movie_frame);
	tgaOut(fname);
	movie_frame++;
}




void myGlutKeyboard(unsigned char Key, int x, int y)
{
  switch(Key)
  {
  case 27: 
  case 'q':
    exit(0);
    break;
  };
  
  glutPostRedisplay();
}



void myGlutMenu( int value )
{
  myGlutKeyboard( value, 0, 0 );
}



void myGlutIdle( void )
{
	clock_t new_time;

	new_time = clock();
	if (((double)(new_time-old_time)/(double)CLOCKS_PER_SEC)>delay) { 
		glutSetWindow(side_window);  
		glutPostRedisplay();
		old_time = new_time;
	}

}


void sideGlutDisplay( void )
{
	
	DP.Draw();
	/*
	if (DP.mode==0) {
		DP.Draw();
	} else if (DP.mode==1) {
		DP.Draw3D();
		DP.DrawParPlanes();
	}
	*/
	AV.Draw();
	glutSwapBuffers();
}

/***************************************** myGlutMouse() **********/

void sideGlutMouse(int button, int state, int x, int y )
{
	if ((float)(sideheight - y)<(AV.starty+AV.ysize)) {
		AV.selectBound((int)(512.0*((float)x-AV.startx)/AV.xsize));
		action = MOUSE_MOVEBOUND;
	} else {
		if (DP.mode == 0) {
			if ( button == GLUT_LEFT_BUTTON && state == GLUT_DOWN) {	
				DP.SelectNode(x, sideheight - y, 0);
				action = MOUSE_LEFT_DOWN;
			} else if ( button == GLUT_LEFT_BUTTON && state == GLUT_UP) {
				action = MOUSE_DEFAULT;
			}
		} else if (DP.mode >= 1) {
			if ( button == GLUT_LEFT_BUTTON && state == GLUT_DOWN) {	
				last_x = x;
				last_y = y;
				action = MOUSE_ROTATE;
			}
		}
	}

	glutSetWindow(side_window);  
	glutPostRedisplay();
		
}


void sideGlutMotion(int x, int y )
{
	if (action == MOUSE_LEFT_DOWN) {	
		DP.SelectNode(x, sideheight - y, 1);
	} else if (action == MOUSE_ROTATE) {
		DP.sideRotationY = DP.sideRotationY + (x - last_x);
		while (DP.sideRotationY > 360.0) DP.sideRotationY -= 360.0;
		while (DP.sideRotationY < 0.0) DP.sideRotationY += 360.0;
		DP.sideRotationX = DP.sideRotationX + (y - last_y);
		while (DP.sideRotationX > 360.0) DP.sideRotationX -= 360.0;
		while (DP.sideRotationX < 0.0) DP.sideRotationX += 360.0;
		last_x = x;
		last_y = y;
	} else if (action == MOUSE_MOVEBOUND) {
		AV.moveBound((int)(512.0*((float)x-AV.startx)/AV.xsize));
	}

	glutSetWindow(side_window);  
	glutPostRedisplay();

}

/**************************************** myGlutReshape() *************/

void sideGlutReshape( int x, int y )
{

  glutPostRedisplay();
}

/********************* myGlutKeyboard() **********/

void sideGlutKeyboard(unsigned char Key, int x, int y)
{
  switch(Key)
  {
  case 27: 
  case 'q':
    exit(0);
    break;
  };
  
  glutPostRedisplay();
}


void InitParCoordsZoomBounds() {

	char buf[32];

	P.SetZoomBounds(0,0,(float)ATCP.UpperSrcPort/65536.0f);
	P.SetZoomBounds(0,1,(float)ATCP.LowerSrcPort/65536.0f);
	P.SetZoomBounds(1,0,ATCP.IPtoFloat(0));
	P.SetZoomBounds(1,1,ATCP.IPtoFloat(1));
	P.SetZoomBounds(2,0,ATCP.IPtoFloat(2));
	P.SetZoomBounds(2,1,ATCP.IPtoFloat(3));
	P.SetZoomBounds(3,0,(float)ATCP.UpperDstPort/65536.0f);
	P.SetZoomBounds(3,1,(float)ATCP.LowerDstPort/65536.0f);
}

void InitParCoords() {

	char buf[32];

	sprintf(buf, "%d", ATCP.UpperSrcPort);
	P.SetZoomOriginals(0,0,(float)ATCP.UpperSrcPort/65536.0f, buf);
	sprintf(buf, "%d", ATCP.LowerSrcPort);
	P.SetZoomOriginals(0,1,(float)ATCP.LowerSrcPort/65536.0f, buf);
	ATCP.IPtoText(0, buf);
	P.SetZoomOriginals(1,0,ATCP.IPtoFloat(0), buf);
	ATCP.IPtoText(1, buf);
	P.SetZoomOriginals(1,1,ATCP.IPtoFloat(1), buf);
	ATCP.IPtoText(2, buf);
	P.SetZoomOriginals(2,0,ATCP.IPtoFloat(2), buf);
	ATCP.IPtoText(3, buf);
	P.SetZoomOriginals(2,1,ATCP.IPtoFloat(3), buf);
	sprintf(buf, "%d", ATCP.UpperDstPort);
	P.SetZoomOriginals(3,0,(float)ATCP.UpperDstPort/65536.0f, buf);
	sprintf(buf, "%d", ATCP.LowerDstPort);
	P.SetZoomOriginals(3,1,(float)ATCP.LowerDstPort/65536.0f, buf);
}



/**************************************** main() ********************/

void InitGUI()
{

	int dummy;

	// set variables controlling window dimensions 
	sidewidth = 1000;
	sideheight =700;
	sidex = 5;
	sidey = 30;
	controlx = 1010;
	controly = 20;
	controlx2 = 1010;
	controly2 = 200;

	glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH );
  
	side_window = glutCreateWindow( "BGPViz" );
	glutPositionWindow( sidex , sidey );
	glutReshapeWindow( sidewidth , sideheight );

	glutDisplayFunc( sideGlutDisplay );
	glutReshapeFunc( sideGlutReshape );  
	glutKeyboardFunc( sideGlutKeyboard );
	glutMotionFunc( sideGlutMotion );
	glutMouseFunc( sideGlutMouse );

	glEnable(GL_DEPTH_TEST);


	fov = 40.0;

	DP.SetOrtho(-0.05,((float)sidewidth/(float)sideheight)*1.4-0.05,-0.2,1.2);
	DP.SetDimensions(0.0,0.0,sidewidth,sideheight);
	DP.mode = 0;
	DP.MakeTextureMap();
	DP.ReadFilterFile("../data/filter.txt");

	
	AV.Init(0.1*sidewidth,0.01*sideheight,0.8*sidewidth,0.1*sideheight);

	InitParCoords();
	InitParCoordsZoomBounds();

	/******** BEGIN GLUI **********************************/


	printf( "GLUI version: %3.2f\n", GLUI_Master.get_version() );


	glui = GLUI_Master.create_glui( "Control Panel", 0, controlx, controly ); 
                                  /* name, flags, x, and y */
	/*** Add invisible panel to hold rest of controls ***/
	GLUI_Panel *panel1 = glui->add_panel( "", GLUI_PANEL_NONE );
	/*** Start a new column in this panel ***/
	glui->add_column_to_panel(panel1, false); /* 'false' means don't draw bar */

	mode_chkbx0 = glui->add_checkbox_to_panel( panel1, "Parallel coordinates", &dummy, 0, mode_cb);
	mode_chkbx1 = glui->add_checkbox_to_panel( panel1, "Parallel planes", &dummy, 1, mode_cb);
	mode_chkbx2 = glui->add_checkbox_to_panel( panel1, "Parallel quadtree", &dummy, 2, mode_cb);
	mode_chkbx0->set_int_val(1);
	mode_chkbx1->set_int_val(0);
	mode_chkbx2->set_int_val(0);


	glui->add_button_to_panel(panel1, "Make frame", 0, makeframe_cb);
	movie_frame = 0;

	panelmode_chkbx0 = glui->add_checkbox_to_panel( panel1, "Set filters", &dummy, 0, panelmode_cb);
	panelmode_chkbx1 = glui->add_checkbox_to_panel( panel1, "Set zoom", &dummy, 1, panelmode_cb);
	panelmode_chkbx0->set_int_val(1);
	panelmode_chkbx1->set_int_val(0);

	filter_glui = GLUI_Master.create_glui( "Filter Panel", 0, controlx2, controly2); 
	GLUI_Panel *filter_panel1 = filter_glui->add_panel( "", GLUI_PANEL_NONE );
	filter_chkbx0 = filter_glui->add_checkbox_to_panel( filter_panel1, "Filter source IP", &(DP.filter_srcip), 0, redraw_func);
	filter_chkbx1 = filter_glui->add_checkbox_to_panel( filter_panel1, "Filter source port", &(DP.filter_srcport), 0, redraw_func);
	filter_chkbx2 = filter_glui->add_checkbox_to_panel( filter_panel1, "Filter dest IP", &(DP.filter_dstip), 0, redraw_func);
	filter_chkbx3 = filter_glui->add_checkbox_to_panel( filter_panel1, "Filter dest port", &(DP.filter_dstport), 0, redraw_func);
	filter_chkbx0->set_int_val(0);
	filter_chkbx1->set_int_val(0);
	filter_chkbx2->set_int_val(0);
	filter_chkbx3->set_int_val(0);
	DP.filter_dstip = DP.filter_dstport = DP.filter_srcip = DP.filter_srcport = 0;
	filter_spinner0 = filter_glui->add_spinner_to_panel( filter_panel1, "Start time", GLUI_SPINNER_INT, &(DP.start_user_time), 0, redraw_func);
	filter_spinner1 = filter_glui->add_spinner_to_panel( filter_panel1, "End time", GLUI_SPINNER_INT, &(DP.end_user_time), 0, redraw_func);
	filter_timechkbx = filter_glui->add_checkbox_to_panel( filter_panel1, "Use this time", &(DP.use_user_time), 0, redraw_func);
	DP.use_user_time = 0;


	zoom_glui = GLUI_Master.create_glui( "Zoom Panel", 0, controlx2, controly2); 
	GLUI_Panel *zoom_panel1 = zoom_glui->add_panel( "", GLUI_PANEL_NONE );

	GLUI_Panel *srcport_panel = zoom_glui->add_panel_to_panel( zoom_panel1, "Src Port" );
	srcport_upper_spinner = zoom_glui->add_spinner_to_panel( srcport_panel, "Upper", GLUI_SPINNER_INT, &(ATCP.UpperSrcPort), 0, redraw_func);
	srcport_upper_spinner->set_int_limits(0,65536);
	srcport_upper_spinner->set_int_val(ATCP.UpperSrcPort);
	srcport_lower_spinner = zoom_glui->add_spinner_to_panel( srcport_panel, "Lower", GLUI_SPINNER_INT, &(ATCP.LowerSrcPort), 0, redraw_func);
	srcport_lower_spinner->set_int_limits(0,65536);
	srcport_lower_spinner->set_int_val(ATCP.LowerSrcPort);


	GLUI_Panel *uppersrcip_panel = zoom_glui->add_panel_to_panel( zoom_panel1, "Upper Src IP" );
	srcip_upper0_spinner = zoom_glui->add_spinner_to_panel( uppersrcip_panel, "", GLUI_SPINNER_INT, &temp, 0, uppersrcip_cb);
	srcip_upper1_spinner = zoom_glui->add_spinner_to_panel( uppersrcip_panel, ".", GLUI_SPINNER_INT, &temp, 1, uppersrcip_cb);
	srcip_upper2_spinner = zoom_glui->add_spinner_to_panel( uppersrcip_panel, ".", GLUI_SPINNER_INT, &temp, 2, uppersrcip_cb);
	srcip_upper3_spinner = zoom_glui->add_spinner_to_panel( uppersrcip_panel, ".", GLUI_SPINNER_INT, &temp, 3, uppersrcip_cb);
	srcip_upper0_spinner->set_int_limits(0,255);
	srcip_upper1_spinner->set_int_limits(0,255);
	srcip_upper2_spinner->set_int_limits(0,255);
	srcip_upper3_spinner->set_int_limits(0,255);
	srcip_upper0_spinner->set_int_val((int)ATCP.UpperSrcIP[0]);
	srcip_upper1_spinner->set_int_val((int)ATCP.UpperSrcIP[1]);
	srcip_upper2_spinner->set_int_val((int)ATCP.UpperSrcIP[2]);
	srcip_upper3_spinner->set_int_val((int)ATCP.UpperSrcIP[3]);

	
	GLUI_Panel *lowersrcip_panel = zoom_glui->add_panel_to_panel( zoom_panel1, "Lower Src IP" );
	srcip_lower0_spinner = zoom_glui->add_spinner_to_panel( lowersrcip_panel, "", GLUI_SPINNER_INT, &temp, 0, lowersrcip_cb);
	srcip_lower1_spinner = zoom_glui->add_spinner_to_panel( lowersrcip_panel, ".", GLUI_SPINNER_INT, &temp, 1, lowersrcip_cb);
	srcip_lower2_spinner = zoom_glui->add_spinner_to_panel( lowersrcip_panel, ".", GLUI_SPINNER_INT, &temp, 2, lowersrcip_cb);
	srcip_lower3_spinner = zoom_glui->add_spinner_to_panel( lowersrcip_panel, ".", GLUI_SPINNER_INT, &temp, 3, lowersrcip_cb);
	srcip_lower0_spinner->set_int_limits(0,255);
	srcip_lower1_spinner->set_int_limits(0,255);
	srcip_lower2_spinner->set_int_limits(0,255);
	srcip_lower3_spinner->set_int_limits(0,255);
	srcip_lower0_spinner->set_int_val((int)ATCP.LowerSrcIP[0]);
	srcip_lower1_spinner->set_int_val((int)ATCP.LowerSrcIP[1]);
	srcip_lower2_spinner->set_int_val((int)ATCP.LowerSrcIP[2]);
	srcip_lower3_spinner->set_int_val((int)ATCP.LowerSrcIP[3]);


	GLUI_Panel *dstport_panel = zoom_glui->add_panel_to_panel( zoom_panel1, "Dst Port" );
	dstport_upper_spinner = zoom_glui->add_spinner_to_panel( dstport_panel, "Upper", GLUI_SPINNER_INT, &(ATCP.UpperDstPort), 0, redraw_func);
	dstport_upper_spinner->set_int_limits(0,65536);
	dstport_upper_spinner->set_int_val(ATCP.UpperDstPort);
	dstport_lower_spinner = zoom_glui->add_spinner_to_panel( dstport_panel, "Lower", GLUI_SPINNER_INT, &(ATCP.LowerDstPort), 0, redraw_func);
	dstport_lower_spinner->set_int_limits(0,65536);
	dstport_lower_spinner->set_int_val(ATCP.LowerDstPort);


	GLUI_Panel *upperdstip_panel = zoom_glui->add_panel_to_panel( zoom_panel1, "Upper Dst IP" );
	dstip_upper0_spinner = zoom_glui->add_spinner_to_panel( upperdstip_panel, "", GLUI_SPINNER_INT, &temp, 0, upperdstip_cb);
	dstip_upper1_spinner = zoom_glui->add_spinner_to_panel( upperdstip_panel, ".", GLUI_SPINNER_INT, &temp, 1, upperdstip_cb);
	dstip_upper2_spinner = zoom_glui->add_spinner_to_panel( upperdstip_panel, ".", GLUI_SPINNER_INT, &temp, 2, upperdstip_cb);
	dstip_upper3_spinner = zoom_glui->add_spinner_to_panel( upperdstip_panel, ".", GLUI_SPINNER_INT, &temp, 3, upperdstip_cb);
	dstip_upper0_spinner->set_int_limits(0,255);
	dstip_upper1_spinner->set_int_limits(0,255);
	dstip_upper2_spinner->set_int_limits(0,255);
	dstip_upper3_spinner->set_int_limits(0,255);
	dstip_upper0_spinner->set_int_val((int)ATCP.UpperDstIP[0]);
	dstip_upper1_spinner->set_int_val((int)ATCP.UpperDstIP[1]);
	dstip_upper2_spinner->set_int_val((int)ATCP.UpperDstIP[2]);
	dstip_upper3_spinner->set_int_val((int)ATCP.UpperDstIP[3]);

	
	GLUI_Panel *lowerdstip_panel = zoom_glui->add_panel_to_panel( zoom_panel1, "Lower Dst IP" );
	dstip_lower0_spinner = zoom_glui->add_spinner_to_panel( lowerdstip_panel, "", GLUI_SPINNER_INT, &temp, 0, lowerdstip_cb);
	dstip_lower1_spinner = zoom_glui->add_spinner_to_panel( lowerdstip_panel, ".", GLUI_SPINNER_INT, &temp, 1, lowerdstip_cb);
	dstip_lower2_spinner = zoom_glui->add_spinner_to_panel( lowerdstip_panel, ".", GLUI_SPINNER_INT, &temp, 2, lowerdstip_cb);
	dstip_lower3_spinner = zoom_glui->add_spinner_to_panel( lowerdstip_panel, ".", GLUI_SPINNER_INT, &temp, 3, lowerdstip_cb);
	dstip_lower0_spinner->set_int_limits(0,255);
	dstip_lower1_spinner->set_int_limits(0,255);
	dstip_lower2_spinner->set_int_limits(0,255);
	dstip_lower3_spinner->set_int_limits(0,255);
	dstip_lower0_spinner->set_int_val((int)ATCP.LowerDstIP[0]);
	dstip_lower1_spinner->set_int_val((int)ATCP.LowerDstIP[1]);
	dstip_lower2_spinner->set_int_val((int)ATCP.LowerDstIP[2]);
	dstip_lower3_spinner->set_int_val((int)ATCP.LowerDstIP[3]);


	zoom_glui->hide();


	/******** Clean up ***********************************************/
	//glui->set_main_gfx_window( side_window );
	GLUI_Master.set_glutIdleFunc( myGlutIdle );
	glutMainLoop();

}

