
#ifndef PARCOORDS_H
#define PARCOORDS_H

#define MAX_NUM_AXES 32

#include "glut.h"
#include "glui.h"

class ParCoords {

public:

	int numaxes;
	float f;
	char axeslabels[MAX_NUM_AXES][32];
	float typecolors[MAX_NUM_AXES][3];
	float zoombounds[MAX_NUM_AXES][2]; // 0 is upper, 1 is lower
	float zoomoriginals[MAX_NUM_AXES][2];
	char zoomlabels[MAX_NUM_AXES][2][64];
	int selectedbound[2]; // first entry is the axis, second entry: 0 is upper, 1 is lower


	int labelvalues[MAX_NUM_AXES];
	char valuelabels[MAX_NUM_AXES][32][32];

	int labelattacks[MAX_NUM_AXES];
	int attackindlabels[MAX_NUM_AXES][32]; // for each axis, the integer (type) labels of attacks
	char attacklabels[MAX_NUM_AXES][32][32]; // for each axis, the string labels of attacks
	float attackycoords[MAX_NUM_AXES][32];
	int numattacklabels[MAX_NUM_AXES];
	float priorities[MAX_NUM_AXES][32];


	ParCoords() : numaxes(0) { };

	void SetNumAxes(int n) {
		numaxes = n;
		f = 1.0/(float)(numaxes-1);
	};

	void ResetValueLabels() {
		int i, j;
		for (i=0;i<MAX_NUM_AXES;i++) {
			numattacklabels[i] = 0;	
			for (j=0;j<32;j++) priorities[i][j] = 0;
		}
	};

	void ToggleLabelAxis(float x, float y) {
		int a;
		a = (int)((x+0.05)/f);
		if ((a>=0) && (a<numaxes)) {
			labelvalues[a] = 1 - labelvalues[a];
		}

	};

	void ToggleLabelAttackAxis(float x, float y) {
		int a;
		a = (int)((x+0.05)/f);
		if ((a>=0) && (a<numaxes)) {
			labelattacks[a] = 1 - labelattacks[a];
		}
	};


	void SelectBound(float x, float y) {
		int a;
		float diff1, diff2;
		a = (int)((x+0.05)/f);
		if ((a>=0) && (a<numaxes) && ((x/f-(float)a) < 0.1)) {
			selectedbound[0] = a;
			diff1 = y - zoombounds[a][0];
			if (diff1 < 0.0) diff1 = -diff1;
			diff2 = y - zoombounds[a][1];
			if (diff2 < 0.0) diff2 = -diff2;
			if (diff1 < diff2) {
				selectedbound[1] = 0;
			} else {
				selectedbound[1] = 1;
			}
		} else {
			selectedbound[0] = -1;
		}
	};

	void MoveBound(float x, float y) {
		if ((selectedbound[0]>=0) && (selectedbound[0]<numaxes)) {
			zoombounds[selectedbound[0]][selectedbound[1]] = y;
		}
	};

	void SetZoomOriginals(int a, int ul, float v, char *label) {
		zoomoriginals[a][ul] = v;
		strcpy(zoomlabels[a][ul], label);
	};
	
	void SetZoomBounds(int a, int ul, float v) {
		zoombounds[a][ul] = v;
	};

	void Init() {

		int i;

		strcpy(axeslabels[0],"src port");
		strcpy(axeslabels[1],"src ip");
		strcpy(axeslabels[2],"dst ip");
		strcpy(axeslabels[3],"dst port");

		typecolors[0][0] = 1.0;
		typecolors[0][1] = 0.0;
		typecolors[0][2] = 0.0;

		typecolors[1][0] = 0.0;
		typecolors[1][1] = 1.0;
		typecolors[1][2] = 0.0;
		
		typecolors[2][0] = 0.0;
		typecolors[2][1] = 0.0;
		typecolors[2][2] = 1.0;

		typecolors[3][0] = 0.0;
		typecolors[3][1] = 0.5;
		typecolors[3][2] = 0.5;
		
		typecolors[4][0] = 0.5;
		typecolors[4][1] = 0.5;
		typecolors[4][2] = 0.0;
		
		typecolors[5][0] = 0.5;
		typecolors[5][1] = 0.0;
		typecolors[5][2] = 0.5;
		
		typecolors[6][0] = 0.0;
		typecolors[6][1] = 0.5;
		typecolors[6][2] = 0.5;
		
		typecolors[7][0] = 0.2;
		typecolors[7][1] = 0.0;
		typecolors[7][2] = 0.7;
		
		typecolors[8][0] = 0.7;
		typecolors[8][1] = 0.0;
		typecolors[8][2] = 0.2;

		typecolors[9][0] = 0.2;
		typecolors[9][1] = 0.7;
		typecolors[9][2] = 0.0;

		typecolors[10][0] = 0.7;
		typecolors[10][1] = 0.2;
		typecolors[10][2] = 0.0;

		typecolors[11][0] = 0.0;
		typecolors[11][1] = 0.2;
		typecolors[11][2] = 0.7;

		typecolors[12][0] = 0.0;
		typecolors[12][1] = 0.7;
		typecolors[12][2] = 0.2;

		typecolors[13][0] = 1.0;
		typecolors[13][1] = 0.2;
		typecolors[13][2] = 0.7;

		typecolors[14][0] = 1.0;
		typecolors[14][1] = 0.7;
		typecolors[14][2] = 0.2;

		typecolors[15][0] = 0.2;
		typecolors[15][1] = 0.7;
		typecolors[15][2] = 1.0;

		typecolors[16][0] = 0.7;
		typecolors[16][1] = 0.2;
		typecolors[16][2] = 1.0;

		typecolors[17][0] = 0.7;
		typecolors[17][1] = 1.0;
		typecolors[17][2] = 0.2;
		
		typecolors[18][0] = 0.2;
		typecolors[18][1] = 1.0;
		typecolors[18][2] = 0.7;
		
		typecolors[19][0] = 1.0;
		typecolors[19][1] = 1.0;
		typecolors[19][2] = 0.0;
		
		typecolors[20][0] = 1.0;
		typecolors[20][1] = 0.0;
		typecolors[20][2] = 1.0;
		
		typecolors[21][0] = 0.0;
		typecolors[21][1] = 1.0;
		typecolors[21][2] = 1.0;

		for (i=0;i<MAX_NUM_AXES;i++) {
			labelvalues[i] = 0;
			labelattacks[i] = 0;
		}

	};

	void DrawAxes() {

		int i,j,k;
		char show_str[32];
		char attack_str[32];
		
		strcpy(show_str,"label values");
		strcpy(attack_str,"label attacks");

		glLineWidth(2);
		for (i=0;i<numaxes;i++) {
			glColor3f(0.0f,1.0f,0.3f);
			glBegin(GL_LINES);
			glVertex3f(f*(float)i,0.0f,0.1f);
			glVertex3f(f*(float)i,1.0f,0.1f);
			glEnd();

			glColor3f(0.0f,0.0f,0.0f);
			for (k=0;k<strlen(axeslabels[i]);k++) {
				glRasterPos3f(f*(float)i+0.01*(float)k,1.0f,1.0f);
				glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,axeslabels[i][k]);	
			}
	

			if (labelvalues[i]) {
				glColor3f(1.0,0.0,0.0);
			} else {
				glColor3f(0.7,0.7,0.7);
			}
			glBegin(GL_QUADS);
			glVertex3f(f*(float)i,1.05,0.0f);
			glVertex3f(f*(float)i+0.01,1.05,0.0f);
			glVertex3f(f*(float)i+0.01,1.06,0.0f);
			glVertex3f(f*(float)i,1.06,0.0f);
			glEnd();

			glColor3f(0.0f,0.0f,0.0f);
			for (k=0;k<strlen(show_str);k++) {
				glRasterPos3f(0.02 + f*(float)i+0.01*(float)k,1.05f,1.0f);
				glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,show_str[k]);	
			}

			if (labelvalues[i]) {
				for (j=0;j<numattacklabels[i];j++) {
					for (k=0;k<strlen(valuelabels[i][j]);k++) {
						glRasterPos3f(0.02 + f*(float)i+0.01*(float)k,
										attackycoords[i][j],1.0f);
						glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,valuelabels[i][j][k]);	
					}
				}
			}



			if (labelattacks[i]) {
				glColor3f(1.0,0.0,0.0);
			} else {
				glColor3f(0.7,0.7,0.7);
			}
			glBegin(GL_QUADS);
			glVertex3f(f*(float)i,1.15,0.0f);
			glVertex3f(f*(float)i+0.01,1.15,0.0f);
			glVertex3f(f*(float)i+0.01,1.16,0.0f);
			glVertex3f(f*(float)i,1.16,0.0f);
			glEnd();

			glColor3f(0.0f,0.0f,0.0f);
			for (k=0;k<strlen(attack_str);k++) {
				glRasterPos3f(0.02 + f*(float)i+0.01*(float)k,1.15f,1.0f);
				glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,attack_str[k]);	
			}

			if (labelattacks[i]) {
				for (j=0;j<numattacklabels[i];j++) {
					
					glColor3f(typecolors[attackindlabels[i][j]][0], typecolors[attackindlabels[i][j]][1], 
						typecolors[attackindlabels[i][j]][2]);

					for (k=0;k<strlen(attacklabels[i][j]);k++) {
						glRasterPos3f(0.02 + f*(float)i+0.01*(float)k,
										attackycoords[i][j],1.0f);
						glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,attacklabels[i][j][k]);	
					}
				}
			}

		}


		for (i=0;i<numaxes;i++) {
			glColor3f(0.0f,0.0f,1.0f);
			glBegin(GL_LINES);
			glVertex3f(f*((float)i-0.02),zoombounds[i][0],0.1f);
			glVertex3f(f*((float)i+0.02),zoombounds[i][0],0.1f);
			glVertex3f(f*((float)i-0.02),zoombounds[i][1],0.1f);
			glVertex3f(f*((float)i+0.02),zoombounds[i][1],0.1f);
			glEnd();
			
			glBegin(GL_QUADS);
			glColor3f(0.8f,0.8f,1.0f);
			glVertex3f(f*((float)i-0.02),zoomoriginals[i][0],0.1f);
			glVertex3f(f*((float)i+0.02),zoomoriginals[i][0],0.1f);
			glColor3f(0.5f,0.5f,1.0f);
			glVertex3f(f*((float)i+0.02),zoombounds[i][0],0.1f);
			glVertex3f(f*((float)i-0.02),zoombounds[i][0],0.1f);
			glBegin(GL_QUADS);
			glColor3f(0.8f,0.8f,1.0f);
			glVertex3f(f*((float)i-0.02),zoomoriginals[i][1],0.1f);
			glVertex3f(f*((float)i+0.02),zoomoriginals[i][1],0.1f);
			glColor3f(0.5f,0.5f,1.0f);
			glVertex3f(f*((float)i+0.02),zoombounds[i][1],0.1f);
			glVertex3f(f*((float)i-0.02),zoombounds[i][1],0.1f);
			glEnd();

			for (k=0;k<strlen(zoomlabels[i][0]);k++) {
				glRasterPos3f(f*(float)i+0.02+0.01*(float)k,zoombounds[i][0],1.0f);
				glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,zoomlabels[i][0][k]);	
			}
			for (k=0;k<strlen(zoomlabels[i][1]);k++) {
				glRasterPos3f(f*(float)i+0.02+0.01*(float)k,zoombounds[i][1],1.0f);
				glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,zoomlabels[i][1][k]);	
			}
		}

	};

	/*

	// this one is without zoom
	void DrawPolyLine(float *entry, int c) {
		int i;
		glLineWidth(1);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(typecolors[c][0],typecolors[c][1],typecolors[c][2],0.5f);
		glBegin(GL_LINE_STRIP);
		for (i=0;i<numaxes;i++) {
			glVertex3f(f*(float)i,entry[i],entry[i]);
		}
		glEnd();
		glDisable(GL_BLEND);
	};

  
	void DrawOneLine(int ind1, float val1, int ind2, float val2, int c) {
		glLineWidth(1);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(typecolors[c][0],typecolors[c][1],typecolors[c][2],0.5);
		glBegin(GL_LINES);
		glVertex3f(f*(float)ind1,val1,val1);
		glVertex3f(f*(float)ind2,val2,val2);
		glEnd();
		glDisable(GL_BLEND);
	};

	*/

	void SetDisplayColor(int t) {
		glColor4f(typecolors[t][0],typecolors[t][1],typecolors[t][2],0.5f);
	}

	/*
	void AddValueLabel(int a, float ycoord, char *str, float priority) {

		int i, found;

		found = 0;
		for (i=0;i<numvaluelabels[a];i++) {
			if ((valueycoords[a][i] > ycoord - 0.02) &&
				(valueycoords[a][i] < ycoord + 0.02)) {
				found = 1;
			}
		}

		if (found==0) {
			strcpy(valuelabels[a][numvaluelabels[a]],str);
			valueycoords[a][numvaluelabels[a]] = ycoord;
			numvaluelabels[a]++;
		}

	};
*/

	void AddAttackLabel(int a, float ycoord, int type, char *vstr, char *astr, float priority) {

		int i, found, done;

		found = 0;
		done = 0;

		for (i=0;(i<numattacklabels[a])&&(done==0);i++) {
			if ((attackycoords[a][i] > ycoord - 0.02) &&
				(attackycoords[a][i] < ycoord + 0.02)) {
				if (priorities[a][i] < priority) {
					attackindlabels[a][i] = type;
					strcpy(attacklabels[a][i], astr);
					strcpy(valuelabels[a][i], vstr);
					priorities[a][i] = priority;
					done = 1;
				}
				found = 1;
			}
		}

		if (found==0) {
			attackindlabels[a][numattacklabels[a]] = type;
			strcpy(attacklabels[a][numattacklabels[a]], astr);
			attackycoords[a][numattacklabels[a]] = ycoord;
			priorities[a][numattacklabels[a]] = priority;

			strcpy(valuelabels[a][numattacklabels[a]],vstr);

			numattacklabels[a]++;
		}

	};

/*
	void DrawPolyLine(float *entry, int c, char **strs, char **attackstrs) {
		int i;
		float adjustedvalue;
		glLineWidth(2);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		SetDisplayColor(c);
		//glColor4f(typecolors[c][0],typecolors[c][1],typecolors[c][2],0.5f);
		glBegin(GL_LINE_STRIP);
		for (i=0;i<numaxes;i++) {
			adjustedvalue = entry[i];
			if (adjustedvalue > zoomoriginals[i][0]) { // if bigger than upper
				if ((1.0 - zoomoriginals[i][0]) > 0.001) {
					adjustedvalue = zoombounds[i][0] + (1.0 - zoombounds[i][0])
						* (adjustedvalue - zoomoriginals[i][0])/(1.0 - zoomoriginals[i][0]);
				}
			} else if (adjustedvalue > zoomoriginals[i][1]) { // if between upper and lower
				if ((zoomoriginals[i][0] - zoomoriginals[i][1]) > 0.001) {
					adjustedvalue = zoombounds[i][1] + (zoombounds[i][0] - zoombounds[i][1])
						* (adjustedvalue - zoomoriginals[i][1])/(zoomoriginals[i][0] - zoomoriginals[i][1]);
				}
			} else { // if less than lower
				if (zoomoriginals[i][1] > 0.001) {
					adjustedvalue = zoombounds[i][1] * adjustedvalue/zoomoriginals[i][1];
				}
			}
			glVertex3f(f*(float)i,adjustedvalue,adjustedvalue);
			AddValueLabel(i,adjustedvalue,strs[i]);
		}
		glEnd();
		glDisable(GL_BLEND);
	};
*/


	void DrawOneLine(int ind1, float val1, int ind2, float val2, int c, char *str1, char *str2, char *attackstr) {
		
		float adjustedvalue1, adjustedvalue2;
		float priority;

		adjustedvalue1 = val1;
		if (adjustedvalue1 > zoomoriginals[ind1][0]) { // if bigger than upper
			if ((1.0 - zoomoriginals[ind1][0]) > 0.001) {
				adjustedvalue1 = zoombounds[ind1][0] + (1.0 - zoombounds[ind1][0])
					* (adjustedvalue1 - zoomoriginals[ind1][0])/(1.0 - zoomoriginals[ind1][0]);
			}
		} else if (adjustedvalue1 > zoomoriginals[ind1][1]) { // if between upper and lower
			if ((zoomoriginals[ind1][0] - zoomoriginals[ind1][1]) > 0.001) {
				adjustedvalue1 = zoombounds[ind1][1] + (zoombounds[ind1][0] - zoombounds[ind1][1])
					* (adjustedvalue1 - zoomoriginals[ind1][1])/(zoomoriginals[ind1][0] - zoomoriginals[ind1][1]);
			}
		} else { // if less than lower
			if (zoomoriginals[ind1][1] > 0.001) {
				adjustedvalue1 = zoombounds[ind1][1] * adjustedvalue1/zoomoriginals[ind1][1];
			}
		}
		

		adjustedvalue2 = val2;
		if (adjustedvalue2 > zoomoriginals[ind2][0]) { // if bigger than upper
			if ((1.0 - zoomoriginals[ind2][0]) > 0.001) {
				adjustedvalue2 = zoombounds[ind2][0] + (1.0 - zoombounds[ind2][0])
					* (adjustedvalue2 - zoomoriginals[ind2][0])/(1.0 - zoomoriginals[ind2][0]);
			}
		} else if (adjustedvalue2 > zoomoriginals[ind2][1]) { // if between upper and lower
			if ((zoomoriginals[ind2][0] - zoomoriginals[ind2][1]) > 0.001) {
				adjustedvalue2 = zoombounds[ind2][1] + (zoombounds[ind2][0] - zoombounds[ind2][1])
					* (adjustedvalue2 - zoomoriginals[ind2][1])/(zoomoriginals[ind2][0] - zoomoriginals[ind2][1]);
			}
		} else { // if less than lower
			if (zoomoriginals[ind2][1] > 0.001) {
				adjustedvalue2 = zoombounds[ind2][1] * adjustedvalue2/zoomoriginals[ind2][1];
			}
		}

		priority = 0.01*(float)(rand()%100);

		AddAttackLabel(ind1,adjustedvalue1,c,str1,attackstr,priority);
		AddAttackLabel(ind2,adjustedvalue2,c,str2,attackstr,priority);

		glLineWidth(2);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		SetDisplayColor(c);
		glBegin(GL_LINES);
		glVertex3f(f*(float)ind1,adjustedvalue1,priority);
		glVertex3f(f*(float)ind2,adjustedvalue2,priority);
		glEnd();
		glDisable(GL_BLEND);
	};


};

#endif

