
#include <string.h>
#include "parplanes.h"
#include "parcoords.h"

extern ParCoords P;

ParPlanes::ParPlanes() {

}

void ParPlanes::SetAxisLabels(char *x1, char *y1, char *x2, char *y2) {
	strcpy(plane1_xlabel, x1);
	strcpy(plane1_ylabel, y1);
	strcpy(plane2_xlabel, x2);
	strcpy(plane2_ylabel, y2);
}

void ParPlanes::DrawOneLine(float x1, float y1, float x2, float y2, int c) {

	glColor4f(P.typecolors[c][0],P.typecolors[c][1],P.typecolors[c][2],0.5);
	glLineWidth(2);
	glBegin(GL_LINES);
	glVertex3f(0.0, x1, y1);
	glVertex3f(1.0, x2, y2);
	glEnd();

}

void ParPlanes::DrawPlanes() {

	int i;
	
	glColor3f(0.0f,0.0f,0.0f);
	glBegin(GL_LINES);
	glVertex3f(0.0,0.0,-0.1);
	glVertex3f(0.0,1.0,-0.1);
	glEnd();
	for (i=0;i<strlen(plane1_xlabel);i++) {
		glRasterPos3f(0.0 + (float)i*0.02,1.0,-0.1);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,plane1_xlabel[i]);	
	}

	glBegin(GL_LINES);
	glVertex3f(0.0,-0.1,0.0);
	glVertex3f(0.0,-0.1,1.0);
	glEnd();
	for (i=0;i<strlen(plane1_ylabel);i++) {
		glRasterPos3f(0.0 + (float)i*0.02,-0.1,1.0);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,plane1_ylabel[i]);	
	}
	
	glBegin(GL_LINES);
	glVertex3f(1.0,0.0,-0.1);
	glVertex3f(1.0,1.0,-0.1);
	glEnd();
	for (i=0;i<strlen(plane2_xlabel);i++) {
		glRasterPos3f(1.0 + (float)i*0.02,1.0,-0.1);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,plane2_xlabel[i]);	
	}
	
	glBegin(GL_LINES);
	glVertex3f(1.0,-0.1,0.0);
	glVertex3f(1.0,-0.1,1.0);
	glEnd();
	for (i=0;i<strlen(plane2_ylabel);i++) {
		glRasterPos3f(1.0 + (float)i*0.02,-0.1,1.0);
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_10,plane2_ylabel[i]);	
	}


	glColor3f(0.8,0.8,0.8);

	glBegin(GL_QUADS);
	glVertex3f(0.0,0.0,0.0);
	glVertex3f(0.0,0.0,1.0);
	glVertex3f(0.0,1.0,1.0);
	glVertex3f(0.0,1.0,0.0);
	glEnd();

	glBegin(GL_QUADS);
	glVertex3f(1.0,0.0,0.0);
	glVertex3f(1.0,0.0,1.0);
	glVertex3f(1.0,1.0,1.0);
	glVertex3f(1.0,1.0,0.0);
	glEnd();

}

