
#include <stdio.h>

#include "quadtree.h"


QuadTree::QuadTree() : side(512) {

}

int QuadTree::UpdateNextBit(unsigned char *ip, int &n) {
	int a, b;
	a = n/8;
	b = 7 - n%8;
	n++;
	return ((int)(ip[a] >> b)) & 1;

}


void QuadTree::IPtoQuad(unsigned char *ip, int *qpos) {

	int xoff, yoff, csize;
	int nextbit;

	xoff = yoff = 0;
	csize = side;
	nextbit = 0;

	while (csize>1) {
		csize = csize / 2;
		if (UpdateNextBit(ip, nextbit)==1) {
			xoff = xoff + csize;
		}
		if (UpdateNextBit(ip, nextbit)==1) {
			yoff = yoff + csize;
		}
	}
	
	qpos[0] = xoff;
	qpos[1] = yoff;

	printf("ip %d.%d.%d.%d position %d %d\n", (int)ip[0],
		(int)ip[1], (int)ip[2], (int)ip[3], qpos[0], qpos[1]);

}

