
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tcpdump_data.h"


TCPdump_data::TCPdump_data() : num_dstPorts(0) {
	
}

void TCPdump_data::AddDstPort(int p) {

	if (num_dstPorts < MAX_DST_PORTS) {
		dstPorts[num_dstPorts] = p;
		num_dstPorts++;
	} else {
		printf("exceeded %d destination ports. ignored.\n", MAX_DST_PORTS);
	}

}


double TCPdump_data::IPtoFloat(int sd) {
	if (sd==0) {
		return ((double)(srcIP[3]) + 256.0 * ((double)(srcIP[2]) + 256.0 * ((double)(srcIP[1]) + (256.0 * (double)(srcIP[0])))))/(256.0*256.0*256.0*256.0);
	} else {
		return ((double)(dstIP[3]) + 256.0 * ((double)(dstIP[2]) + 256.0 * ((double)(dstIP[1]) + (256.0 * (double)(dstIP[0])))))/(256.0*256.0*256.0*256.0);
	}
}


void TCPdump_data::IPtoText(int sd, char *buf) {
	if (sd==0) {
		sprintf(buf,"%d.%d.%d.%d", srcIP[0], srcIP[1], srcIP[2], srcIP[3]);
	} else if (sd==1) {
		sprintf(buf,"%d.%d.%d.%d", dstIP[0], dstIP[1], dstIP[2], dstIP[3]);
	}
}

void TCPdump_data::AddManyDstPorts(int p) {

	long int i;
	for (i=dstPorts[num_dstPorts-1]+1;i<=p;i++) AddDstPort(i);

}

void TCPdump_data::Print() {

	int i;

	printf("new entry\n");
	printf("  timestamp %d\n", timestamp);
	printf("  type %d\n", type);
	printf("  source IP addr %d %d %d %d\n", srcIP[0], srcIP[1], srcIP[2], srcIP[3]);
	printf("  dest IP addr %d %d %d %d\n", dstIP[0], dstIP[1], dstIP[2], dstIP[3]);
	printf("  source port %d\n", srcPort);
	printf("  dest ports ");
	for (i=0; i<num_dstPorts; i++) printf("%d ", dstPorts[i]);
	printf("\n");

}

void TCPdump_data::ReadIP(char *buf, int sd) {

	char tempbuf[8];
	int i, j, k;
	int tempint;

	j = 0;
	for (i=0;i<4;i++) {
		k = 0;
		while((j<strlen(buf))&&(buf[j]!='.')) {
			tempbuf[k] = buf[j];
			j++; k++;
		}
		j++;
		tempbuf[k] = '\0';
		sscanf(tempbuf,"%d",&tempint);
		if (sd==0) {
			srcIP[i] = (unsigned char)tempint;
		} else {
			dstIP[i] = (unsigned char)tempint;
		}
	}
}

All_TCPdump_data::All_TCPdump_data() : numentries(0) {

}

void All_TCPdump_data::Init() {

	UpperSrcIP[0] = UpperDstIP[0] = (unsigned char)128;
	LowerSrcIP[0] = LowerDstIP[0] =(unsigned char)64;
	UpperSrcPort = UpperDstPort = 1024;
	LowerSrcPort = LowerDstPort = 0;

	strcpy(attack_str[0],"UdpPortScan");
	strcpy(attack_str[1],"TcpPortScan");
	strcpy(attack_str[2],"TraceRoute");
	strcpy(attack_str[3],"RpcPortmapDump");
	strcpy(attack_str[4],"FtpPortBounce");
	strcpy(attack_str[5],"DnsZonexfrHigh");
	num_attack_type = 6;

	strcpy(attack_str[0],"TELNETaccess");
	strcpy(attack_str[1],"POLICYFTPanonymousloginattempt");
	strcpy(attack_str[2],"CHATIRCnickchange");
	strcpy(attack_str[3],"CHATIRCmessage");
	strcpy(attack_str[4],"SMTPrcpttosedcommandattempt");
	strcpy(attack_str[5],"NETBIOSNTNULLsession");
	strcpy(attack_str[6],"(spp_frag2)Teardropattack");
	strcpy(attack_str[7],"P2PGNUTellaGET");
	strcpy(attack_str[8],"TELNETloginincorrect");
	strcpy(attack_str[9],"ATTACK-RESPONSESdirectorylisting");
	strcpy(attack_str[10],"MISCTinyFragments");
	strcpy(attack_str[11],"SHELLCODEx86incebxNOOP");
	strcpy(attack_str[12],"X11xopen");
	strcpy(attack_str[13],"WEB-MISC/doc/access");
	strcpy(attack_str[14],"WEB-MISCwhiskerspacespliceattack");
	strcpy(attack_str[15],"WEB-MISCapacheDOSattempt");
	strcpy(attack_str[16],"SNMPtraptcp");
	strcpy(attack_str[17],"MISCsourceport53to<1024");
	strcpy(attack_str[18],"WEB-MISCbackupaccess");
	strcpy(attack_str[19],"FTP.rhosts");
	strcpy(attack_str[20],"SNMPrequesttcp");
	strcpy(attack_str[21],"SNMPAgentX/tcprequest");
	num_attack_type = 22;


}

void All_TCPdump_data::IPtoText(int sd, char *buf) {
	if (sd==0) {
		sprintf(buf,"%d.%d.%d.%d", UpperSrcIP[0], UpperSrcIP[1], UpperSrcIP[2], UpperSrcIP[3]);
	} else if (sd==1) {
		sprintf(buf,"%d.%d.%d.%d", LowerSrcIP[0], LowerSrcIP[1], LowerSrcIP[2], LowerSrcIP[3]);
	} else if (sd==2) {
		sprintf(buf,"%d.%d.%d.%d", UpperDstIP[0], UpperDstIP[1], UpperDstIP[2], UpperDstIP[3]);
	} else {
		sprintf(buf,"%d.%d.%d.%d", LowerDstIP[0], LowerDstIP[1], LowerDstIP[2], LowerDstIP[3]);
	}
}

double All_TCPdump_data::IPtoFloat(int sd) {
	if (sd==0) {
		return ((double)(UpperSrcIP[3]) + 256.0 * ((double)(UpperSrcIP[2]) + 256.0 * ((double)(UpperSrcIP[1]) + (256.0 * (double)(UpperSrcIP[0])))))/(256.0*256.0*256.0*256.0);
	} else if (sd==1) {
		return ((double)(LowerSrcIP[3]) + 256.0 * ((double)(LowerSrcIP[2]) + 256.0 * ((double)(LowerSrcIP[1]) + (256.0 * (double)(LowerSrcIP[0])))))/(256.0*256.0*256.0*256.0);
	} else if (sd==2) {
		return ((double)(UpperDstIP[3]) + 256.0 * ((double)(UpperDstIP[2]) + 256.0 * ((double)(UpperDstIP[1]) + (256.0 * (double)(UpperDstIP[0])))))/(256.0*256.0*256.0*256.0);
	} else {
		return ((double)(LowerDstIP[3]) + 256.0 * ((double)(LowerDstIP[2]) + 256.0 * ((double)(LowerDstIP[1]) + (256.0 * (double)(LowerDstIP[0])))))/(256.0*256.0*256.0*256.0);
	}
}



void All_TCPdump_data::PrintAllEntries() {
	long int i;
	for (i=0; i<numentries; i++) t_array[i].Print();
}


int All_TCPdump_data::ClassifyAttack2(char *text) {

	int i;
	for (i=0;i<num_attack_type;i++) {
		if (strcmp(attack_str[i],text)==0) {
			return i;
		}
	}
	printf("unclassified %s\n", text);
	return -1;

}


void TCPdump_data::ReadIP2(char *strptr, int sd) {

	int   ip[4];
	int   i;
	char  c;

	sscanf(strptr, "%d%c%d%c%d%c%d", 
		   &ip[0], &c, &ip[1], &c, &ip[2], &c, &ip[3] );
  
	if (sd==0) {
		for ( i = 0; i < 4; i++ ) {
			srcIP[i] = (unsigned char)ip[i];
		}
	} 
	else {
		for ( i = 0; i < 4; i++ ) {
			dstIP[i] = (unsigned char)ip[i];
		}
	}
}


void TCPdump_data::DstPorts(char *portstr) {

	int    i, j, tcp_port, tcp_port2, itvls;
	char   *ptr1, *ptr2;
	
	
	sscanf(portstr,"%d",&tcp_port);

	itvls = 1;
    ptr2 = strchr(portstr, '|');
	while ( ptr2 != NULL ) {
		itvls++;
		ptr2++;
		ptr2 = strchr(ptr2, '|');
	}

	if ( (ptr1 = strchr(portstr, '-')) != NULL && 
		 (ptr2 = strchr(portstr, '|')) != NULL ) {
		for ( j = 1; j < itvls; j++) {
			 if ( ptr1 != NULL && (int)ptr1 < (int)ptr2 ) {
			    ptr1++;
			    sscanf(ptr1, "%d", &tcp_port2);
				ptr1 = strchr(ptr1, '-');
				for (i = tcp_port; i <= tcp_port2; i++ ) {
					AddDstPort(i);
				}
				// if ( ptr2 != NULL ) {
					ptr2++;
					sscanf(ptr2, "%d", &tcp_port);
					ptr2 = strchr (ptr2, '|');
				// }
			 }
			 else {
				 AddDstPort(tcp_port);
				 ptr2++;
				 sscanf(ptr2, "%d", &tcp_port);
				 ptr2 = strchr (ptr2, '|');
			 }
		}
		// deal with the last interval
		if ( ptr1 != NULL ) {
			ptr1++;
			sscanf(ptr1, "%d", &tcp_port2);
			for (i = tcp_port; i <= tcp_port2; i++ ) {
					AddDstPort(i);
			}
		}
		else {
			AddDstPort(tcp_port);
		}
	}
	else if ( (ptr1 = strchr(portstr, '-')) != NULL ) {
		ptr1++;
		sscanf(ptr1, "%d", &tcp_port2);
		for ( i = tcp_port; i <= tcp_port2; i++) {
			AddDstPort(i);
		}
	}
	else if ( (ptr2 = strchr(portstr, '|')) != NULL ) {
		AddDstPort(tcp_port);
		while ( ptr2 != NULL ) {
			ptr2++;
			sscanf(ptr2, "%d", &tcp_port);
			AddDstPort(tcp_port);
			ptr2 = strchr(ptr2, '|');
		}
	}
	else {
		AddDstPort(tcp_port);
	}
}


void All_TCPdump_data::ReadData2() {

	FILE *fptr, *ofp;
	char event_buffer[1024];
	char atb_title[128], atb_value[256];
	char *token;
	int  n_tokens, token_length, eqloc, atb_val_length;
	int  has_srcIP, has_dstIP, has_srcPort, has_dstPort;
	int  i;

	static char whitespace[] = " {};>";

	fptr = fopen("../data/sample.txt","rt");
	ofp  = fopen("../data/warning.txt","w");


	while ( !feof(fptr) && 
		    numentries < MAX_ENTRIES &&
			fgets(event_buffer,1024,fptr) != NULL ) {
			
		has_srcIP   = 0;
		has_dstIP   = 0;
		has_srcPort = 0;
		has_dstPort = 0;

		n_tokens = 0;
		token = strtok(event_buffer, whitespace);
		
		//printf("=================================\n");
		
		while ( token != NULL ) {
			n_tokens++;
			token_length = strlen(token);
			// puts(token);

			// find the location of = sign 
			eqloc = strcspn(token, "=");
			// printf("***token length = %d\t", token_length);
			// printf("= locates at %d\n", eqloc);
		
			// ignore the token that has no = sign
			if ( eqloc <= token_length - 1 ) {
				
				// separate attribute title and attribute value
				strncpy(atb_title, token, eqloc);
				atb_title[eqloc] = '\0';
				
				atb_val_length = token_length - eqloc - 1;
				strncpy(atb_value, token + eqloc + 1, atb_val_length);
				atb_value[atb_val_length] = '\0';
				
				// i = strlen(atb_value);
				// puts(atb_title);
				// puts(atb_value);
				// printf("atb_value length = %d\n", atb_val_length);
				
			    // extract Time stamp
                if ( !(strcmp(atb_title, "Time")) ) {
					if ( atb_val_length > 0 ) {
						sscanf(atb_value,"%d",&(t_array[numentries].timestamp));
					}
					else {
						t_array[numentries].timestamp = 0;
					}
				}

				// extract Type
				else if ( !(strcmp(atb_title, "Type")) ) {
					if ( atb_val_length > 0 ) {
						t_array[numentries].type = ClassifyAttack2(atb_value);
					}
					else {
						t_array[numentries].type = -99;
					}
				}

				// extract FromIp
				else if ( !(strcmp(atb_title, "FromIp")) && 
					      atb_val_length > 0 ) {
					t_array[numentries].ReadIP(atb_value, 0);
					has_srcIP = 1;
				}

				else if ( ( has_srcIP == 0 ) && 
					      atb_val_length > 0 && 
					      !(strcmp(atb_title, "IntruderIpAddr")) ) {
					t_array[numentries].ReadIP(atb_value, 0);
					has_srcIP = 1;
				}


				// extract ToIp
				else if ( !(strcmp(atb_title, "ToIp")) && 
					      atb_val_length > 0 ) {
					t_array[numentries].ReadIP(atb_value, 1);
					has_dstIP = 1;
				}

				else if ( ( has_dstIP == 0 ) &&
					      atb_val_length > 0 &&
					      !(strcmp(atb_title, "VictimIpAddr")) ) {
						t_array[numentries].ReadIP(atb_value, 1);
						has_dstIP = 1;
				}

				// extract FromPort
				else if ( !(strcmp(atb_title, "FromPort")) &&
					      atb_val_length > 0 ) {
					sscanf(atb_value,"%d",&(t_array[numentries].srcPort));
					has_srcPort = 1;
				}

				else if ( has_srcPort == 0 &&
					      !(strcmp(atb_title, "IntruderPort")) &&
						  atb_val_length > 0 ) {
					sscanf(atb_value,"%d",&(t_array[numentries].srcPort));
					has_srcPort = 1;
				}

				// extract ToPort
				else if ( !(strcmp(atb_title, "ToPort")) && 
					      atb_val_length > 0 ) {
					t_array[numentries].DstPorts(atb_value);
					has_dstPort = 1;
				}

				// extract Port (DST Port)
				else if ( has_dstPort == 0 &&
					      !(strcmp(atb_title, "Port"))  &&
					      atb_val_length > 0 ) {
					t_array[numentries].DstPorts(atb_value);
					has_dstPort = 1;
				}

				// extract VictimPort (DST Port)
				else if ( has_dstPort == 0 &&
					      !(strcmp(atb_title, "VictimPort"))  &&
					      atb_val_length > 0 ) {
					t_array[numentries].DstPorts(atb_value);
					has_dstPort = 1;
				}

			}

			// read in next token 
			token = strtok(NULL, whitespace);
		}
		
		// printf("$$$ total tokens = %d\n", n_tokens);

		// print time stamp info
		if ( t_array[numentries].timestamp == 0 ) {
            printf("WARNING: No time stamp data\n");
		}
		else {
			//printf("timestamp = %lu\n", t_array[numentries].timestamp);
		}

		if ( t_array[numentries].type == -99 ) {
            printf("WARNING: No Type data\n");
		}
		else if ( t_array[numentries].type == -1 ) {
			printf("Type not in the lookup table\n");
		}
		else {
			//printf("attack type = %d\n", t_array[numentries].type);
		}

		if ( has_srcIP == 0 ) {
			printf("WARNING: No src ip data\n");
			for ( i = 0; i < 4; i++ ) {
				t_array[numentries].srcIP[i] = '\0';
			}
		}
		else {
			/*
			printf("src ip address %d %d %d %d\n", 
				    (int)t_array[numentries].srcIP[0],
			        (int)t_array[numentries].srcIP[1], 
					(int)t_array[numentries].srcIP[2], 
					(int)t_array[numentries].srcIP[3] );
					*/
		}

    	if ( has_dstIP == 0 ) {
			printf("WARNING: No dst ip data\n");
			for ( i = 0; i < 4; i++ ) {
				t_array[numentries].dstIP[i] = '\0';
			}

		}
		else {
			/*
			printf("dst ip address %d %d %d %d\n", 
				    (int)t_array[numentries].dstIP[0],
					(int)t_array[numentries].dstIP[1], 
					(int)t_array[numentries].dstIP[2], 
					(int)t_array[numentries].dstIP[3] );
			*/
		}

		if ( has_srcPort == 0 ) {
			t_array[numentries].srcPort = -1;
			printf("WARNING: No src port data\n");
		}
		else {
			//printf("src port = %d\n", t_array[numentries].srcPort);
		}

		if ( has_dstPort == 0 ) {
			t_array[numentries].AddDstPort(-1);
			printf("WARNING: No dst port data\n");
		}
		else {
			/*
			printf("no. of dst ports = %d\n", t_array[numentries].num_dstPorts);
			printf("dst port = ");
			for ( i = 0; i < t_array[numentries].num_dstPorts; i++ ) 
			    printf("%d\t", t_array[numentries].dstPorts[i]);
			printf("\n");
			*/
		}

		if ( has_srcIP == 0   ||
			 has_dstIP == 0   ||
			 has_srcPort == 0 ||
			 has_dstPort == 0 ||
			 t_array[numentries].num_dstPorts > 1000 ) {
			fprintf(ofp, "event id = %d\t timestamp = %d\t",
				    numentries, t_array[numentries].timestamp);
			if ( has_srcIP == 0 ) fprintf(ofp, "No src IP \t");
			if ( has_dstIP == 0 ) fprintf(ofp, "No dst IP \t");
            if ( has_srcPort == 0 ) fprintf(ofp, "No src Port \t");
			if ( has_dstPort == 0 ) fprintf(ofp, "No dst Port \t");
			if ( t_array[numentries].num_dstPorts > 1000 )
				fprintf(ofp, "More than 100 dst Ports \t");
			fprintf(ofp, "\n");
		}

		numentries++;
	}
	

	//PrintAllEntries();

	// put into bins
	int b, binrange, binstarttime, starti, eachbin;

	binrange = t_array[numentries-1].timestamp - t_array[0].timestamp;
	eachbin = binrange/512;
	starti = 0;
	binstarttime = t_array[0].timestamp;
	bins[0] = 0;
	for (b=1; b<512; b++) {
		binstarttime += eachbin;
		while ((t_array[starti].timestamp < binstarttime) && (starti < numentries)) starti++;
		bins[b] = starti;
		binsend[b-1] = starti - 1;
	}
	binsend[511] = numentries - 1;
	maxbin = 0;
	for (b=0;b<512;b++) {
		if ((binsend[b] - bins[b] + 1) > maxbin) maxbin = binsend[b] - bins[b] + 1;
	}

	fclose(fptr);
	fclose(ofp);

}

