
#ifndef TCPDUMP_DATA_H
#define TCPDUMP_DATA_H

#define MAX_DST_PORTS 1024
#define MAX_ENTRIES 100000

class TCPdump_data {

public:

	unsigned char srcIP[4];
	unsigned char dstIP[4];
	int srcPort;
	int num_dstPorts;
	int dstPorts[MAX_DST_PORTS];
	long int timestamp;
	int type;

	TCPdump_data();
	void ReadIP(char *buf, int sd);
	void ReadIP2(char *, int);
	void AddDstPort(int p);
	void AddManyDstPorts(int p);
	void DstPorts(char *);
	double IPtoFloat(int sd);
	void IPtoText(int sd, char *buf);
	void Print();

};


class All_TCPdump_data {

public:

	int bins[512];
	int binsend[512];
	int maxbin;
	long int numentries;
	TCPdump_data t_array[MAX_ENTRIES];

	// for zooming
	int UpperSrcPort, LowerSrcPort;
	int UpperDstPort, LowerDstPort;
	unsigned char UpperSrcIP[4];
	unsigned char LowerSrcIP[4];
	unsigned char UpperDstIP[4];
	unsigned char LowerDstIP[4];

	char attack_str[32][64];
	int num_attack_type;

	All_TCPdump_data();
	void Init();
	void IPtoText(int sd, char *buf);
	double IPtoFloat(int sd);
	//int ClassifyAttack(char *text);
	int ClassifyAttack2(char *);
	void PrintAllEntries();
	//void ReadData();
	void ReadData2();

};

#endif
