/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * bdt.c: Basic Data Types routines
 * Fistgen sources.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */


/*
 * check if we can add another BDT to a BDT list.
 * Return TRUE/FALSE if succeeded.
 * Note: this is an O(n^2) algorithm.
 */
int
append_to_bdt(bdt_t **bhead, const char *full_line, const char *symbol_name)
{
  bdt_t *tail = *bhead, *tmp = *bhead;

  /* look for duplicates */
  while (tmp) {
    if (STREQ(symbol_name, tmp->symbol_name))
      return FALSE;
    tmp = tmp->next;
  }

  /* find tail of BDT list */
  while (tail && tail->next) {
    tail = tail->next;
  }

  /* append a new cell */
  tmp = (bdt_t *) malloc(sizeof(bdt_t));
  if (!tmp) {
    fprintf(stderr, "no more memory for append_to_bdt\n");
    exit(1);
  }
  if (full_line)
    tmp->full_line = strdup(full_line);
  else
    tmp->full_line = NULL;

  tmp->symbol_name = strdup(symbol_name);
  tmp->next = NULL;

  /* link into list */
  if (tail)
    tail->next = tmp;
  else
    *bhead = tmp;		/* initialize BDT list */
  return TRUE;
}


/* display contents of bdt */
void
print_bdt(bdt_t *bhead)
{
  bdt_t *tmp = bhead;
  if (!tmp) {
    printf("BDT is null\n");
    return;
  }
  while (tmp) {
    printf("\tBDT:%s:\n", tmp->symbol_name);
    tmp = tmp->next;
  }
}


/* deallocate BDT structures and their components */
void
free_bdt_list(bdt_t **bhead)
{
  bdt_t *tmp = *bhead, *prev;

  if (!bhead || *bhead)
    return;

  /* BDT list has 2 or more items */
  prev = tmp;
  tmp = tmp->next;
  while (prev && tmp) {
    free(prev->full_line);
    free(prev->symbol_name);
    prev = tmp;
    tmp = tmp->next;
  }
  /* now free last (or only) cell */
  free(prev->full_line);
  free(prev->symbol_name);
  free(prev);
  tmp = prev = *bhead = NULL;
  return;
}


/*
 * Search for a key inside a given BDT.
 * Return TRUE/FALSE if key was found.
 */
int
fist_search_bdt(const char *str, bdt_t *bdt)
{
  bdt_t *tmp = bdt;

  while (tmp) {
    if (STREQ(str, tmp->symbol_name))
      return TRUE;
    tmp = tmp->next;
  }

  return FALSE;
}
